/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.table;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.ValidationResultModel;
import com.jgoodies.validation.view.ValidationComponentUtils;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.subjects.PublishSubject;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.text.Document;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.port.BytePortConfigValue;
import org.bidib.jbidibc.messages.port.Int16PortConfigValue;
import org.bidib.jbidibc.messages.port.PortConfigValue;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.component.SliderAndValuePanel;
import org.bidib.wizard.client.common.controller.NodeSelectionProvider;
import org.bidib.wizard.client.common.converter.StringToIntegerConverter;
import org.bidib.wizard.client.common.model.ServoPortTableModel;
import org.bidib.wizard.client.common.rxjava2.SwingScheduler;
import org.bidib.wizard.client.common.table.AbstractPortEditorPanel;
import org.bidib.wizard.client.common.table.listener.PortEditorPanelCallback;
import org.bidib.wizard.client.common.text.WizardBindings;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.view.validation.DefaultRangeValidationCallback;
import org.bidib.wizard.client.common.view.validation.IconFeedbackPanel;
import org.bidib.wizard.client.common.view.validation.IntegerInputValidationDocument;
import org.bidib.wizard.client.common.view.validation.PropertyValidationI18NSupport;
import org.bidib.wizard.client.common.view.validation.RangeValidationCallback;
import org.bidib.wizard.model.ports.BacklightPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.PortTypeAware;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.model.status.BacklightPortStatus;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.mvc.main.model.BacklightPortTableModel;
import org.bidib.wizard.mvc.main.view.component.BacklightSliderAndValuePanel;
import org.bidib.wizard.mvc.main.view.table.BacklightPortEditorPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BacklightPortEditorPanel
extends AbstractPortEditorPanel<BacklightPort> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BacklightPortEditorPanel.class);
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, fill:50dlu:grow";
    private static final String ENCODED_DIALOG_ROW_SPECS = "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref";
    private static final int TIME_BETWEEN_VALUE_EVENTS_MILLIS = 80;
    private static final int TIME_BETWEEN_PORT_CONFIG_EVENTS_MILLIS = 100;
    private ValueModel dimmDownConverterModel;
    private ValueModel dimmUpConverterModel;
    private BufferedValueModel dimmUpBufferedValueModel;
    private BufferedValueModel dimmDownBufferedValueModel;
    private ValueModel dmxMappingConverterModel;
    private PublishSubject<Integer> valueEventSubject = PublishSubject.create();
    private final PublishSubject<PortConfigChangeEvent> localPortConfigChangeEventSubject = PublishSubject.create();
    private final PublishSubject<PortConfigChangeEvent> portConfigChangeEventSubject;
    final ValueModel portValueHolder = new ValueHolder();

    public BacklightPortEditorPanel(BacklightPort port, Consumer<BacklightPort> saveCallback, Consumer<BacklightPort> valueCallback, Consumer<BacklightPort> refreshCallback, PublishSubject<PortConfigChangeEvent> portConfigChangeEventSubject, NodeSelectionProvider nodeSelectionProvider) {
        super((Port)port, saveCallback, valueCallback, refreshCallback, nodeSelectionProvider);
        this.portConfigChangeEventSubject = portConfigChangeEventSubject;
    }

    protected BacklightPort clonePort(BacklightPort port) {
        BacklightPort clone = (BacklightPort)BacklightPort.builder().withDimSlopeUp(port.getDimSlopeUp()).withDimSlopeDown(port.getDimSlopeDown()).withDimStretchMax(port.getDimStretchMax()).withDimStretchMin(port.getDimStretchMin()).withDmxMapping(port.getDmxMapping()).withStatus((BidibStatus)((BacklightPortStatus)port.getStatus())).withRemappingEnabled(port.isRemappingEnabled()).withKnownPortConfigKeys(port.getKnownPortConfigKeys()).withId(port.getId()).withLabel(port.getLabel()).withEnabled(port.isEnabled()).withIsInactive(port.isInactive()).withPortIdentifier(port.getPortIdentifier()).build();
        return clone;
    }

    protected JPanel doCreateComponent(BacklightPort port) {
        boolean dimm_8_8;
        SliderAndValuePanel valueSlider;
        int maxRange;
        AbstractPortEditorPanel.PortEditorPanelDebugContainer panel;
        int row = 1;
        FormBuilder dialogBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            panel = new AbstractPortEditorPanel.PortEditorPanelDebugContainer((PortEditorPanelCallback)this);
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            panel = new AbstractPortEditorPanel.PortEditorPanelContainer((PortEditorPanelCallback)this);
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        }
        dialogBuilder.border((Border)Paddings.TABBED_DIALOG);
        BufferedValueModel bufferedPortNameModel = this.getPresentationModel().getBufferedModel("label");
        dialogBuilder.add(Resources.getString(BacklightPortTableModel.class, (String)"label") + ":", new Object[0]).xy(1, row);
        JTextField portName = WizardComponentFactory.createTextField((ValueModel)bufferedPortNameModel, (boolean)false);
        dialogBuilder.add((Component)portName).xyw(3, row, 7);
        row += 2;
        if (this.isPortConfigKeySupported((byte)4) || this.isPortConfigKeySupported((byte)68)) {
            maxRange = this.isPortConfigKeySupported((byte)68) ? 65535 : 255;
            this.dimmDownBufferedValueModel = this.getPresentationModel().getBufferedModel("dimSlopeDown");
            this.dimmDownConverterModel = new ConverterValueModel((ValueModel)this.dimmDownBufferedValueModel, (BindingConverter)new StringToIntegerConverter());
            JTextField dimmDownText = new JTextField();
            IntegerInputValidationDocument dimmDownDocument = new IntegerInputValidationDocument(5, "0123456789");
            dimmDownDocument.setRangeValidationCallback((RangeValidationCallback)new DefaultRangeValidationCallback(0, maxRange));
            dimmDownText.setDocument((Document)dimmDownDocument);
            dimmDownText.setColumns(5);
            dimmDownText.setHorizontalAlignment(4);
            Bindings.bind((JTextField)dimmDownText, (ValueModel)this.dimmDownConverterModel, (boolean)false);
            dialogBuilder.add(Resources.getString(BacklightPortTableModel.class, (String)"dimSlopeDown"), new Object[0]).xy(1, row);
            dialogBuilder.add((Component)dimmDownText).xy(3, row);
            dimmDownText.setEnabled(port.isEnabled());
            ValidationComponentUtils.setMandatory((JComponent)dimmDownText, (boolean)true);
            ValidationComponentUtils.setMessageKeys((JComponent)dimmDownText, (Object[])new Object[]{"validation.dimmDown_key"});
            valueSlider = new SliderAndValuePanel(0, maxRange, 10);
            valueSlider.createComponent();
            WizardBindings.bind((SliderAndValuePanel)valueSlider, (ValueModel)this.dimmDownBufferedValueModel);
            dialogBuilder.add((Component)valueSlider).xyw(5, row, 5);
            dimm_8_8 = this.isPortConfigKeySupported((byte)68);
            this.dimmDownBufferedValueModel.addValueChangeListener(evt -> {
                if (this.dimmDownBufferedValueModel.getValue() instanceof Integer) {
                    int dimmDownValue = (Integer)this.dimmDownBufferedValueModel.getValue();
                    LOGGER.info("The dimmDown value has been changed: {}", (Object)dimmDownValue);
                    this.localPortConfigChangeEventSubject.onNext((Object)new PortConfigChangeEvent(null, 0L, (PortTypeAware)port, Byte.valueOf(dimm_8_8 ? (byte)68 : (byte)4), (PortConfigValue)(dimm_8_8 ? new Int16PortConfigValue(Integer.valueOf(ByteUtils.getWORD((int)dimmDownValue))) : new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)dimmDownValue))))));
                }
            });
            row += 2;
        }
        if (this.isPortConfigKeySupported((byte)3) || this.isPortConfigKeySupported((byte)67)) {
            maxRange = this.isPortConfigKeySupported((byte)67) ? 65535 : 255;
            this.dimmUpBufferedValueModel = this.getPresentationModel().getBufferedModel("dimSlopeUp");
            this.dimmUpConverterModel = new ConverterValueModel((ValueModel)this.dimmUpBufferedValueModel, (BindingConverter)new StringToIntegerConverter());
            JTextField dimmUpText = new JTextField();
            IntegerInputValidationDocument dimmUpDocument = new IntegerInputValidationDocument(5, "0123456789");
            dimmUpDocument.setRangeValidationCallback((RangeValidationCallback)new DefaultRangeValidationCallback(0, maxRange));
            dimmUpText.setDocument((Document)dimmUpDocument);
            dimmUpText.setColumns(5);
            dimmUpText.setHorizontalAlignment(4);
            Bindings.bind((JTextField)dimmUpText, (ValueModel)this.dimmUpConverterModel, (boolean)false);
            dialogBuilder.add(Resources.getString(BacklightPortTableModel.class, (String)"dimSlopeUp"), new Object[0]).xy(1, row);
            dialogBuilder.add((Component)dimmUpText).xy(3, row);
            dimmUpText.setEnabled(port.isEnabled());
            ValidationComponentUtils.setMandatory((JComponent)dimmUpText, (boolean)true);
            ValidationComponentUtils.setMessageKeys((JComponent)dimmUpText, (Object[])new Object[]{"validation.dimmUp_key"});
            valueSlider = new SliderAndValuePanel(0, maxRange, 10);
            valueSlider.createComponent();
            WizardBindings.bind((SliderAndValuePanel)valueSlider, (ValueModel)this.dimmUpBufferedValueModel);
            dialogBuilder.add((Component)valueSlider).xyw(5, row, 5);
            dimm_8_8 = this.isPortConfigKeySupported((byte)67);
            this.dimmUpBufferedValueModel.addValueChangeListener(evt -> {
                if (this.dimmUpBufferedValueModel.getValue() instanceof Integer) {
                    int dimmUpValue = (Integer)this.dimmUpBufferedValueModel.getValue();
                    LOGGER.info("The dimmUp value has been changed: {}", (Object)dimmUpValue);
                    this.localPortConfigChangeEventSubject.onNext((Object)new PortConfigChangeEvent(null, 0L, (PortTypeAware)port, Byte.valueOf(dimm_8_8 ? (byte)67 : (byte)3), (PortConfigValue)(dimm_8_8 ? new Int16PortConfigValue(Integer.valueOf(ByteUtils.getWORD((int)dimmUpValue))) : new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)dimmUpValue))))));
                }
            });
            row += 2;
        }
        if (this.isPortConfigKeySupported((byte)6)) {
            BufferedValueModel valueValueModel = this.getPresentationModel().getBufferedModel("dmxMapping");
            this.dmxMappingConverterModel = new ConverterValueModel((ValueModel)valueValueModel, (BindingConverter)new StringToIntegerConverter());
            JTextField dmxMappingText = new JTextField();
            IntegerInputValidationDocument dmxMappingDocument = new IntegerInputValidationDocument(3, "0123456789");
            dmxMappingDocument.setRangeValidationCallback((RangeValidationCallback)new DefaultRangeValidationCallback(1, 255));
            dmxMappingText.setDocument((Document)dmxMappingDocument);
            dmxMappingText.setColumns(2);
            dmxMappingText.setHorizontalAlignment(4);
            Bindings.bind((JTextField)dmxMappingText, (ValueModel)this.dmxMappingConverterModel, (boolean)false);
            dialogBuilder.add(Resources.getString(BacklightPortTableModel.class, (String)"dmxMapping"), new Object[0]).xy(1, row);
            dialogBuilder.add((Component)dmxMappingText).xy(3, row);
            ValidationComponentUtils.setMandatory((JComponent)dmxMappingText, (boolean)true);
            ValidationComponentUtils.setMessageKeys((JComponent)dmxMappingText, (Object[])new Object[]{"validation.dmxMapping_key"});
            valueValueModel.addValueChangeListener(evt -> {
                if (valueValueModel.getValue() instanceof Integer) {
                    int outputMap = (Integer)valueValueModel.getValue();
                    LOGGER.info("The outputMap value has been changed: {}", (Object)outputMap);
                    this.localPortConfigChangeEventSubject.onNext((Object)new PortConfigChangeEvent(null, 0L, (PortTypeAware)port, Byte.valueOf((byte)6), (PortConfigValue)new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)outputMap)))));
                }
            });
            row += 2;
        }
        BufferedValueModel valueValueModel = this.getPresentationModel().getBufferedModel("value");
        ConverterValueModel valueConverterModel = new ConverterValueModel((ValueModel)valueValueModel, (BindingConverter)new BacklightValueToRelativeValueConverter());
        this.portValueHolder.setValue(valueConverterModel.getValue());
        BacklightSliderAndValuePanel valueSlider2 = new BacklightSliderAndValuePanel(0, 100, 10, () -> {
            int dimmUp = 255;
            int dimmDown = 0;
            BacklightPort configPort = BacklightPort.builder().withDimSlopeUp(dimmUp).withDimSlopeDown(dimmDown).build();
            return configPort;
        });
        valueSlider2.createComponent();
        WizardBindings.bind((SliderAndValuePanel)valueSlider2, (ValueModel)this.portValueHolder);
        this.portValueHolder.addValueChangeListener(evt -> {
            if (Objects.equals(evt.getOldValue(), evt.getNewValue())) {
                LOGGER.debug("The value has not changed.");
                return;
            }
            if (this.portValueHolder.getValue() instanceof Integer) {
                int position = (Integer)this.portValueHolder.getValue();
                LOGGER.info("The position has been changed by the slider. New position: {}", (Object)position);
                this.valueEventSubject.onNext((Object)position);
            }
        });
        Disposable disp = this.valueEventSubject.throttleLatest(80L, TimeUnit.MILLISECONDS, (Scheduler)SwingScheduler.getInstance(), true).subscribe(value -> this.sendValueToBacklightPort(port, value.intValue()), err -> LOGGER.warn("The value event subject signalled an error.", err), () -> LOGGER.info("The value event subject has completed."));
        this.getCompDisp().add(disp);
        dialogBuilder.add(Resources.getString(ServoPortTableModel.class, (String)"value"), new Object[0]).xy(1, 9);
        dialogBuilder.add((Component)valueSlider2).xyw(3, 9, 7);
        JPanel buttonPanel = this.createButtonPanel();
        dialogBuilder.add((Component)buttonPanel).xyw(1, row += 2, 9);
        Disposable dispLocalPortConfigChange = this.localPortConfigChangeEventSubject.buffer(100L, TimeUnit.MILLISECONDS, (Scheduler)SwingScheduler.getInstance()).subscribe(evts -> {
            PortConfigChangeEvent event = null;
            for (PortConfigChangeEvent evt : evts) {
                LOGGER.info("Process event: {}", (Object)evt);
                if (event == null) {
                    event = evt;
                    continue;
                }
                event.getPortConfig().putAll(evt.getPortConfig());
            }
            if (event != null) {
                LOGGER.info("Publish the config change event to the node: {}", event);
                this.portConfigChangeEventSubject.onNext(event);
            }
        });
        this.getCompDisp().add(dispLocalPortConfigChange);
        if (this.getValidationResultModel() != null) {
            LOGGER.debug("Create iconfeedback panel.");
            IconFeedbackPanel cvIconPanel = new IconFeedbackPanel((ValidationResultModel)this.getValidationResultModel(), (JComponent)dialogBuilder.build());
            AbstractPortEditorPanel.PortEditorPanelContainer panel2 = new AbstractPortEditorPanel.PortEditorPanelContainer((PortEditorPanelCallback)this);
            FormBuilder feedbackBuilder = FormBuilder.create().columns("p:g", new Object[0]).rows("fill:p:grow", new Object[0]).panel((JPanel)panel2);
            feedbackBuilder.add((Component)cvIconPanel).xy(1, 1);
            this.setPanel(feedbackBuilder.build());
        } else {
            this.setPanel(dialogBuilder.build());
        }
        bufferedPortNameModel.addValueChangeListener(evt -> this.triggerValidation());
        if (this.dimmDownConverterModel != null) {
            this.dimmDownConverterModel.addValueChangeListener(evt -> this.triggerValidation());
        }
        if (this.dimmUpConverterModel != null) {
            this.dimmUpConverterModel.addValueChangeListener(evt -> this.triggerValidation());
        }
        if (this.dmxMappingConverterModel != null) {
            this.dmxMappingConverterModel.addValueChangeListener(evt -> this.triggerValidation());
        }
        this.triggerValidation();
        return this.getPanel();
    }

    protected void propertyChanged(PropertyChangeEvent evt) {
        LOGGER.info("The port property has been changed, propertyName: {}, new value: {}", (Object)evt.getPropertyName(), evt.getNewValue());
        super.propertyChanged(evt);
        SwingUtilities.invokeLater(() -> {
            try {
                switch (evt.getPropertyName()) {
                    case "status": 
                    case "portStatus": {
                        this.updatePortValueFromOriginalPort();
                        break;
                    }
                    case "portConfigChanged": {
                        break;
                    }
                    case "portTypeChanged": {
                        LOGGER.info("The port type has changed: {}", evt.getNewValue());
                        if (((BacklightPort)this.getOriginalPort()).getPortType() != LcOutputType.SERVOPORT) break;
                        LOGGER.info("Current port type is SERVOPORT.");
                        this.updatePortValueFromOriginalPort();
                        this.enableComponents();
                        break;
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Update the status failed.", (Throwable)ex);
            }
        });
    }

    private void updatePortValueFromOriginalPort() {
        AbstractValueModel selectionHolderPortStatus = this.getPresentationModel().getModel("status");
        Integer value = ((BacklightPort)this.getOriginalPort()).getValue();
        LOGGER.info("Current value of original port: {}", (Object)value);
        selectionHolderPortStatus.setValue((Object)value);
        this.portValueHolder.setValue((Object)value);
    }

    protected ValidationResult validate(BacklightPort port) {
        PropertyValidationI18NSupport support = new PropertyValidationI18NSupport((Object)this.getPresentationModel(), "validation");
        if (this.dimmDownConverterModel != null && this.dimmDownConverterModel.getValue() == null) {
            support.addError("dimmDownTime_key", "not_empty_for_write");
        }
        if (this.dimmUpConverterModel != null && this.dimmUpConverterModel.getValue() == null) {
            support.addError("dimmUp_key", "not_empty_for_write");
        }
        if (this.dmxMappingConverterModel != null && this.dmxMappingConverterModel.getValue() == null) {
            support.addError("dmxMapping_key", "not_empty_for_write");
        }
        ValidationResult validationResult = support.getResult();
        return validationResult;
    }

    private void sendValueToBacklightPort(BacklightPort port, int position) {
        LOGGER.info("Send the position to the backlight port: {}", (Object)position);
        this.triggerValidation();
        BacklightPort servoPort = (BacklightPort)BacklightPort.builder().withValue(Integer.valueOf(position)).withId(port.getId()).build();
        this.getValueCallback().accept(servoPort);
    }
}

