/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.messages.FeedbackAddressData;
import org.bidib.jbidibc.messages.FeedbackConfidenceData;
import org.bidib.jbidibc.messages.FeedbackDynStateData;
import org.bidib.wizard.model.ports.FeedbackPort;
import org.bidib.wizard.model.status.FeedbackPortStatus;
import org.bidib.wizard.mvc.common.view.panel.DisabledPanel;
import org.bidib.wizard.mvc.main.view.table.FeedbackPortTableCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedbackPortTableCellRenderer
implements TableCellRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeedbackPortTableCellRenderer.class);
    private JPanel panel = new JPanel(new GridBagLayout());
    private DisabledPanel disabledInnerPanel;
    private final Color backgroundFree;
    private final Color backgroundOccupied;
    private final Color backgroundInvalid;
    private final Color backgroundInvalidOccupied;
    private JPanel innerPanel;
    private JLabel portLabel;
    private JLabel confidenceLabel;
    private JPanel addressPanel;
    private JLabel dynStateLabel;
    private JLabel timestampLabel;

    public FeedbackPortTableCellRenderer() {
        this.panel.setOpaque(true);
        this.disabledInnerPanel = this.createInnerPanel();
        this.backgroundFree = UIManager.getColor("Feedback.background.free");
        this.backgroundOccupied = UIManager.getColor("Feedback.background.occupied");
        this.backgroundInvalid = UIManager.getColor("Feedback.background.invalid");
        this.backgroundInvalidOccupied = UIManager.getColor("Feedback.background.invalid-occupied");
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.panel.removeAll();
        if (value instanceof FeedbackPort) {
            FeedbackPort port = (FeedbackPort)value;
            FeedbackPortStatus status = (FeedbackPortStatus)port.getStatus();
            List addresses = port.getAddresses();
            Set dynStates = port.getDynStates();
            String label = null;
            label = StringUtils.isNotBlank((CharSequence)port.getLabel()) ? String.format("%1$02d : %2$s", port.getId(), port.getLabel()) : (port.getId() > -1 ? String.format("%1$02d", port.getId()) : " ");
            this.portLabel.setText(label);
            FeedbackConfidenceData confidence = port.getConfidence();
            if (confidence != null) {
                StringBuilder sb = new StringBuilder();
                sb.append(confidence.isInvalid() ? "1" : "0").append(",").append(confidence.isFreeze() ? "1" : "0").append(",").append(confidence.isNoSignal() ? "1" : "0");
                this.confidenceLabel.setText(sb.toString());
                sb.setLength(0);
                sb.append("<html><b>CONFIDENCE</b><br>VOID: ");
                sb.append(confidence.isInvalid() ? "true" : "false").append("<br>");
                sb.append("FREEZE: ").append(confidence.isFreeze() ? "true" : "false").append("<br>");
                sb.append("NO DCC SIGNAL: ").append(confidence.isNoSignal() ? "true" : "false").append("</html>");
                this.panel.setToolTipText(sb.toString());
            }
            this.addressPanel.removeAll();
            if (addresses != null) {
                for (FeedbackAddressData address : addresses) {
                    this.addressPanel.add(new JLabel(this.getAddressData(address, (Collection)dynStates)));
                }
            }
            if (status == FeedbackPortStatus.OCCUPIED) {
                this.innerPanel.setBackground(this.backgroundOccupied);
            } else {
                this.innerPanel.setBackground(this.backgroundFree);
            }
            boolean valid = false;
            if (confidence != null) {
                valid = !confidence.isFreeze() && !confidence.isNoSignal() && !confidence.isInvalid();
            } else {
                LOGGER.warn("No confidence available: {}", (Object)port);
            }
            if (!valid) {
                if (status == FeedbackPortStatus.OCCUPIED) {
                    this.innerPanel.setBackground(this.backgroundInvalidOccupied);
                } else {
                    this.innerPanel.setBackground(this.backgroundInvalid);
                }
            }
            this.disabledInnerPanel.setEnabled(valid);
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            this.panel.add((Component)this.disabledInnerPanel, c);
        }
        return this.panel;
    }

    private DisabledPanel createInnerPanel() {
        this.innerPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        this.portLabel = new JLabel();
        Font f = this.portLabel.getFont();
        this.portLabel.setFont(f.deriveFont(f.getStyle() | 1));
        this.innerPanel.add((Component)this.portLabel, c);
        ++c.gridy;
        this.confidenceLabel = new JLabel();
        this.innerPanel.add((Component)this.confidenceLabel, c);
        this.addressPanel = new JPanel();
        this.addressPanel.setOpaque(false);
        this.addressPanel.setLayout(new BoxLayout(this.addressPanel, 3));
        ++c.gridy;
        this.innerPanel.add((Component)this.addressPanel, c);
        this.dynStateLabel = new JLabel();
        ++c.gridy;
        this.innerPanel.add((Component)this.dynStateLabel, c);
        this.timestampLabel = new JLabel();
        ++c.gridy;
        this.innerPanel.add((Component)this.timestampLabel, c);
        c.fill = 1;
        ++c.gridy;
        c.weighty = 1.0;
        this.innerPanel.add(Box.createVerticalGlue(), c);
        DisabledPanel disabledInnerPanel = new DisabledPanel((Container)this.innerPanel);
        c.gridy = 0;
        this.panel.add((Component)disabledInnerPanel, c);
        return disabledInnerPanel;
    }

    private String getAddressData(FeedbackAddressData address, Collection<FeedbackDynStateData> dynStates) {
        StringBuilder result = new StringBuilder();
        if (address != null) {
            if (result.length() > 0) {
                result.append(',');
            }
            int addr = address.getAddress();
            result.append(addr);
            switch (1.$SwitchMap$org$bidib$jbidibc$messages$enums$EnrailmentDirectionEnum[address.getType().ordinal()]) {
                case 1: {
                    result.append(">>");
                    break;
                }
                case 2: {
                    result.append("<<");
                    break;
                }
            }
            result.append('(');
            result.append(address.getSpeed());
            result.append(')');
            if (CollectionUtils.isNotEmpty(dynStates)) {
                for (FeedbackDynStateData dynState : dynStates) {
                    if (dynState.getDecoderAddress() != addr) continue;
                    dynState.appendDynState(result);
                    break;
                }
            }
        } else {
            result.append("[]");
        }
        return result.toString();
    }
}

