/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.preferences.model;

import com.jgoodies.binding.beans.Model;
import com.jgoodies.common.collect.ArrayListModel;
import java.time.DayOfWeek;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.commons.lang3.SystemUtils;
import org.bidib.jbidibc.netbidib.pairingstore.PairingStore;
import org.bidib.wizard.api.model.common.CommPort;
import org.bidib.wizard.common.model.settings.ExperimentalSettingsInterface;
import org.bidib.wizard.common.model.settings.GlobalSettingsInterface;
import org.bidib.wizard.common.model.settings.MiscSettingsInterface;
import org.bidib.wizard.common.model.settings.NetBidibSettingsInterface;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.mvc.preferences.model.listener.PreferencesModelListener;

public class PreferencesModel
extends Model {
    private static final long serialVersionUID = 1L;
    private final Collection<PreferencesModelListener> listeners = new LinkedList();
    private final Collection<CommPort> commPorts = new HashSet();
    private ArrayListModel<String> serialProviderList = new ArrayListModel();
    private ArrayListModel<DayOfWeek> dayOfWeekList = new ArrayListModel();
    private ArrayListModel<String> languageList = new ArrayListModel();
    private final GlobalSettingsInterface globalSettings;
    private final WizardSettingsInterface wizardSettings;
    private final MiscSettingsInterface miscSettings;
    private final ExperimentalSettingsInterface experimentalSettings;
    private final NetBidibSettingsInterface netBidibSettings;
    private final PairingStore pairingStore;

    public PreferencesModel(GlobalSettingsInterface globalSettings, WizardSettingsInterface wizardSettings, MiscSettingsInterface miscSettings, ExperimentalSettingsInterface experimentalSettings, NetBidibSettingsInterface netBidibSettings, PairingStore pairingStore) {
        this.serialProviderList.add((Object)"RXTX");
        this.serialProviderList.add((Object)"SCM");
        this.serialProviderList.add((Object)"SPSW");
        this.serialProviderList.add((Object)"JSerialComm");
        this.serialProviderList.add((Object)"PureJavaComm");
        if (SystemUtils.IS_OS_WINDOWS || SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_MAC_OSX) {
            this.serialProviderList.add((Object)"FTDI");
        }
        this.dayOfWeekList.add((Object)DayOfWeek.SUNDAY);
        this.dayOfWeekList.add((Object)DayOfWeek.MONDAY);
        this.dayOfWeekList.add((Object)DayOfWeek.TUESDAY);
        this.dayOfWeekList.add((Object)DayOfWeek.WEDNESDAY);
        this.dayOfWeekList.add((Object)DayOfWeek.THURSDAY);
        this.dayOfWeekList.add((Object)DayOfWeek.FRIDAY);
        this.dayOfWeekList.add((Object)DayOfWeek.SATURDAY);
        this.languageList.add((Object)"de");
        this.languageList.add((Object)"en");
        this.languageList.add((Object)"nl");
        this.globalSettings = globalSettings;
        this.wizardSettings = wizardSettings;
        this.miscSettings = miscSettings;
        this.experimentalSettings = experimentalSettings;
        this.netBidibSettings = netBidibSettings;
        this.pairingStore = pairingStore;
    }

    public void addPreferencesModelListener(PreferencesModelListener l) {
        this.listeners.add(l);
    }

    private void fireCommPortsChanged() {
        for (PreferencesModelListener l : this.listeners) {
            l.commPortsChanged();
        }
    }

    public Collection<CommPort> getAvailableCommPorts() {
        return this.commPorts;
    }

    public void setAvailableCommPorts(Collection<CommPort> commPorts) {
        this.commPorts.clear();
        this.commPorts.addAll(commPorts);
        this.fireCommPortsChanged();
    }

    public ArrayListModel<String> getSerialProviderList() {
        return this.serialProviderList;
    }

    public ArrayListModel<DayOfWeek> getDayOfWeekList() {
        return this.dayOfWeekList;
    }

    public ArrayListModel<String> getLanguageList() {
        return this.languageList;
    }

    public GlobalSettingsInterface getGlobalSettings() {
        return this.globalSettings;
    }

    public WizardSettingsInterface getWizardSettings() {
        return this.wizardSettings;
    }

    public MiscSettingsInterface getMiscSettings() {
        return this.miscSettings;
    }

    public ExperimentalSettingsInterface getExperimentalSettings() {
        return this.experimentalSettings;
    }

    public NetBidibSettingsInterface getNetBidibSettings() {
        return this.netBidibSettings;
    }

    public PairingStore getPairingStore() {
        return this.pairingStore;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PreferencesModel, commPorts: ").append(this.commPorts);
        return sb.toString();
    }
}

