/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.preferences.view.panel;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.converter.StringToIntegerConverter;
import org.bidib.wizard.client.common.preferences.view.panel.AbstractSettingsPanel;
import org.bidib.wizard.client.common.text.InputValidationDocument;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.common.model.settings.NetBidibSettingsInterface;
import org.bidib.wizard.mvc.preferences.view.panel.NetBidibSettingsPanel;
import org.bidib.wizard.mvc.preferences.view.panel.StringToNetBidibUniqueIdConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetBidibSettingsPanel
extends AbstractSettingsPanel<NetBidibSettingsInterface> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetBidibSettingsPanel.class);
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, pref, 3dlu, fill:50dlu:grow, 3dlu, pref";
    private static final String ENCODED_DIALOG_ROW_SPECS = "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref";
    private final NetBidibSettingsInterface netBidibSettings;
    private JPanel contentPanel;

    public NetBidibSettingsPanel(NetBidibSettingsInterface netBidibSettings, Consumer<Boolean> bufferingCallback) {
        super(bufferingCallback);
        this.netBidibSettings = netBidibSettings;
    }

    public JPanel createPanel() {
        Object panel;
        FormBuilder dialogBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            panel = new FormDebugPanel();
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            panel = new JPanel(new BorderLayout());
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        }
        dialogBuilder.border((Border)Paddings.TABBED_DIALOG);
        this.preparePresentationModel((Object)this.netBidibSettings);
        BufferedValueModel bufferedUniqueIdModel = this.presentationModel.getBufferedModel("netBidibUniqueId");
        ConverterValueModel currentUniqueIdConverterModel = new ConverterValueModel((ValueModel)bufferedUniqueIdModel, (BindingConverter)new StringToNetBidibUniqueIdConverter(13, 250));
        dialogBuilder.add(Resources.getString(this.getClass(), (String)"netBidibClientSerialNumber") + ":", new Object[0]).xy(1, 1);
        dialogBuilder.add(String.format("V %1$02X P %2$02X%3$02X", 13, ByteUtils.getLowByte((int)250), ByteUtils.getHighByte((int)250)), new Object[0]).xy(3, 1);
        JTextField netBidibClientSerialNumber = new JTextField();
        netBidibClientSerialNumber.setDocument((Document)new InputValidationDocument(4, "0123456789ABCDEF"));
        Bindings.bind((JTextField)netBidibClientSerialNumber, (ValueModel)currentUniqueIdConverterModel, (boolean)false);
        dialogBuilder.add((Component)netBidibClientSerialNumber).xyw(5, 1, 3);
        BufferedValueModel bufferedJmDnsNameModel = this.presentationModel.getBufferedModel("jmDnsName");
        dialogBuilder.add(Resources.getString(this.getClass(), (String)"jmDnsName") + ":", new Object[0]).xy(1, 3);
        JTextField jmDnsName = WizardComponentFactory.createTextField((ValueModel)bufferedJmDnsNameModel, (boolean)false);
        dialogBuilder.add((Component)jmDnsName).xyw(3, 3, 5);
        BufferedValueModel bufferedInterfaceDiscoveryPortModel = this.presentationModel.getBufferedModel("interfacePortDiscoveryNetBidib");
        ConverterValueModel interfaceDiscoveryPortConverterModel = new ConverterValueModel((ValueModel)bufferedInterfaceDiscoveryPortModel, (BindingConverter)new StringToIntegerConverter(Integer.valueOf(30)));
        dialogBuilder.add(Resources.getString(this.getClass(), (String)"discoveryNetBidibInterfacePort") + ":", new Object[0]).xy(1, 5);
        JTextField interfaceDiscoveryPort = new JTextField();
        interfaceDiscoveryPort.setDocument((Document)new InputValidationDocument(5, "0123456789"));
        Bindings.bind((JTextField)interfaceDiscoveryPort, (ValueModel)interfaceDiscoveryPortConverterModel, (boolean)false);
        dialogBuilder.add((Component)interfaceDiscoveryPort).xyw(3, 5, 5);
        BufferedValueModel bufferedPairingTimeoutModel = this.presentationModel.getBufferedModel("pairingTimeout");
        ConverterValueModel pairingTimeoutConverterModel = new ConverterValueModel((ValueModel)bufferedPairingTimeoutModel, (BindingConverter)new StringToIntegerConverter(Integer.valueOf(30)));
        dialogBuilder.add(Resources.getString(this.getClass(), (String)"pairingTimeout") + ":", new Object[0]).xy(1, 7);
        JTextField pairingTimeout = new JTextField();
        pairingTimeout.setDocument((Document)new InputValidationDocument(4, "0123456789"));
        Bindings.bind((JTextField)pairingTimeout, (ValueModel)pairingTimeoutConverterModel, (boolean)false);
        dialogBuilder.add((Component)pairingTimeout).xyw(3, 7, 5);
        BufferedValueModel periodicSearchmDnsEnabledModel = this.presentationModel.getBufferedModel("periodicSearchmDnsEnabled");
        JCheckBox periodicSearchmDnsEnabled = WizardComponentFactory.createCheckBox((ValueModel)periodicSearchmDnsEnabledModel, (String)Resources.getString(this.getClass(), (String)"periodicSearchmDnsEnabled"));
        dialogBuilder.add((Component)periodicSearchmDnsEnabled).xyw(1, 9, 7);
        BufferedValueModel discoveryEnabledModel = this.presentationModel.getBufferedModel("discoveryEnabled");
        JCheckBox discoveryEnabled = WizardComponentFactory.createCheckBox((ValueModel)discoveryEnabledModel, (String)Resources.getString(this.getClass(), (String)"discoveryEnabled"));
        dialogBuilder.add((Component)discoveryEnabled).xyw(1, 11, 7);
        BufferedValueModel discoveryOnAllNetworkInterfacesEnabledModel = this.presentationModel.getBufferedModel("discoveryOnAllNetworkInterfacesEnabled");
        JCheckBox discoveryOnAllNetworkInterfacesEnabled = WizardComponentFactory.createCheckBox((ValueModel)discoveryOnAllNetworkInterfacesEnabledModel, (String)Resources.getString(this.getClass(), (String)"discoveryOnAllNetworkInterfacesEnabled"));
        dialogBuilder.add((Component)discoveryOnAllNetworkInterfacesEnabled).xyw(1, 13, 7);
        dialogBuilder.add(Resources.getString(this.getClass(), (String)"pairingStoreLocation") + ":", new Object[0]).xy(1, 15);
        BufferedValueModel pairingStoreLocationModel = this.presentationModel.getBufferedModel("pairingStoreLocation");
        JTextField pairingStoreLocation = WizardComponentFactory.createTextField((ValueModel)pairingStoreLocationModel, (boolean)false);
        dialogBuilder.add((Component)pairingStoreLocation).xyw(3, 15, 3);
        JButton selectDirectoyButton = new JButton(Resources.getString(NetBidibSettingsPanel.class, (String)"select-directory"));
        selectDirectoyButton.setToolTipText(Resources.getString(NetBidibSettingsPanel.class, (String)"select-directory.tooltip"));
        selectDirectoyButton.addActionListener(evt -> {
            String storedPairingStoreDirectory = pairingStoreLocationModel.getString();
            FileFilter[] ff = null;
            1 dialog = new /* Unavailable Anonymous Inner Class!! */;
            dialog.setApproveButtonText(Resources.getString(NetBidibSettingsPanel.class, (String)"select-directory"));
            dialog.showDialog();
        });
        dialogBuilder.add((Component)selectDirectoyButton).xy(7, 15);
        this.contentPanel = dialogBuilder.build();
        this.contentPanel.setOpaque(false);
        return this.contentPanel;
    }
}

