/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.pt.model;

import com.jgoodies.binding.beans.Model;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.bidib.jbidibc.messages.enums.CommandStationProgState;
import org.bidib.jbidibc.messages.enums.CommandStationState;
import org.bidib.wizard.mvc.pt.model.listener.ConfigVariableListener;
import org.bidib.wizard.mvc.pt.model.listener.ProgCommandListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PtProgrammerModel
extends Model {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PtProgrammerModel.class);
    public static final String PROPERTYNAME_COMMANDSTATIONPROGSTATE = "commandStationProgState";
    public static final String PROPERTYNAME_CVNUMBER = "cvNumber";
    public static final String PROPERTYNAME_CVVALUE = "cvValue";
    private final List<ConfigVariableListener> listeners = new LinkedList();
    private final List<ProgCommandListener> progCommandListeners = new LinkedList();
    private int cvNumber = 1;
    private Integer cvValue;
    private CommandStationState commandStationState;
    private CommandStationProgState commandStationProgState;

    public void addConfigVariableListener(ConfigVariableListener l) {
        this.listeners.add(l);
    }

    public void removeConfigVariableListener(ConfigVariableListener l) {
        this.listeners.remove(l);
    }

    public void addProgCommandListener(ProgCommandListener l) {
        this.progCommandListeners.add(l);
    }

    public void removeProgCommandListener(ProgCommandListener l) {
        this.progCommandListeners.remove(l);
    }

    public int getCvNumber() {
        return this.cvNumber;
    }

    public void setCvNumber(int cvNumber) {
        int oldNumber = this.cvNumber;
        this.cvNumber = cvNumber;
        this.firePropertyChange(PROPERTYNAME_CVNUMBER, oldNumber, cvNumber);
    }

    public Integer getCvValue() {
        return this.cvValue;
    }

    public void setCvValue(Integer value) {
        LOGGER.debug("Set the CV value: {}", (Object)value);
        Integer oldValue = this.cvValue;
        this.cvValue = value;
        this.firePropertyChange(PROPERTYNAME_CVVALUE, (Object)oldValue, (Object)this.cvValue);
    }

    public void clearCvValue() {
        LOGGER.debug("Clear the CV value.");
        Integer oldValue = this.cvValue;
        this.cvValue = null;
        this.firePropertyChange(PROPERTYNAME_CVVALUE, (Object)oldValue, (Object)this.cvValue);
    }

    public CommandStationState getCommandStationState() {
        return this.commandStationState;
    }

    public void setCommandStationState(CommandStationState commandStationState) {
        LOGGER.info("Set the new command station state: {}", (Object)commandStationState);
        LOGGER.info("The commandStationState has been changed: {}", (Object)commandStationState);
        this.commandStationState = commandStationState;
        this.fireCommandStationStateChanged(commandStationState);
    }

    public CommandStationProgState getCommandStationProgState() {
        return this.commandStationProgState;
    }

    public void setCommandStationProgState(CommandStationProgState commandStationProgState) {
        LOGGER.info("Set the new command station prog state: {}", (Object)commandStationProgState);
        CommandStationProgState oldCommandStationProgState = this.commandStationProgState;
        this.commandStationProgState = commandStationProgState;
        this.firePropertyChange(PROPERTYNAME_COMMANDSTATIONPROGSTATE, (Object)oldCommandStationProgState, (Object)commandStationProgState);
        this.fireCommandStationProgStateChanged(commandStationProgState);
    }

    public void updateCommandStationProgResult(CommandStationProgState commandStationProgState, int remainingTime, int cvNumber, int cvValue) {
        LOGGER.info("update the command station result: {}, remainingTime: {}, cvNumber: {}, cvValue: {}", new Object[]{commandStationProgState, remainingTime, cvNumber, cvValue});
        if (SwingUtilities.isEventDispatchThread()) {
            this.notifyCommandStationProgResult(commandStationProgState, cvValue);
        } else {
            SwingUtilities.invokeLater((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void notifyCommandStationProgResult(CommandStationProgState commandStationProgState, int cvValue) {
        this.setCommandStationProgState(commandStationProgState);
        if (CommandStationProgState.PROG_OKAY.equals((Object)commandStationProgState)) {
            this.setCvValue(Integer.valueOf(cvValue));
        }
        this.fireProgCommandFinished(commandStationProgState);
    }

    private void fireProgCommandFinished(CommandStationProgState commandStationProgState) {
        for (ProgCommandListener l : this.progCommandListeners) {
            l.progCommandStationFinished(commandStationProgState);
        }
    }

    private void fireCommandStationStateChanged(CommandStationState commandStationState) {
        for (ConfigVariableListener l : this.listeners) {
            l.commandStationStateChanged(commandStationState);
        }
    }

    private void fireCommandStationProgStateChanged(CommandStationProgState commandStationProgState) {
        for (ConfigVariableListener l : this.listeners) {
            l.commandStationProgStateChanged(commandStationProgState);
        }
    }
}

