package org.bidib.wizard.mvc.main.view.component;

import java.awt.Component;

import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

import org.apache.commons.lang3.StringUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.core.dialog.FileDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MacroFileDialog extends FileDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(MacroFileDialog.class);

    private final String MACRO_EXTENSION = "mxml";

    private FileFilter macroFilter;

    private String macroDescription;

    public MacroFileDialog(Component parent, int dialogType, final Macro macro) {
        super(parent, dialogType, null, null);

        macroDescription = Resources.getString(MacroFileDialog.class, "macroDescription");
        macroFilter = new FileNameExtensionFilter(macroDescription, MACRO_EXTENSION);

        String fileName = null;
        if (macro != null) {
            // must make a valid file name
            fileName = macro.toString();

            // replace invalid characters
            fileName = fileName.replaceAll("[^a-zA-Z0-9.+-]", "_");
        }

        if (StringUtils.isNotBlank(fileName)) {
            fileName = fileName + "." + MACRO_EXTENSION;
            LOGGER.info("Update the file filter for macro extension, fileName: {}", fileName);
        }
        updateFileFilter(new FileFilter[] { macroFilter }, fileName);
    }
}
