package org.bidib.wizard.mvc.main.view.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.LinkedList;

import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.view.listener.ButtonListener;
import org.bidib.wizard.model.ports.ConfigurablePort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.client.common.view.renderer.BidibStatusListRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortComboBoxWithButtonEditor<E extends BidibStatus> extends AbstractCellEditor implements TableCellEditor {
    private static final long serialVersionUID = 1L;

    private static final Logger LOGGER = LoggerFactory.getLogger(PortComboBoxWithButtonEditor.class);

    private final Collection<ButtonListener> buttonListeners = new LinkedList<ButtonListener>();

    private final JPanel panel = new JPanel();

    protected final JComboBox<E> comboBox;

    private final JButton button;

    private int row;

    private int column;

    public PortComboBoxWithButtonEditor(E[] items, String buttonText, Class<?> resourceClazz) {
        this(items, buttonText, Resources.trimWizardPackage(resourceClazz.getName()));
    }

    public PortComboBoxWithButtonEditor(E[] items, String buttonText, String resourceClazz) {
        comboBox = new JComboBox<>(items.clone());
        comboBox.setRenderer(new BidibStatusListRenderer<>(resourceClazz));
        button = new JButton(buttonText);
        button.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                fireEditingStopped();
                fireButtonPressed();
            }
        });
        panel.setLayout(new GridBagLayout());
        panel.setFocusCycleRoot(true);

        GridBagConstraints c = new GridBagConstraints();

        c.anchor = GridBagConstraints.FIRST_LINE_START;
        c.fill = GridBagConstraints.BOTH;
        c.gridx = 0;
        c.insets = new Insets(0, 0, 2, 2);
        c.weightx = 1;
        panel.add(comboBox, c);
        c.anchor = GridBagConstraints.FIRST_LINE_END;
        c.gridx++;
        c.weightx = 0;
        panel.add(button, c);
    }

    public void addButtonListener(ButtonListener l) {
        buttonListeners.add(l);
    }

    private void fireButtonPressed() {
        for (ButtonListener l : buttonListeners) {
            l.buttonPressed(row, column, getCellEditorValue());
        }
    }

    @Override
    public Object getCellEditorValue() {
        return comboBox.getSelectedItem();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.row = row;
        this.column = column;
        if (value instanceof ConfigurablePort) {
            ConfigurablePort<?> port = (ConfigurablePort<?>) value;
            setSelectedValue((Port<? extends BidibStatus>) port);
        }
        else if (value instanceof BidibStatus) {
            setSelectedValue((E) value);
        }
        else {
            LOGGER.warn("Invalid value: {}", value);
        }

        if (isSelected) {
            panel.setForeground(table.getSelectionForeground());
            panel.setBackground(table.getSelectionBackground());
        }
        else {
            panel.setForeground(table.getForeground());
            panel.setBackground(table.getBackground());
            comboBox.setForeground(table.getForeground());
            comboBox.setBackground(table.getBackground());
            button.setForeground(table.getForeground());
            button.setBackground(table.getBackground());
        }

        return panel;
    }

    protected void setSelectedValue(Port<? extends BidibStatus> port) {
        comboBox.setSelectedItem(port.getStatus());
    }

    protected void setSelectedValue(E status) {
        comboBox.setSelectedItem(status);
    }
}
