package org.bidib.wizard.mvc.firmware.view.panel;

import java.io.File;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BidibFirmwareFileFilterTest {

    private static final Logger LOGGER = LoggerFactory.getLogger(BidibFirmwareFileFilterTest.class);

    @Test
    public void acceptFirmwareZipTest() {
        File file = new File("");
        file = new File(file.getAbsoluteFile(), "target/test-classes/firmware/bidib_if2_v2.04.01.zip");
        LOGGER.info("Prepared file: {}", file.getAbsolutePath());

        BidibFirmwareFileFilter filter = new BidibFirmwareFileFilter();

        Assertions.assertThat(filter.accept(file)).isTrue();
    }

    @Test
    public void acceptFirmwareHexWithoutDestinationTest() {
        File file = new File("");
        file = new File(file.getAbsoluteFile(), "target/test-classes/firmware/Testboard.hex");
        LOGGER.info("Prepared file: {}", file.getAbsolutePath());

        BidibFirmwareFileFilter filter = new BidibFirmwareFileFilter();

        Assertions.assertThat(filter.accept(file)).isTrue();
    }

    @Test
    public void acceptFirmwareHexWithDestinationTest() {
        File file = new File("");
        file = new File(file.getAbsoluteFile(), "target/test-classes/firmware/Testboard_V_1.01.01.000.hex");
        LOGGER.info("Prepared file: {}", file.getAbsolutePath());

        BidibFirmwareFileFilter filter = new BidibFirmwareFileFilter();

        Assertions.assertThat(filter.accept(file)).isTrue();
    }

    @Test
    public void acceptFirmwareInvalidExtensionTest() {
        File file = new File("");
        file = new File(file.getAbsoluteFile(), "target/test-classes/firmware/error.txt");
        LOGGER.info("Prepared file: {}", file.getAbsolutePath());

        BidibFirmwareFileFilter filter = new BidibFirmwareFileFilter();

        Assertions.assertThat(filter.accept(file)).isFalse();
    }
}
