package org.bidib.wizard.mvc.main.view.statusbar;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;

import org.bidib.wizard.mvc.main.model.StatusModel;

import com.formdev.flatlaf.FlatLightLaf;
import com.jidesoft.icons.JideIconsFactory;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.status.ButtonStatusBarItem;
import com.jidesoft.status.LabelStatusBarItem;
import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.utils.PortingUtils;

class DefaultJideStatusBarTest {

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {

            FlatLightLaf.setup();

            // com.jidesoft.utils.Lm.verifyLicense("<your name>", "<your-app>", "<your-key>");

            // LookAndFeelFactory.installJideExtension();
            LookAndFeelFactory.installJideExtension(LookAndFeelFactory.VSNET_STYLE_WITHOUT_MENU);

            new DefaultJideStatusBarTest();
        });
    }

    public DefaultJideStatusBarTest() {

        JFrame f = new JFrame();
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        final JPanel content = new JPanel(new BorderLayout());
        content.add(new JLabel("Test"));
        f.add(new JScrollPane(content), BorderLayout.CENTER);

        com.jidesoft.status.StatusBar statusBar = new com.jidesoft.status.StatusBar();

        LabelStatusBarItem statusLabel = new LabelStatusBarItem(" ");
        statusBar.add(statusLabel, JideBoxLayout.VARY);

        ButtonStatusBarItem button = new ButtonStatusBarItem("READ-ONLY");
        button.setIcon(JideIconsFactory.getImageIcon(JideIconsFactory.SAVE));
        button.setPreferredWidth(20);
        statusBar.add(button, JideBoxLayout.FLEXIBLE);

        JLabel simulationLabel = new JLabel("Simulation", SwingConstants.CENTER);
        Font oldFont = simulationLabel.getFont();
        simulationLabel.setFont(oldFont.deriveFont(Font.BOLD, oldFont.getSize2D() + 2));
        simulationLabel.setForeground(new Color(190, 15, 20));
        PortingUtils.removeFocus(simulationLabel);

        ConnectionStatusBarItem ledPanel = new ConnectionStatusBarItem(new StatusModel());
        ledPanel.setPreferredWidth(170);

        DefaultOverlayable overlayLedPanel = new DefaultOverlayable(ledPanel, simulationLabel);
        statusBar.add(overlayLedPanel, JideBoxLayout.FLEXIBLE);

        overlayLedPanel.setOverlayVisible(true);

        f.add(statusBar, BorderLayout.AFTER_LAST_LINE);

        f.setSize(400, 400);
        f.setLocation(200, 200);
        f.setVisible(true);
    }

}
