package org.bidib.wizard.utils;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class FirmwareUtilsTest {

    private static final String FILENAME_NO_VERSION = "BiDiBCV-13-120.xml";

    private static final String FILENAME_MAJOR_VERSION = "BiDiBCV-13-120-1.xml";

    private static final String FILENAME_MAJOR_AND_MINOR_VERSION = "BiDiBCV-13-120-1.01.xml";

    private static final String FILENAME_FULL_VERSION = "BiDiBCV-13-120-1.02.03.xml";

    @Test
    public void hasVersionInFilename() {

        Assertions.assertThat(FirmwareUtils.hasVersionInFilename(FILENAME_NO_VERSION)).isFalse();

        Assertions.assertThat(FirmwareUtils.hasVersionInFilename(FILENAME_MAJOR_VERSION)).isTrue();

        Assertions.assertThat(FirmwareUtils.hasVersionInFilename(FILENAME_MAJOR_AND_MINOR_VERSION)).isTrue();

        Assertions.assertThat(FirmwareUtils.hasVersionInFilename(FILENAME_FULL_VERSION)).isTrue();
    }

    @Test
    public void getVidAndPidTest() {

        Assertions.assertThat(FirmwareUtils.getVidAndPid(FILENAME_NO_VERSION)).isEqualTo("13-120");

        Assertions.assertThat(FirmwareUtils.getVidAndPid(FILENAME_MAJOR_VERSION)).isEqualTo("13-120");

        Assertions.assertThat(FirmwareUtils.getVidAndPid(FILENAME_MAJOR_AND_MINOR_VERSION)).isEqualTo("13-120");

        Assertions.assertThat(FirmwareUtils.getVidAndPid(FILENAME_FULL_VERSION)).isEqualTo("13-120");
    }
}
