/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.main;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;

@SpringBootApplication(scanBasePackages={"org.bidib.wizard.core.model", "org.bidib.wizard.core.service", "org.bidib.wizard.core.config", "org.bidib.wizard.common.context", "org.bidib.wizard.config", "org.bidib.wizard.startup", "org.bidib.wizard.discovery.config"})
public class BiDiBWizardStandaloneApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(BiDiBWizardStandaloneApplication.class);

    public static void main(String[] args) {
        String preferencesPath;
        Locale locale = Locale.getDefault();
        LOGGER.info("Current locale: {}", (Object)locale);
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.addAll(Arrays.asList(args));
        SpringApplicationBuilder builder = new SpringApplicationBuilder(new Class[0]).sources(new Class[]{BiDiBWizardStandaloneApplication.class}).headless(false).web(WebApplicationType.NONE).properties(new String[]{"wizard-app-type=standalone"});
        if (!"restartedMain".equals(Thread.currentThread().getName())) {
            Optional<String> wizardConfigFileName = argsList.stream().filter(val -> val.startsWith("--wizard.settings.file-name")).findFirst();
            if (wizardConfigFileName.isPresent()) {
                LOGGER.info("Keep the provided data from args: {}", (Object)wizardConfigFileName.get());
                String fileName = wizardConfigFileName.get().split("=")[1];
                fileName = FilenameUtils.getBaseName((String)fileName);
                LOGGER.info("Add the fileName: {}", (Object)fileName);
                builder.properties(new String[]{"spring.config.name=application," + fileName});
            } else {
                builder.properties(new String[]{"spring.config.name=application,wizard"});
            }
            Optional<String> wizardConfigFileLocation = argsList.stream().filter(val -> val.startsWith("--wizard.settings.file-location")).findFirst();
            if (wizardConfigFileLocation.isPresent()) {
                LOGGER.info("Keep the provided data from args: {}", (Object)wizardConfigFileLocation.get());
                Object location = wizardConfigFileLocation.get().split("=")[1];
                location = ((String)location).replaceAll("\\\\", "/");
                if (!((String)location).endsWith("/")) {
                    location = (String)location + "/";
                }
                LOGGER.info("Set the optional additional-location: {}", location);
                builder.properties(new String[]{"spring.config.additional-location=optional:file:///" + (String)location});
            }
        }
        if (StringUtils.isBlank((CharSequence)(preferencesPath = System.getProperty("bidib.preferencesPath"))) && StringUtils.isBlank((CharSequence)(preferencesPath = System.getenv("bidib.preferencesPath")))) {
            preferencesPath = System.getProperty("user.home");
            System.setProperty("bidib.preferencesPath", preferencesPath);
        }
        try {
            builder.run(argsList.toArray(new String[0]));
        }
        catch (Exception ex) {
            LOGGER.warn("Start application failed.", (Throwable)ex);
            System.exit(1);
        }
    }
}

