/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.common.view.converter;

import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.common.base.Preconditions;
import java.text.Format;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StringToFloatConverter
implements BindingConverter<Float, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringToFloatConverter.class);
    private final Format format;

    public StringToFloatConverter(Format format) {
        this.format = (Format)Preconditions.checkNotNull((Object)format, (String)"The format must not be null.");
    }

    public String targetValue(Float sourceValue) {
        LOGGER.info("Convert source value: {}", (Object)sourceValue);
        String returnValue = null;
        if (sourceValue != null) {
            float value = ((Number)sourceValue).floatValue();
            returnValue = this.format.format(Float.valueOf(value));
        }
        LOGGER.info("Converted return value: {}", returnValue);
        return returnValue;
    }

    public Float sourceValue(String targetValue) {
        LOGGER.info("Convert targetValue: {}", (Object)targetValue);
        Float returnValue = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)targetValue)) {
                String val = targetValue.replaceAll(",", ".");
                returnValue = Float.valueOf(val);
            }
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Cannot parse the target value {}", (Object)targetValue);
        }
        LOGGER.info("Converted return value number: {}", returnValue);
        return returnValue;
    }
}

