/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.comparison.controller;

import com.vlsolutions.swing.docking.DockingDesktop;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.core.schema.bidib2.BiDiB;
import org.bidib.jbidibc.core.schema.bidib2.Nodes;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.NodeProvider;
import org.bidib.wizard.api.model.connection.BidibConnection;
import org.bidib.wizard.core.service.ConnectionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ComparisonController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComparisonController.class);
    private final DockingDesktop desktop;
    @Autowired
    private ConnectionService connectionService;

    public ComparisonController(DockingDesktop desktop) {
        this.desktop = desktop;
    }

    public BiDiB exportNodeTreeToComparison() {
        LOGGER.info("Export node tree for comparison.");
        BidibConnection connection = this.connectionService.find("main");
        NodeProvider nodeProvider = connection.getNodeProvider();
        NodeInterface rootNode = nodeProvider.findNodeByAddress(Node.ROOTNODE_ADDR);
        BiDiB bidib = new BiDiB().withSchemaVersion("2.1");
        Nodes bidibNodes = new Nodes();
        bidib.setNodes(bidibNodes);
        org.bidib.jbidibc.core.schema.bidib2.Node bidibNode = this.createBidibNode(rootNode);
        bidibNodes.getNode().add(bidibNode);
        List subNodes = nodeProvider.findSubNodes(rootNode);
        if (CollectionUtils.isNotEmpty((Collection)subNodes)) {
            this.addSubNodes(nodeProvider, bidibNode, subNodes);
        }
        LOGGER.info("Prepared bidib: {}", (Object)bidib);
        return bidib;
    }

    private org.bidib.jbidibc.core.schema.bidib2.Node createBidibNode(NodeInterface node) {
        org.bidib.jbidibc.core.schema.bidib2.Node bidibNode = new org.bidib.jbidibc.core.schema.bidib2.Node();
        bidibNode.withUniqueId(node.getUniqueId());
        bidibNode.withVidPid(ByteUtils.getUniqueIdAsString((long)node.getUniqueId()));
        bidibNode.withProductName(node.getNode().getStoredString(0));
        bidibNode.withUserName(node.getNode().getStoredString(1));
        return bidibNode;
    }

    private void addSubNodes(NodeProvider nodeProvider, org.bidib.jbidibc.core.schema.bidib2.Node parentBidibNode, List<NodeInterface> nodes) {
        for (NodeInterface node : nodes) {
            org.bidib.jbidibc.core.schema.bidib2.Node bidibNode = this.createBidibNode(node);
            parentBidibNode.getNode().add(bidibNode);
            List subNodes = nodeProvider.findSubNodes(node);
            if (!CollectionUtils.isNotEmpty((Collection)subNodes)) continue;
            this.addSubNodes(nodeProvider, bidibNode, subNodes);
        }
    }
}

