/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.console.view;

import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.service.console.ConsoleColor;
import org.bidib.wizard.api.service.console.ConsoleModel;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.client.common.component.ColorPane;
import org.bidib.wizard.client.common.view.BasicPopupMenu;
import org.bidib.wizard.client.common.view.DockKeys;
import org.bidib.wizard.mvc.console.view.ConsoleView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleView
implements Dockable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsoleView.class);
    private final JPanel contentPanel;
    private final ColorPane coloredTextPane = new ColorPane();
    private final ConsoleModel consoleModel;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    private final PropertyChangeListener pcsContent;
    private final PropertyChangeListener pcsContentSize;
    private Color colorRed;
    private Color colorBlue;
    private Color colorGreen;
    private Color colorBlack;
    private Color colorGray;

    public ConsoleView(ConsoleService consoleService) {
        DockKeys.DOCKKEY_CONSOLE_VIEW.setName(Resources.getString(this.getClass(), (String)"title"));
        DockKeys.DOCKKEY_CONSOLE_VIEW.setFloatEnabled(true);
        DockKeys.DOCKKEY_CONSOLE_VIEW.setAutoHideEnabled(false);
        LOGGER.info("Create new ConsoleView");
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BorderLayout());
        this.coloredTextPane.setEditable(false);
        JScrollPane scrollPane = new JScrollPane((Component)this.coloredTextPane);
        this.contentPanel.add(scrollPane);
        this.colorRed = UIManager.getColor("Console.red");
        this.colorBlue = UIManager.getColor("Console.blue");
        this.colorGreen = UIManager.getColor("Console.green");
        this.colorBlack = UIManager.getColor("Console.black");
        this.colorGray = UIManager.getColor("Console.gray");
        this.consoleModel = consoleService.getConsoleModel();
        this.pcsContent = new /* Unavailable Anonymous Inner Class!! */;
        this.consoleModel.addPropertyChangeListener("consoleContent", this.pcsContent);
        this.pcsContentSize = new /* Unavailable Anonymous Inner Class!! */;
        this.consoleModel.addPropertyChangeListener("consoleContentSize", this.pcsContentSize);
        BasicPopupMenu popupMenu = new BasicPopupMenu();
        JMenuItem clearConsole = new JMenuItem(Resources.getString(this.getClass(), (String)"clear_console"));
        clearConsole.addActionListener(evt -> this.fireClearConsole());
        popupMenu.add(clearConsole);
        this.coloredTextPane.setComponentPopupMenu((JPopupMenu)popupMenu);
    }

    private Color getColor(ConsoleColor consoleColor) {
        Color color = this.colorBlack;
        switch (3.$SwitchMap$org$bidib$wizard$api$service$console$ConsoleColor[consoleColor.ordinal()]) {
            case 1: {
                color = this.colorRed;
                break;
            }
            case 2: {
                color = this.colorBlue;
                break;
            }
            case 3: {
                color = this.colorGreen;
                break;
            }
            case 4: {
                color = this.colorGray;
                break;
            }
        }
        return color;
    }

    public Component getComponent() {
        return this.contentPanel;
    }

    public DockKey getDockKey() {
        return DockKeys.DOCKKEY_CONSOLE_VIEW;
    }

    public void close() {
        this.consoleModel.removePropertyChangeListener("consoleContent", this.pcsContent);
        this.consoleModel.removePropertyChangeListener("consoleContentSize", this.pcsContentSize);
    }

    private void fireClearConsole() {
        LOGGER.info("clear the console.");
        this.consoleModel.clear();
        this.coloredTextPane.clear();
    }
}

