/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.dmx.controller;

import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockingConstants;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.RelativeDockablePosition;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.commons.collections.CollectionUtils;
import org.bidib.jbidibc.core.node.ConfigurationVariable;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.NodeListProvider;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.api.service.node.SwitchingNodeService;
import org.bidib.wizard.client.common.view.DockUtils;
import org.bidib.wizard.client.common.view.cvdef.CvDefinitionTreeHelper;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.core.service.SettingsService;
import org.bidib.wizard.core.service.node.NodeService;
import org.bidib.wizard.model.ports.BacklightPort;
import org.bidib.wizard.model.ports.DmxChannel;
import org.bidib.wizard.model.ports.DmxLightPort;
import org.bidib.wizard.model.ports.LightPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.mvc.dmx.controller.listener.DmxModelerControllerListener;
import org.bidib.wizard.mvc.dmx.model.DmxScenery;
import org.bidib.wizard.mvc.dmx.model.DmxSceneryModel;
import org.bidib.wizard.mvc.dmx.view.DmxModelerView;
import org.bidib.wizard.mvc.dmx.view.DmxSceneryView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DmxModelerController
implements DmxModelerControllerListener,
NodeListListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DmxModelerController.class);
    private final JFrame parent;
    private DockingDesktop desktop;
    private NodeListProvider nodeListProvider;
    private DmxSceneryModel dmxSceneryModel;
    private DmxModelerView view;
    private final NodeInterface node;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private SwitchingNodeService switchingNodeService;
    @Autowired
    private SettingsService settingsService;
    @Autowired
    private WizardLabelWrapper wizardLabelWrapper;

    public DmxModelerController(NodeInterface node, JFrame parent) {
        this.parent = parent;
        this.node = node;
        this.dmxSceneryModel = new DmxSceneryModel();
    }

    public void start(DockingDesktop desktop, NodeListProvider mainModel) {
        this.nodeListProvider = mainModel;
        this.desktop = desktop;
        LOGGER.info("Start controller.");
        String searchKey = "DmxSceneryView";
        LOGGER.info("Search for view with key: {}", (Object)searchKey);
        Dockable view = desktop.getContext().getDockableByKey(searchKey);
        if (view != null) {
            LOGGER.info("Select the existing DMX scenery view.");
            DockUtils.selectWindow((Dockable)view);
            return;
        }
        this.createDockable();
    }

    public Dockable createDockable() {
        LinkedList<DmxChannel> dmxChannels = new LinkedList<DmxChannel>();
        for (int channelId = 0; channelId < 64; ++channelId) {
            dmxChannels.add(new DmxChannel(channelId + 1));
        }
        this.dmxSceneryModel.setDmxChannels(dmxChannels);
        LinkedList macros = new LinkedList();
        macros.add(null);
        macros.addAll(this.node.getMacros());
        this.dmxSceneryModel.setMacros(macros);
        if (ProductUtils.isOneDMX((long)this.node.getUniqueId())) {
            boolean oldCVHandlingEnabled;
            ConfigurationVariable cv;
            LOGGER.info("The current node is a OneDMX.");
            if (CollectionUtils.isNotEmpty(dmxChannels)) {
                Map dmxChannelMap = null;
                dmxChannelMap = new CvDefinitionTreeHelper().getNodes(this.node, "Config\\DMX channels (init)", -1, false, null);
                if (dmxChannelMap == null) {
                    dmxChannelMap = new CvDefinitionTreeHelper().getNodes(this.node, "Config\\DMX-Channels", -1, false, null);
                }
                LOGGER.info("Fetched dmxChannelMap: {}", (Object)dmxChannelMap);
                LinkedList cvList = new LinkedList(dmxChannelMap.values());
                List cvValueList = this.nodeService.queryConfigVariables("main", this.node, cvList);
                LOGGER.info("Fetched cvList: {}", (Object)cvValueList);
                for (DmxChannel dmxChannel : dmxChannels) {
                    int initialState;
                    int channelId = dmxChannel.getChannelId();
                    cv = (ConfigurationVariable)cvValueList.get(channelId - 1);
                    if (cv.isTimeout() || (initialState = Integer.parseInt(cv.getValue())) <= -1 || initialState >= 256) continue;
                    dmxChannel.setInitialState(initialState);
                }
            }
            if (oldCVHandlingEnabled = false) {
                Map lightPortMap = null;
                lightPortMap = new CvDefinitionTreeHelper().getNodes(this.node, "Config\\Light ports", -1, false, null);
                LOGGER.trace("returned lightPortMap: {}", (Object)lightPortMap);
                if (lightPortMap != null && lightPortMap.size() > 0) {
                    List<Object> cvList = new LinkedList(lightPortMap.values());
                    cvList = this.nodeService.queryConfigVariables("main", this.node, cvList);
                    LOGGER.info("Fetched cvList: {}", cvList);
                    List lightPorts = this.node.getLightPorts();
                    LinkedList<DmxLightPort> dmxLightPorts = new LinkedList<DmxLightPort>();
                    for (int index = 0; index < lightPorts.size(); ++index) {
                        cv = (ConfigurationVariable)cvList.get(index);
                        LOGGER.info("Current cv: {}", (Object)cv);
                        LightPort lightPort = (LightPort)lightPorts.get(index);
                        DmxLightPort dmxLightPort = new DmxLightPort(lightPort);
                        try {
                            int channelId = Integer.parseInt(cv.getValue());
                            if (channelId > -1) {
                                DmxChannel dmxTargetChannel = dmxChannels.stream().filter(ch -> ch.getChannelId() == channelId).findFirst().orElse(null);
                                dmxLightPort.setDmxTargetChannel(dmxTargetChannel);
                            } else {
                                LOGGER.debug("Invalid channel id for dmxChannel: {}", (Object)channelId);
                            }
                        }
                        catch (IndexOutOfBoundsException | NumberFormatException ex) {
                            LOGGER.warn("Set DMX target channel failed.", (Throwable)ex);
                        }
                        dmxLightPorts.add(dmxLightPort);
                    }
                    this.dmxSceneryModel.setLightPorts(dmxLightPorts);
                } else {
                    LOGGER.warn("No lightports configured.");
                }
            } else {
                List lightPorts = this.node.getLightPorts();
                LinkedList<DmxLightPort> dmxLightPorts = new LinkedList<DmxLightPort>();
                for (LightPort lightPort : lightPorts) {
                    int channelId;
                    DmxLightPort dmxLightPort = new DmxLightPort(lightPort);
                    int n = channelId = lightPort.getDmxMapping() != null ? lightPort.getDmxMapping() : -1;
                    if (channelId > -1) {
                        DmxChannel dmxTargetChannel = dmxChannels.stream().filter(ch -> ch.getChannelId() == channelId + 1).findFirst().orElse(null);
                        LOGGER.info("Prepared dmxTargetChannel: {}", (Object)dmxTargetChannel);
                        dmxLightPort.setDmxTargetChannel(dmxTargetChannel);
                    } else {
                        LOGGER.debug("Invalid channel id for dmxChannel: {}", (Object)channelId);
                    }
                    dmxLightPorts.add(dmxLightPort);
                }
                this.dmxSceneryModel.setLightPorts(dmxLightPorts);
            }
        }
        this.dmxSceneryModel.setBacklightPorts(new LinkedList(this.node.getBacklightPorts()));
        LOGGER.info("Open the DMX scenery panel.");
        DmxSceneryView dmxSceneryView = new DmxSceneryView(this.desktop, this.node, this.dmxSceneryModel, this.settingsService, this.wizardLabelWrapper);
        dmxSceneryView.setDmxModelerControllerListener((DmxModelerControllerListener)this);
        dmxSceneryView.createPanel();
        Dockable nodeListPanel = this.desktop.getContext().getDockableByKey("nodeListPanel");
        this.desktop.split(nodeListPanel, (Dockable)dmxSceneryView, DockingConstants.SPLIT_BOTTOM, 0.2);
        this.nodeListProvider.addNodeListListener((NodeListListener)this);
        return dmxSceneryView;
    }

    public void openView(DmxScenery dmxScenery) {
        String searchKey = DmxModelerView.prepareKey((DmxScenery)dmxScenery);
        LOGGER.info("Search for view with key: {}", (Object)searchKey);
        Dockable dmxModelerView = this.desktop.getContext().getDockableByKey(searchKey);
        if (dmxModelerView == null) {
            LOGGER.info("Create new DmxModelerView.");
            this.view = new DmxModelerView(this.desktop, dmxScenery, this.dmxSceneryModel);
            Dockable tabPanel = this.desktop.getContext().getDockableByKey("tabPanel");
            if (tabPanel != null) {
                this.desktop.createTab(tabPanel, (Dockable)this.view, 1, true);
            } else {
                this.desktop.addDockable((Dockable)this.view, RelativeDockablePosition.RIGHT);
            }
            this.view.loadSceneryPoints();
        } else {
            LOGGER.info("Select the existing modeler view.");
            DockUtils.selectWindow((Dockable)dmxModelerView);
        }
    }

    public void closeView(DmxSceneryModel dmxSceneryModel) {
        for (DmxScenery dmxScenery : dmxSceneryModel.getSceneries()) {
            String searchKey = DmxModelerView.prepareKey((DmxScenery)dmxScenery);
            LOGGER.info("Search for view with key: {}", (Object)searchKey);
            Dockable dmxModelerView = this.desktop.getContext().getDockableByKey(searchKey);
            if (dmxModelerView == null) continue;
            LOGGER.info("Close the dmxModelerView: {}", (Object)dmxModelerView);
            this.desktop.close(dmxModelerView);
        }
    }

    public void listChanged() {
        LOGGER.info("The node list has changed.");
    }

    public void nodeChanged(NodeInterface node) {
        LOGGER.debug("The node has changed, current node in model: {}", (Object)node);
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalNodeChanged(node);
        } else {
            SwingUtilities.invokeLater(() -> this.internalNodeChanged(node));
        }
    }

    private void internalNodeChanged(NodeInterface node) {
        LOGGER.debug("handle node has changed, node: {}", (Object)this.node);
        if (this.node != null && this.node.equals(node)) {
            LOGGER.debug("The node in the model has not changed.");
            return;
        }
    }

    private void cleanupSelectedNode() {
        List lightPorts = this.dmxSceneryModel.getLightPorts();
        if (CollectionUtils.isNotEmpty((Collection)lightPorts)) {
            for (DmxLightPort lightPort : lightPorts) {
                lightPort.freeLightPort();
            }
        }
        for (DmxScenery dmxScenery : this.dmxSceneryModel.getSceneries()) {
            String searchKey = DmxModelerView.prepareKey((DmxScenery)dmxScenery);
            LOGGER.info("Search for view with key: {}", (Object)searchKey);
            Dockable dmxModelerViewDockable = this.desktop.getContext().getDockableByKey(searchKey);
            if (dmxModelerViewDockable == null || !(dmxModelerViewDockable instanceof DmxModelerView)) continue;
            LOGGER.info("Close the DmxModelerView: {}", (Object)dmxModelerViewDockable);
            this.desktop.close(dmxModelerViewDockable);
        }
        Dockable dmxSceneryDockable = this.desktop.getContext().getDockableByKey("DmxSceneryView");
        if (dmxSceneryDockable != null) {
            LOGGER.info("Close the DMX scenery panel: {}", (Object)dmxSceneryDockable);
            this.desktop.close(dmxSceneryDockable);
        }
        this.nodeListProvider.removeNodeListListener((NodeListListener)this);
    }

    public void nodeStateChanged(NodeInterface node) {
    }

    public void listNodeAdded(NodeInterface node) {
    }

    public void listNodeRemoved(NodeInterface node) {
        if (this.node != null && this.node.equals(node)) {
            LOGGER.info("The selected node was removed from the node list.");
            this.cleanupSelectedNode();
        }
    }

    public void nodeWillChange(NodeInterface node) {
    }

    public void portConfigChanged(Port<?> port) {
        LOGGER.info("The port config has changed, port: {}", port);
        try {
            if (port instanceof DmxLightPort) {
                LightPort lightPort = ((DmxLightPort)port).getLightPort();
                this.switchingNodeService.setPortConfig("main", this.node.getSwitchingNode(), (Port)lightPort);
            } else if (port instanceof BacklightPort) {
                BacklightPort backlightPort = (BacklightPort)port;
                LOGGER.info("Current backlightPort: {}", (Object)backlightPort);
                this.switchingNodeService.setPortConfig("main", this.node.getSwitchingNode(), (Port)backlightPort);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Set the port parameters failed.", (Throwable)ex);
        }
    }
}

