/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.dmx.view.panel;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Field;
import java.util.Objects;
import org.bidib.wizard.api.model.function.MacroFunction;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.status.BidibStatus;
import org.jfree.data.xy.XYDataItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmxDataItem
extends XYDataItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(DmxDataItem.class);
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_TIME_OFFSET = "timeOffset";
    public static final String PROPERTY_BRIGHTNESS = "brightness";
    public static final String PROPERTY_PORT = "port";
    public static final String PROPERTY_MACRO = "macro";
    public static final String PROPERTY_ACTION = "action";
    private long uniqueId;
    private Port<?> port;
    private MacroFunction macro;
    private BidibStatus action;
    private transient PropertyChangeSupport changeSupport;

    public DmxDataItem(Number timeOffset, Number brightness, long uniqueId, Port<?> port) {
        super(timeOffset, brightness);
        this.port = port;
        this.uniqueId = uniqueId;
    }

    public DmxDataItem(Number timeOffset, Number brightness, long uniqueId, MacroFunction macro) {
        super(timeOffset, brightness);
        this.macro = macro;
        this.uniqueId = uniqueId;
    }

    public long getUniqueId() {
        return this.uniqueId;
    }

    public Port<?> getPort() {
        return this.port;
    }

    public void setPort(Port<?> port) {
        Port oldPortValue = this.port;
        this.port = port;
        MacroFunction oldMacroValue = this.macro;
        this.macro = null;
        this.firePropertyChange(PROPERTY_PORT, (Object)oldPortValue, port);
        this.firePropertyChange(PROPERTY_MACRO, (Object)oldMacroValue, (Object)this.macro);
    }

    public MacroFunction getMacro() {
        return this.macro;
    }

    public void setMacro(MacroFunction macro) {
        Port oldPortValue = this.port;
        this.port = null;
        MacroFunction oldMacroValue = this.macro;
        this.macro = macro;
        BidibStatus oldActionValue = this.action;
        this.action = null;
        this.firePropertyChange(PROPERTY_PORT, (Object)oldPortValue, (Object)this.port);
        this.firePropertyChange(PROPERTY_MACRO, (Object)oldMacroValue, (Object)macro);
        this.firePropertyChange(PROPERTY_ACTION, (Object)oldActionValue, (Object)this.action);
    }

    public int getTimeOffset() {
        return Double.valueOf(this.getXValue()).intValue();
    }

    public int getBrightness() {
        return Double.valueOf(this.getYValue()).intValue();
    }

    public void setTimeOffset(int timeOffset) {
        LOGGER.debug("Set the new timeoffset value: {}", (Object)timeOffset);
        try {
            Field fieldX = XYDataItem.class.getDeclaredField("x");
            fieldX.setAccessible(true);
            fieldX.set(this, timeOffset);
        }
        catch (Exception ex) {
            LOGGER.warn("Set the timeoffset value failed.", (Throwable)ex);
        }
    }

    public void setBrightness(int brightness) {
        LOGGER.debug("Set the new brightness value: {}", (Object)brightness);
        try {
            this.setY((Number)brightness);
        }
        catch (Exception ex) {
            LOGGER.warn("Set the brightness value failed.", (Throwable)ex);
        }
    }

    public BidibStatus getAction() {
        return this.action;
    }

    public void setAction(BidibStatus action) {
        BidibStatus oldValue = this.action;
        this.action = action;
        this.firePropertyChange(PROPERTY_ACTION, (Object)oldValue, (Object)action);
    }

    public final synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = this.createPropertyChangeSupport((Object)this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public final synchronized void removeChangeListener(PropertyChangeListener listener) {
        if (listener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public final synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = this.createPropertyChangeSupport((Object)this);
        }
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public final synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    protected PropertyChangeSupport createPropertyChangeSupport(Object bean) {
        return new PropertyChangeSupport(bean);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeSupport aChangeSupport = this.changeSupport;
        if (aChangeSupport == null) {
            return;
        }
        aChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Object clone() {
        if (this.port != null) {
            DmxDataItem clone = new DmxDataItem(this.getX(), this.getY(), this.uniqueId, this.port);
            clone.setAction(this.getAction());
            return clone;
        }
        DmxDataItem clone = new DmxDataItem(this.getX(), this.getY(), this.uniqueId, this.macro);
        return clone;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append(", x: ").append(this.getXValue()).append(", y: ").append(this.getYValue()).append(", uniqueId: ").append(this.uniqueId).append(", port: ").append(this.port).append(", action: ").append(this.action).append(", macro: ").append(this.macro);
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DmxDataItem)) {
            return false;
        }
        DmxDataItem that = (DmxDataItem)obj;
        if (!this.getX().equals(that.getX())) {
            return false;
        }
        if (!Objects.equals(this.getY(), that.getY())) {
            return false;
        }
        if (!Objects.equals(this.getUniqueId(), that.getUniqueId())) {
            return false;
        }
        if (!Objects.equals(this.action, that.action)) {
            return false;
        }
        if (!Objects.equals(this.port, that.port)) {
            return false;
        }
        return Objects.equals(this.macro, that.macro);
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash = (int)((long)hash + this.uniqueId);
        if (this.action != null) {
            hash += this.action.hashCode();
        }
        if (this.port != null) {
            hash += this.port.hashCode();
        }
        if (this.macro != null) {
            hash += this.macro.hashCode();
        }
        return hash;
    }

    public int compareTo(Object o1) {
        int result;
        if (o1 instanceof DmxDataItem) {
            DmxDataItem dataItem = (DmxDataItem)o1;
            int compare = this.getTimeOffset() - dataItem.getTimeOffset();
            if (compare > 0) {
                result = 1;
            } else if (compare < 0) {
                result = -1;
            } else {
                LOGGER.info("The timeoffset is equal, compare the uniqueId: {}, other: {}", (Object)this.getUniqueId(), (Object)dataItem.getUniqueId());
                result = this.getUniqueId() - dataItem.getUniqueId() > 0L ? 1 : (this.getUniqueId() - dataItem.getUniqueId() < 0L ? -1 : 0);
            }
        } else {
            result = 1;
        }
        return result;
    }
}

