/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.dmx.view.panel;

import java.awt.event.ActionEvent;
import org.bidib.wizard.model.ports.DmxChannel;
import org.bidib.wizard.mvc.dmx.view.panel.DmxChartPanel;
import org.bidib.wizard.mvc.dmx.view.panel.DmxDataItem;
import org.bidib.wizard.mvc.dmx.view.panel.LocationAwareAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointRemoveAction
extends LocationAwareAction<DmxChannel> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PointRemoveAction.class);
    private DmxDataItem originalDataItem;
    private String text;

    public PointRemoveAction(String text, DmxDataItem dmxDataItem, DmxChannel dmxChannel, DmxChartPanel dmxChartPanel) {
        super(dmxDataItem.toString(), (Object)dmxChannel, dmxChartPanel);
        this.originalDataItem = dmxDataItem;
        this.text = text;
    }

    public void actionPerformed(ActionEvent event) {
        LOGGER.info("Remove dmxDataItem: {}", (Object)this.originalDataItem);
        String seriesKey = Integer.toString(((DmxChannel)this.getActionObject()).getChannelId());
        this.dmxChartPanel.removeDataItem(seriesKey, this.originalDataItem);
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        return this.text;
    }
}

