/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.dmx.view.panel;

import java.awt.Point;
import java.awt.event.ActionEvent;
import org.bidib.wizard.model.ports.DmxChannel;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.mvc.dmx.view.panel.DmxChartPanel;
import org.bidib.wizard.mvc.dmx.view.panel.DmxDataItem;
import org.bidib.wizard.mvc.dmx.view.panel.LocationAwareAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortAction
extends LocationAwareAction<DmxChannel> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PortAction.class);
    private Port<?> port;
    private DmxDataItem originalDataItem;

    public PortAction(Port<?> port, DmxChannel dmxChannel, DmxChartPanel dmxChartPanel, DmxDataItem originalDataItem) {
        super(port.toString(), (Object)dmxChannel, dmxChartPanel);
        this.port = port;
        this.originalDataItem = originalDataItem;
    }

    public void actionPerformed(ActionEvent event) {
        Point currentMousePoint = this.dmxChartPanel.getCurrentMousePoint();
        String seriesKey = Integer.toString(((DmxChannel)this.getActionObject()).getChannelId());
        LOGGER.info("Selected key: {}, currentMousePoint: {}", (Object)seriesKey, (Object)currentMousePoint);
        int currentX = (int)Math.round(currentMousePoint.getX());
        int currentY = (int)Math.round(currentMousePoint.getY());
        if (this.originalDataItem != null) {
            LOGGER.info("Use the coordinates of the original data item: {}", (Object)this.originalDataItem);
            currentX = this.originalDataItem.getTimeOffset();
            currentY = this.originalDataItem.getBrightness();
        }
        LOGGER.info("Add new point at X: {}, Y: {}", (Object)currentX, (Object)currentY);
        this.dmxChartPanel.createDataItem(seriesKey, currentX, currentY, this.port, (DmxChannel)this.getActionObject(), this.originalDataItem);
    }
}

