/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.controller;

import com.vlsolutions.swing.docking.DockingDesktop;
import java.awt.Point;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.FeedbackAddressData;
import org.bidib.jbidibc.messages.enums.AddressTypeEnum;
import org.bidib.jbidibc.messages.enums.EnrailmentDirectionEnum;
import org.bidib.wizard.api.model.CommandStationNodeInterface;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.api.service.node.CommandStationService;
import org.bidib.wizard.common.context.DefaultApplicationContext;
import org.bidib.wizard.config.LocoControllerFactory;
import org.bidib.wizard.config.PomProgrammerControllerFactory;
import org.bidib.wizard.mvc.loco.controller.LocoController;
import org.bidib.wizard.mvc.main.controller.GlobalDetectorPanelController;
import org.bidib.wizard.mvc.main.controller.listener.GlobalDetectorPanelListener;
import org.bidib.wizard.mvc.main.model.GlobalDetectorModel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.panel.GlobalDetectorPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.bidib.wizard.mvc.pom.controller.PomProgrammerController;
import org.bidib.wizard.mvc.pom.controller.listener.PomProgrammerControllerListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class GlobalDetectorPanelController
implements GlobalDetectorPanelListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalDetectorPanelController.class);
    private final MainModel mainModel;
    private final GlobalDetectorModel globalDetectorModel;
    private final NodeListListener nodeListListener;
    private GlobalDetectorPanel globalDetectorPanel;
    @Autowired
    private CommandStationService commandStationService;
    private final TabVisibilityListener tabVisibilityListener;

    public GlobalDetectorPanelController(MainModel mainModel, TabVisibilityListener tabVisibilityListener) {
        this.mainModel = mainModel;
        this.tabVisibilityListener = tabVisibilityListener;
        this.globalDetectorModel = new GlobalDetectorModel();
        this.nodeListListener = new /* Unavailable Anonymous Inner Class!! */;
        this.mainModel.addNodeListListener(this.nodeListListener);
    }

    public NodeInterface getSelectedNode() {
        return this.globalDetectorModel.getSelectedNode();
    }

    public GlobalDetectorPanel createGlobalDetectorPanel() {
        LOGGER.debug("Create new GlobalDetectorPanel.");
        this.globalDetectorPanel = new GlobalDetectorPanel((GlobalDetectorPanelListener)this, this.globalDetectorModel, this.mainModel, this.tabVisibilityListener);
        return this.globalDetectorPanel;
    }

    public void openLocoDialog(FeedbackAddressData addressData) {
        LOGGER.info("Open the loco controller dialog, addressData: {}", (Object)addressData);
        CommandStationNodeInterface node = this.findFirstCommandStationNode((Iterable)this.mainModel.getNodeProvider().getNodes());
        if (node != null) {
            org.bidib.wizard.api.context.ApplicationContext applicationContext = DefaultApplicationContext.getInstance();
            ApplicationContext ctx = (ApplicationContext)applicationContext.get("SpringContext", ApplicationContext.class);
            LocoControllerFactory locoControllerFactory = (LocoControllerFactory)ctx.getBean(LocoControllerFactory.class);
            LocoController locoController = locoControllerFactory.createLocoController(node, (JFrame)JOptionPane.getFrameForComponent(this.globalDetectorPanel.getComponent()), this.mainModel.getNodeProvider());
            AddressData initialAddress = null;
            if (addressData != null) {
                EnrailmentDirectionEnum enrailmentDirection = addressData.getType();
                AddressTypeEnum addressType = null;
                switch (4.$SwitchMap$org$bidib$jbidibc$messages$enums$EnrailmentDirectionEnum[enrailmentDirection.ordinal()]) {
                    case 1: 
                    case 2: {
                        addressType = AddressTypeEnum.LOCOMOTIVE_FORWARD;
                        break;
                    }
                    case 3: {
                        addressType = AddressTypeEnum.ACCESSORY;
                        break;
                    }
                    case 4: {
                        addressType = AddressTypeEnum.EXTENDED_ACCESSORY;
                        break;
                    }
                }
                initialAddress = new AddressData(addressData.getAddress(), addressType);
            }
            locoController.start(initialAddress);
        }
    }

    public void openPomDialog(FeedbackAddressData addressData) {
        LOGGER.info("Open the POM dialog, addressData: {}", (Object)addressData);
        CommandStationNodeInterface node = this.findFirstCommandStationNode((Iterable)this.mainModel.getNodeProvider().getNodes());
        if (node != null) {
            org.bidib.wizard.api.context.ApplicationContext applicationContext = DefaultApplicationContext.getInstance();
            ApplicationContext ctx = (ApplicationContext)applicationContext.get("SpringContext", ApplicationContext.class);
            PomProgrammerControllerFactory pomProgrammerControllerFactory = (PomProgrammerControllerFactory)ctx.getBean(PomProgrammerControllerFactory.class);
            PomProgrammerController pomProgrammerController = pomProgrammerControllerFactory.createPomProgrammerController(node, (JFrame)JOptionPane.getFrameForComponent(this.globalDetectorPanel.getComponent()), new Point(0, 0));
            pomProgrammerController.addPomProgrammerControllerListener((PomProgrammerControllerListener)new /* Unavailable Anonymous Inner Class!! */);
            AddressData initialAddress = null;
            if (addressData != null) {
                EnrailmentDirectionEnum enrailmentDirection = addressData.getType();
                AddressTypeEnum addressType = null;
                switch (4.$SwitchMap$org$bidib$jbidibc$messages$enums$EnrailmentDirectionEnum[enrailmentDirection.ordinal()]) {
                    case 1: 
                    case 2: {
                        addressType = AddressTypeEnum.LOCOMOTIVE_FORWARD;
                        break;
                    }
                    case 3: {
                        addressType = AddressTypeEnum.ACCESSORY;
                        break;
                    }
                    case 4: {
                        addressType = AddressTypeEnum.EXTENDED_ACCESSORY;
                        break;
                    }
                }
                initialAddress = new AddressData(addressData.getAddress(), addressType);
            }
            DockingDesktop desktop = (DockingDesktop)DefaultApplicationContext.getInstance().get("desktop", DockingDesktop.class);
            pomProgrammerController.start(desktop, initialAddress);
        }
    }

    private CommandStationNodeInterface findFirstCommandStationNode(Iterable<NodeInterface> nodes) {
        NodeInterface node = (NodeInterface)IterableUtils.find(nodes, (Predicate)new /* Unavailable Anonymous Inner Class!! */);
        return node != null ? node.getCommandStationNode() : null;
    }
}

