/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.model;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.schema.bidibbase.BaseLabel;
import org.bidib.jbidibc.core.schema.bidiblabels.AccessoryLabel;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.exchange.lcmacro.LcAccessoryExporter;
import org.bidib.jbidibc.exchange.lcmacro.LcAccessorySwitchTime;
import org.bidib.jbidibc.exchange.lcmacro.LcAccessoryType;
import org.bidib.jbidibc.exchange.lcmacro.LcAspectPointType;
import org.bidib.jbidibc.exchange.lcmacro.TimeBaseUnitType;
import org.bidib.jbidibc.messages.enums.TimeBaseUnitEnum;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.model.Accessory;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.api.model.MacroRef;
import org.bidib.wizard.api.model.PortsProvider;
import org.bidib.wizard.core.labels.AccessoryLabelUtils;
import org.bidib.wizard.mvc.main.model.AccessoryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class AccessoryFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessoryFactory.class);

    private AccessoryFactory() {
    }

    public static void saveAccessory(String fileName, Accessory accessory, ApplicationContext context) throws FileNotFoundException, IOException {
        AccessoryFactory.saveAccessory((String)fileName, (Accessory)accessory, (boolean)true, (ApplicationContext)context);
    }

    public static void saveAccessory(String fileName, Accessory accessory, boolean gzip, ApplicationContext context) throws FileNotFoundException, IOException {
        new AccessoryFactory().saveAccessoryWithJaxb(fileName, accessory, false, context);
    }

    public static Accessory loadAccessory(String fileName, PortsProvider portsProvider, ApplicationContext context) {
        Accessory accessory = new AccessoryFactory().loadAccessoryWithJaxb(fileName, portsProvider, context);
        return accessory;
    }

    protected void saveAccessoryWithJaxb(String fileName, Accessory accessory, boolean gzip, ApplicationContext context) {
        LcAccessoryType lcAccessory = new LcAccessoryType();
        int accessoryId = accessory.getId();
        lcAccessory.setAccessoryId(accessoryId);
        lcAccessory.setAccessoryName(accessory.toString());
        NodeLabels accessoryLabels = (NodeLabels)context.get("labels", NodeLabels.class);
        AccessoryLabel accessoryAspectLabel = AccessoryLabelUtils.getAccessoryLabel((NodeLabels)accessoryLabels, (int)accessoryId);
        lcAccessory.setStartupState(accessory.getStartupState());
        Integer switchTime = accessory.getSwitchTime();
        if (switchTime != null) {
            LcAccessorySwitchTime lcAccessorySwitchTime = new LcAccessorySwitchTime();
            lcAccessorySwitchTime.setSwitchTime(switchTime.intValue());
            TimeBaseUnitEnum timeBaseUnit = accessory.getTimeBaseUnit();
            switch (1.$SwitchMap$org$bidib$jbidibc$messages$enums$TimeBaseUnitEnum[timeBaseUnit.ordinal()]) {
                case 1: {
                    lcAccessorySwitchTime.setTimeBaseUnit(TimeBaseUnitType.UNIT_100_MS);
                    break;
                }
                case 2: {
                    lcAccessorySwitchTime.setTimeBaseUnit(TimeBaseUnitType.UNIT_1_S);
                    break;
                }
                default: {
                    LOGGER.warn("Unsupported timebase unit detected for conversion to xml: {}", (Object)timeBaseUnit);
                    throw new RuntimeException("Unsupported timebase unit detected for conversion to xml: " + timeBaseUnit);
                }
            }
        }
        int aspectIndex = 0;
        for (MacroRef aspect : accessory.getAspects()) {
            Integer macroId = aspect.getId();
            LcAspectPointType lcAspectPoint = new LcAspectPointType();
            BaseLabel aspectLabel = AccessoryLabelUtils.getAccessoryAspectLabel((AccessoryLabel)accessoryAspectLabel, (int)aspectIndex);
            if (aspectLabel != null && StringUtils.isNotBlank((CharSequence)aspectLabel.getLabel())) {
                lcAspectPoint.setAspectName(aspectLabel.getLabel());
            }
            lcAspectPoint.setMacroId(macroId.intValue());
            lcAccessory.getLcAspectPoint().add(lcAspectPoint);
            ++aspectIndex;
        }
        new LcAccessoryExporter().saveAccessory(lcAccessory, fileName, gzip);
    }

    protected Accessory loadAccessoryWithJaxb(String fileName, PortsProvider portsProvider, ApplicationContext context) {
        LcAccessoryType lcAccessory = new LcAccessoryExporter().loadAccessory(fileName);
        Accessory accessory = null;
        if (lcAccessory != null) {
            accessory = new Accessory();
            int accessoryId = lcAccessory.getAccessoryId();
            accessory.setId(Integer.valueOf(accessoryId));
            NodeLabels nodeLabels = (NodeLabels)context.get("labels", NodeLabels.class);
            String label = lcAccessory.getAccessoryName();
            accessory.setLabel(label);
            AccessoryLabelUtils.replaceAccessoryLabel((NodeLabels)nodeLabels, (int)accessory.getId(), (String)label);
            accessory.setStartupState(lcAccessory.getStartupState());
            if (lcAccessory.getAccessorySwitchTime() != null) {
                accessory.setSwitchTime(Integer.valueOf(lcAccessory.getAccessorySwitchTime().getSwitchTime()));
                switch (1.$SwitchMap$org$bidib$jbidibc$exchange$lcmacro$TimeBaseUnitType[lcAccessory.getAccessorySwitchTime().getTimeBaseUnit().ordinal()]) {
                    case 1: {
                        accessory.setTimeBaseUnit(TimeBaseUnitEnum.UNIT_100MS);
                        break;
                    }
                    case 2: {
                        accessory.setTimeBaseUnit(TimeBaseUnitEnum.UNIT_1S);
                        break;
                    }
                }
            }
            ArrayList<MacroRef> macroIds = new ArrayList<MacroRef>();
            int aspectId = 0;
            for (LcAspectPointType lcAspectPoint : lcAccessory.getLcAspectPoint()) {
                Macro macro = null;
                for (Macro currentMacro : portsProvider.getMacros()) {
                    if (currentMacro.getId() != lcAspectPoint.getMacroId()) continue;
                    macro = currentMacro;
                    String aspectName = lcAspectPoint.getAspectName();
                    LOGGER.info("Found new aspect name to set: {}", (Object)aspectName);
                    AccessoryLabelUtils.replaceAspectLabel((NodeLabels)nodeLabels, (int)accessoryId, (int)aspectId, (String)aspectName);
                    break;
                }
                if (macro != null) {
                    LOGGER.info("Add current macro reference as aspect to accessory: {}", macro);
                    MacroRef aspect = new MacroRef(Integer.valueOf(macro.getId()));
                    macroIds.add(aspect);
                } else {
                    LOGGER.warn("No macro available to add to accessory with id: {}", (Object)lcAspectPoint.getMacroId());
                }
                ++aspectId;
            }
            accessory.setAspects(macroIds);
            accessory.setTotalAspects(macroIds.size());
        }
        LOGGER.info("return accessory: {}", (Object)accessory);
        return accessory;
    }
}

