/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.AdvancedTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.swing.StyledLabelBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.TableModelListener;
import org.bidib.jbidibc.messages.FeedbackAddressData;
import org.bidib.jbidibc.messages.FeedbackAddressDataWithDynState;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.mvc.main.controller.listener.GlobalDetectorPanelListener;
import org.bidib.wizard.mvc.main.model.GlobalDetectorModel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.panel.GlobalDetectorPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalDetectorPanel
implements TabVisibilityProvider,
TabPanelProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalDetectorPanel.class);
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "fill:50dlu:grow";
    private static final String ENCODED_DIALOG_ROW_SPECS = "fill:50dlu:grow";
    private final GlobalDetectorPanelListener controller;
    private final GlobalDetectorModel globalDetectorModel;
    private final TabVisibilityListener tabVisibilityListener;
    private JPanel contentPanel;
    private final AdvancedTableModel<FeedbackAddressDataWithDynState> decodersTableModel;

    public GlobalDetectorPanel(GlobalDetectorPanelListener controller, GlobalDetectorModel globalDetectorModel, MainModel model, TabVisibilityListener tabVisibilityListener) {
        Object panel;
        this.controller = controller;
        this.globalDetectorModel = globalDetectorModel;
        this.tabVisibilityListener = tabVisibilityListener;
        LOGGER.debug("Create new GlobalDetectorPanel.");
        FormBuilder dialogBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            panel = new FormDebugPanel();
            dialogBuilder = FormBuilder.create().columns("fill:50dlu:grow", new Object[0]).rows("fill:50dlu:grow", new Object[0]).panel((JPanel)panel);
        } else {
            panel = new JPanel(new BorderLayout());
            dialogBuilder = FormBuilder.create().columns("fill:50dlu:grow", new Object[0]).rows("fill:50dlu:grow", new Object[0]).panel((JPanel)panel);
        }
        dialogBuilder.border((Border)Paddings.TABBED_DIALOG);
        EventList addressDataEventList = globalDetectorModel.getAddressDataEventList();
        SortedList sortedAddressData = new SortedList(addressDataEventList, (Comparator)new AddressDataComparator());
        this.decodersTableModel = GlazedListsSwing.eventTableModelWithThreadProxyList((EventList)sortedAddressData, (TableFormat)new FeedbackAddressDataTableFormat());
        DetectorTable feedbackAddressDataTable = new DetectorTable(this, this.decodersTableModel);
        feedbackAddressDataTable.adjustRowHeight();
        DefaultOverlayable overlayTable = new DefaultOverlayable((JComponent)new JScrollPane((Component)feedbackAddressDataTable));
        feedbackAddressDataTable.getModel().addTableModelListener((TableModelListener)new /* Unavailable Anonymous Inner Class!! */);
        overlayTable.addOverlayComponent((JComponent)StyledLabelBuilder.createStyledLabel((String)("{" + feedbackAddressDataTable.getEmptyTableText() + ":f:gray}")));
        dialogBuilder.add((Component)overlayTable).xy(1, 1);
        this.contentPanel = dialogBuilder.build();
        this.contentPanel.setName(this.getName());
    }

    public JPanel getComponent() {
        return this.contentPanel;
    }

    public String getName() {
        return Resources.getString(this.getClass(), (String)"name");
    }

    public boolean isTabVisible() {
        NodeInterface node = this.globalDetectorModel.getSelectedNode();
        if (node != null) {
            boolean isTabVisible = node.isGlobalDetectorAvailable();
            LOGGER.debug("Check if tab is visible: {}", (Object)isTabVisible);
            return isTabVisible;
        }
        return false;
    }

    public void listChanged() {
        LOGGER.debug("List has changed, remove all rows and add rows again.");
        boolean isTabVisible = this.isTabVisible();
        this.tabVisibilityListener.setTabVisible((Component)this.contentPanel, isTabVisible);
    }

    private void fireOpenLocoDialog(FeedbackAddressDataWithDynState addressData) {
        this.controller.openLocoDialog((FeedbackAddressData)addressData);
    }

    private void fireOpenPomDialog(FeedbackAddressDataWithDynState addressData) {
        this.controller.openPomDialog((FeedbackAddressData)addressData);
    }
}

