/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import com.jidesoft.grid.TableColumnChooser;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.SoundPortListener;
import org.bidib.wizard.client.common.model.SimplePortTableModel;
import org.bidib.wizard.client.common.table.PortTable;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.client.common.view.listener.ButtonListener;
import org.bidib.wizard.client.common.view.renderer.PortConfigErrorAwareRenderer;
import org.bidib.wizard.client.common.view.renderer.PortIdentifierTableCellRenderer;
import org.bidib.wizard.model.ports.SoundPort;
import org.bidib.wizard.model.status.SoundPortStatus;
import org.bidib.wizard.mvc.main.controller.SoundPortPanelController;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.SoundPortTableModel;
import org.bidib.wizard.mvc.main.model.listener.SoundPortModelListener;
import org.bidib.wizard.mvc.main.view.panel.SimplePortListPanel;
import org.bidib.wizard.mvc.main.view.panel.SoundPortListPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabComponentCreator;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityProvider;
import org.bidib.wizard.mvc.main.view.table.SoundPortTableCellRenderer;

public class SoundPortListPanel
extends SimplePortListPanel<SoundPortStatus, SoundPort, SoundPortListener, SoundPortModelListener>
implements TabVisibilityProvider,
TabPanelProvider,
TabComponentCreator {
    private static final long serialVersionUID = 1L;
    private final MainModel mainModel;
    private final TabVisibilityListener tabVisibilityListener;

    public SoundPortListPanel(SoundPortPanelController controller, SoundPortTableModel tableModel, MainModel mainModel, TabVisibilityListener tabVisibilityListener) {
        super((SimplePortTableModel)tableModel, Resources.getString(SoundPortListPanel.class, (String)"emptyTable"));
        this.mainModel = mainModel;
        this.tabVisibilityListener = tabVisibilityListener;
        TableColumn tc = this.table.getColumnModel().getColumn(0);
        tc.setCellRenderer((TableCellRenderer)new PortConfigErrorAwareRenderer(0));
        tc.setIdentifier(0);
        tc = this.table.getColumnModel().getColumn(1);
        tc.setCellRenderer((TableCellRenderer)new SoundPortTableCellRenderer(1));
        tc.setCellEditor((TableCellEditor)new PortIntegerEditor(this, 0, 255, 1));
        tc.setIdentifier(1);
        tc = this.table.getColumnModel().getColumn(2);
        tc.setCellRenderer((TableCellRenderer)new PortIdentifierTableCellRenderer());
        tc.setMaxWidth(80);
        tc.setIdentifier(2);
        tc = this.table.getColumnModel().getColumn(3);
        tc.setIdentifier(3);
        tc.setCellRenderer((TableCellRenderer)new /* Unavailable Anonymous Inner Class!! */);
        tc.setMaxWidth(80);
        TableColumn buttonColumn = this.table.getColumnModel().getColumn(4);
        buttonColumn.setIdentifier(4);
        buttonColumn.setCellRenderer((TableCellRenderer)new /* Unavailable Anonymous Inner Class!! */);
        3 editor = new /* Unavailable Anonymous Inner Class!! */;
        editor.addButtonListener((ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
        buttonColumn.setCellEditor((TableCellEditor)editor);
        TableColumnChooser.hideColumn((JTable)this.table, (int)5);
    }

    protected PortTable createPortTable(SimplePortTableModel<SoundPortStatus, SoundPort, SoundPortModelListener> tableModel, String emptyTableText) {
        5 portTable = new /* Unavailable Anonymous Inner Class!! */;
        return portTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listChanged() {
        this.LOGGER.info("The port list has changed.");
        super.listChanged();
        boolean hasPortIdentifiers = false;
        LinkedList ports = new LinkedList();
        ports.addAll(this.getPorts());
        LinkedList linkedList = ports;
        synchronized (linkedList) {
            for (SoundPort port : ports) {
                if (!port.isRemappingEnabled()) continue;
                hasPortIdentifiers = true;
                break;
            }
        }
        if (this.mainModel.getSelectedNode() != null) {
            this.LOGGER.info("A node is selected.");
            boolean hasSoundPortConfig = false;
            NodeInterface node = this.mainModel.getSelectedNode();
            if (node.getNode().isPortFlatModelAvailable() && CollectionUtils.isNotEmpty((Collection)node.getEnabledSoundPorts())) {
                this.LOGGER.info("Check if the first sound port has the sound port config available.");
                hasSoundPortConfig = ((SoundPort)node.getEnabledSoundPorts().get(0)).isHasSoundPortConfig();
            } else if (CollectionUtils.isNotEmpty((Collection)node.getEnabledSoundPorts())) {
                this.LOGGER.info("Check if the first sound port has the sound port config available.");
                hasSoundPortConfig = ((SoundPort)node.getEnabledSoundPorts().get(0)).isHasSoundPortConfig();
            }
            this.LOGGER.info("List has changed, hasPortIdentifiers: {}, hasSoundPortConfig: {}", (Object)hasPortIdentifiers, (Object)hasSoundPortConfig);
            if (!hasSoundPortConfig) {
                TableColumnChooser.hideColumn((JTable)this.table, (int)1);
            } else if (!TableColumnChooser.isVisibleColumn((JTable)this.table, (int)1)) {
                TableColumnChooser.showColumn((JTable)this.table, (int)1, (int)1);
            }
        }
        if (!hasPortIdentifiers) {
            TableColumnChooser.hideColumn((JTable)this.table, (int)2);
        } else if (!TableColumnChooser.isVisibleColumn((JTable)this.table, (int)2)) {
            TableColumnChooser.showColumn((JTable)this.table, (int)2, (int)2);
        }
        this.tabVisibilityListener.setTabVisible((Component)this, this.isTabVisible());
    }

    public JPanel getComponent() {
        return this;
    }

    public Object getCreator() {
        return this;
    }

    public boolean equals(Object other) {
        TabComponentCreator creator;
        return other instanceof TabComponentCreator && (creator = (TabComponentCreator)other).getCreator() instanceof SoundPortListPanel;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Class<?> getPortClass() {
        return SoundPort.class;
    }

    public boolean isTabVisible() {
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            boolean isTabVisible = node.hasSoundPorts();
            this.LOGGER.debug("Check if tab is visible: {}", (Object)isTabVisible);
            return isTabVisible;
        }
        return false;
    }

    protected List<SoundPort> getPorts() {
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            return node.getSoundPorts();
        }
        return Collections.emptyList();
    }

    public void refreshView() {
        this.listChanged();
    }
}

