/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.netdebug.controller;

import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingConstants;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.DockingUtilities;
import com.vlsolutions.swing.docking.RelativeDockablePosition;
import com.vlsolutions.swing.docking.TabbedDockableContainer;
import org.bidib.jbidibc.debug.DebugMessageListener;
import org.bidib.jbidibc.debug.DebugMessageReceiver;
import org.bidib.jbidibc.netbidib.debug.NetBidibDebugClientInterface;
import org.bidib.wizard.client.common.view.DockKeys;
import org.bidib.wizard.client.common.view.DockUtils;
import org.bidib.wizard.common.model.settings.DebugToolsSettingsInterface;
import org.bidib.wizard.core.service.SettingsService;
import org.bidib.wizard.mvc.netdebug.controller.listener.NetDebugControllerListener;
import org.bidib.wizard.mvc.netdebug.model.NetDebugModel;
import org.bidib.wizard.mvc.netdebug.view.NetDebugView;
import org.bidib.wizard.mvc.netdebug.view.listener.NetDebugViewListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class NetDebugController
implements NetDebugControllerListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetDebugController.class);
    private final DockingDesktop desktop;
    private NetDebugModel netDebugModel;
    private NetDebugView netDebugView;
    private NetBidibDebugClientInterface debugClient;
    private DebugMessageListener messageListener;
    private DebugMessageReceiver messageReceiver;
    @Autowired
    private SettingsService settingsService;

    public NetDebugController(DockingDesktop desktop) {
        this.desktop = desktop;
    }

    public void start() {
        String searchKey = "NetDebugView";
        LOGGER.info("Search for view with key: {}", (Object)searchKey);
        Dockable view = this.desktop.getContext().getDockableByKey(searchKey);
        if (view != null) {
            LOGGER.info("Select the existing debug interface view instead of open a new one.");
            DockUtils.selectWindow((Dockable)view);
            return;
        }
        LOGGER.info("Create new NetDebugView.");
        this.netDebugModel = new NetDebugModel();
        DebugToolsSettingsInterface debugToolsSettings = this.settingsService.getDebugToolsSettings();
        this.netDebugModel.setSelectedHost(debugToolsSettings.getNetBidibHost());
        this.netDebugModel.setSelectedPort(debugToolsSettings.getNetBidibPort());
        this.netDebugView = new NetDebugView(this.desktop, (NetDebugControllerListener)this, this.netDebugModel, this.settingsService);
        DockableState[] dockables = this.desktop.getDockables();
        LOGGER.info("Current dockables: {}", new Object[]{dockables});
        if (dockables.length > 1) {
            DockableState tabPanelNodeDetails = null;
            for (DockableState dockable : dockables) {
                if (!DockKeys.DOCKKEY_TAB_PANEL.equals((Object)dockable.getDockable().getDockKey())) continue;
                LOGGER.info("Found the tab panel dockable.");
                tabPanelNodeDetails = dockable;
                break;
            }
            Dockable dock = this.desktop.getDockables()[1].getDockable();
            if (tabPanelNodeDetails != null) {
                LOGGER.info("Add the debug interface view next to the node details panel.");
                dock = tabPanelNodeDetails.getDockable();
                TabbedDockableContainer container = DockingUtilities.findTabbedDockableContainer((Dockable)dock);
                int order = 0;
                if (container != null) {
                    order = container.getTabCount();
                }
                LOGGER.info("Add new debugInterfaceView at order: {}", (Object)order);
                this.desktop.createTab(dock, (Dockable)this.netDebugView, order, true);
            } else {
                this.desktop.split(dock, (Dockable)this.netDebugView, DockingConstants.SPLIT_RIGHT);
            }
        } else {
            this.desktop.addDockable((Dockable)this.netDebugView, RelativeDockablePosition.RIGHT);
        }
        this.netDebugView.addNetDebugViewListener((NetDebugViewListener)new /* Unavailable Anonymous Inner Class!! */);
        this.netDebugModel.addPropertyChangeListener("selectedHost", evt -> {
            LOGGER.info("Update the host in the settings.");
            debugToolsSettings.setNetBidibHost(this.netDebugModel.getSelectedHost());
        });
        this.netDebugModel.addPropertyChangeListener("selectedPort", evt -> {
            LOGGER.info("Update the port in the settings.");
            debugToolsSettings.setNetBidibPort(this.netDebugModel.getSelectedPort());
        });
    }

    private void fireCloseConnection() {
        if (this.debugClient != null) {
            LOGGER.info("Close the debug client.");
            this.debugClient.close();
            this.netDebugModel.setConnected(false);
            this.messageReceiver.removeMessageListener(this.messageListener);
            this.messageListener = null;
            this.messageReceiver = null;
            this.debugClient = null;
        } else {
            LOGGER.info("debug client not available.");
        }
    }

    public void viewClosed() {
        LOGGER.info("The view is closed.");
        this.fireCloseConnection();
    }
}

