/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.startup;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=3)
public class WizardStartupParams
implements ApplicationRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(WizardStartupParams.class);
    public static final String MODE_ICONIFIED = "iconified";
    private boolean autoConnect;
    private String startupMode;

    public boolean isAutoConnect() {
        return this.autoConnect;
    }

    public String getStartupMode() {
        return this.startupMode;
    }

    public void run(ApplicationArguments args) {
        LOGGER.info("Run with args: {}", (Object)args);
        List nonOptionArgs = args.getNonOptionArgs();
        if (CollectionUtils.isNotEmpty((Collection)nonOptionArgs)) {
            HashMap<String, String> options = new HashMap<String, String>();
            for (String option : nonOptionArgs) {
                String[] opt = option.split("=");
                if (opt.length <= 1 || opt[0] == null) continue;
                options.put(opt[0].toLowerCase(), opt[1]);
            }
            if (options.containsKey("-autoconnect")) {
                try {
                    this.autoConnect = Boolean.valueOf((String)options.get("-autoconnect"));
                }
                catch (Exception ex) {
                    LOGGER.warn("Get the autoconnect option failed.", (Throwable)ex);
                }
            }
            if (options.containsKey("-startupmode")) {
                try {
                    this.startupMode = (String)options.get("-startupmode");
                }
                catch (Exception ex) {
                    LOGGER.warn("Get the startupmode option failed.", (Throwable)ex);
                }
            }
        }
        LOGGER.info("autoConnect: {}, startupMode: {}", (Object)this.autoConnect, (Object)this.startupMode);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

