/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.utils;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import org.apache.commons.lang3.SystemUtils;
import org.bidib.wizard.utils.User32Ext;
import org.bidib.wizard.utils.WindowUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class WindowUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(WindowUtils.class);

    public static void bringWindowToFront(Window window) {
        block5: {
            LOGGER.info("Try to bring the window to front, window: {}", (Object)window);
            try {
                if (window == null) break block5;
                try {
                    if (SystemUtils.IS_OS_WINDOWS) {
                        WindowUtils.sendToTheTop((Pointer)Native.getWindowPointer((Window)window));
                        WinDef.HWND hWnd = new WinDef.HWND();
                        hWnd.setPointer(Native.getComponentPointer((Component)window));
                        boolean passedSetForeground = User32.INSTANCE.SetForegroundWindow(hWnd);
                        LOGGER.info("passedSetForeground: {}", (Object)passedSetForeground);
                        WinDef.HWND activeWindow = User32Ext.INSTANCE.SetActiveWindow(hWnd);
                        LOGGER.info("activeWindow: {}", (Object)activeWindow);
                        break block5;
                    }
                    LOGGER.info("Bring window to front only works on Windows OS.");
                }
                catch (Exception ex) {
                    LOGGER.warn("Cannot send the window {} to the front.", (Object)window, (Object)ex);
                }
            }
            catch (Throwable ex) {
                LOGGER.warn("bring window to front failed.");
            }
        }
    }

    public static boolean sendToTheTop(Pointer pointer) {
        if (SystemUtils.IS_OS_WINDOWS) {
            return WindowUtils.sendToTheTopWin32((Pointer)pointer);
        }
        throw new UnsupportedOperationException(String.format("The function sendToTheTop(Pointer) is not supported for the %s OS", SystemUtils.OS_NAME));
    }

    public static boolean sendToTheTopWin32(Pointer pointer) {
        if (pointer != null) {
            try {
                int fgId;
                WinDef.HWND thWindow = new WinDef.HWND(pointer);
                WinDef.HWND fgWindow = User32.INSTANCE.GetForegroundWindow();
                if (fgWindow == null) {
                    return false;
                }
                int thId = User32.INSTANCE.GetWindowThreadProcessId(thWindow, null);
                if (thId == (fgId = User32.INSTANCE.GetWindowThreadProcessId(fgWindow, null))) {
                    User32.INSTANCE.SetWindowPos(thWindow, new WinDef.HWND(new Pointer(0L)), 0, 0, 0, 0, WindowPosFlags.NOMOVE.flag() | WindowPosFlags.NOSIZE.flag());
                    User32.INSTANCE.SetForegroundWindow(thWindow);
                    User32.INSTANCE.SetFocus(thWindow);
                } else {
                    User32.INSTANCE.AttachThreadInput(new WinDef.DWORD((long)fgId), new WinDef.DWORD((long)thId), true);
                    User32.INSTANCE.SetWindowPos(thWindow, new WinDef.HWND(new Pointer(0L)), 0, 0, 0, 0, WindowPosFlags.NOMOVE.flag() | WindowPosFlags.NOSIZE.flag());
                    User32.INSTANCE.SetForegroundWindow(thWindow);
                    User32.INSTANCE.SetFocus(thWindow);
                    User32.INSTANCE.AttachThreadInput(new WinDef.DWORD((long)fgId), new WinDef.DWORD((long)thId), false);
                }
                return true;
            }
            catch (RuntimeException e) {
                LOGGER.warn("Cannot send the window to foreground.", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    public static boolean isValidScreenLocation(Rectangle location) {
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice device : environment.getScreenDevices()) {
            Rectangle bounds = device.getDefaultConfiguration().getBounds();
            if (location.x < bounds.x || location.x > bounds.x + bounds.width || location.y < bounds.y || location.y > bounds.y + bounds.height) continue;
            return true;
        }
        return false;
    }

    public static Rectangle getMaximumScreenBounds() {
        int minx = 0;
        int miny = 0;
        int maxx = 0;
        int maxy = 0;
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice device : environment.getScreenDevices()) {
            Rectangle bounds = device.getDefaultConfiguration().getBounds();
            minx = Math.min(minx, bounds.x);
            miny = Math.min(miny, bounds.y);
            maxx = Math.max(maxx, bounds.x + bounds.width);
            maxy = Math.max(maxy, bounds.y + bounds.height);
        }
        return new Rectangle(minx, miny, maxx - minx, maxy - miny);
    }

    public static Insets getScreenInsets(Window windowOrNull) {
        Insets insets = windowOrNull == null ? Toolkit.getDefaultToolkit().getScreenInsets(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration()) : windowOrNull.getToolkit().getScreenInsets(windowOrNull.getGraphicsConfiguration());
        return insets;
    }

    public static Rectangle getScreenWorkingArea(Window windowOrNull) {
        Rectangle bounds;
        Insets insets;
        if (windowOrNull == null) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            insets = Toolkit.getDefaultToolkit().getScreenInsets(ge.getDefaultScreenDevice().getDefaultConfiguration());
            bounds = ge.getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        } else {
            GraphicsConfiguration gc = windowOrNull.getGraphicsConfiguration();
            insets = windowOrNull.getToolkit().getScreenInsets(gc);
            bounds = gc.getBounds();
        }
        bounds.x += insets.left;
        bounds.y += insets.top;
        bounds.width -= insets.left + insets.right;
        bounds.height -= insets.top + insets.bottom;
        return bounds;
    }

    public static Rectangle getScreenTotalArea(Window windowOrNull) {
        Rectangle bounds;
        if (windowOrNull == null) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            bounds = ge.getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        } else {
            GraphicsConfiguration gc = windowOrNull.getGraphicsConfiguration();
            bounds = gc.getBounds();
        }
        return bounds;
    }

    public static void centerOnCurrentScreen(Component parent, Component view) {
        Rectangle screen = parent.getGraphicsConfiguration().getBounds();
        view.setLocation(screen.x + (screen.width - view.getWidth()) / 2, screen.y + (screen.height - view.getHeight()) / 2);
    }
}

