package org.bidib.wizard.mvc.locolist.view;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JMenuItem;

import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.view.BasicPopupMenu;
import org.bidib.wizard.mvc.locolist.controller.listener.LocoTableControllerListener;
import org.bidib.wizard.mvc.locolist.model.LocoModel;
import org.bidib.wizard.mvc.locolist.model.LocoTableModel;
import org.bidib.wizard.mvc.locolist.view.wizard.PushToMouseWizard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jgoodies.binding.list.SelectionInList;

public class LocoListMenu extends BasicPopupMenu {
    private static final long serialVersionUID = 1L;

    private static final Logger LOGGER = LoggerFactory.getLogger(LocoListMenu.class);

    private JMenuItem pushToMouseItem;

    private JMenuItem openLocoDialog;

    private JMenuItem openPomDialog;

    private final SelectionInList<LocoModel> locoSelection;

    private final LocoTableControllerListener locoTableController;

    private final LocoTableModel locoTableModel;

    private final Component parent;

    public LocoListMenu(final Component parent, final LocoTableControllerListener locoTableController,
        final SelectionInList<LocoModel> locoSelection, final LocoTableModel locoTableModel) {
        this.parent = parent;
        this.locoTableController = locoTableController;
        this.locoSelection = locoSelection;
        this.locoTableModel = locoTableModel;

        openLocoDialog = new JMenuItem(Resources.getString(LocoListMenu.class, "openLocoDialog") + " ...");

        openLocoDialog.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                LocoModel locoModel = locoSelection.getSelection();
                if (locoModel != null) {
                    fireOpenLocoDialog(locoModel);
                }
            }

        });
        add(openLocoDialog);

        openPomDialog = new JMenuItem(Resources.getString(LocoListMenu.class, "openPomDialog") + " ...");

        openPomDialog.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                LocoModel locoModel = locoSelection.getSelection();
                if (locoModel != null) {
                    fireOpenPomDialog(locoModel);
                }
            }

        });
        add(openPomDialog);

        pushToMouseItem = new JMenuItem(Resources.getString(getClass(), "pushToMouse") + " ...");

        pushToMouseItem.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                firePushToMouse(e);
            }

        });
        add(pushToMouseItem);

    }

    private void fireOpenLocoDialog(final LocoModel locoModel) {

        locoTableController.openLocoDialog(locoModel);
    }

    private void fireOpenPomDialog(final LocoModel locoModel) {

        locoTableController.openPomDialog(locoModel);
    }

    private void firePushToMouse(ActionEvent e) {

        final PushToMouseWizard nodeScriptWizard = new PushToMouseWizard();
        nodeScriptWizard.showWizard(locoTableController, locoTableModel);
    }
}
