package org.bidib.wizard.mvc.main.view.panel;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableColumn;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.bidib.jbidibc.core.node.ConfigurationVariable;
import org.bidib.jbidibc.core.schema.CvExchangeFactory;
import org.bidib.jbidibc.core.schema.cvexchange.CVListType;
import org.bidib.jbidibc.core.schema.cvexchange.CVSType;
import org.bidib.jbidibc.core.schema.cvexchange.MasterDataType;
import org.bidib.jbidibc.core.schema.cvexchange.SaveCV;
import org.bidib.jbidibc.exchange.vendorcv.CVType;
import org.bidib.jbidibc.exchange.vendorcv.DataType;
import org.bidib.jbidibc.exchange.vendorcv.ModeType;
import org.bidib.jbidibc.exchange.vendorcv.VendorCV;
import org.bidib.jbidibc.exchange.vendorcv.VendorCvError;
import org.bidib.jbidibc.exchange.vendorcv.VendorCvFactory;
import org.bidib.jbidibc.exchange.vendorcv.VersionInfoType;
import org.bidib.jbidibc.experimental.excel.ExcelExportFactory;
import org.bidib.jbidibc.experimental.excel.model.CvData;
import org.bidib.jbidibc.messages.SoftwareVersion;
import org.bidib.jbidibc.messages.StringData;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.helpers.DefaultContext;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.CvDefinitionListener;
import org.bidib.wizard.api.model.listener.CvDefinitionRequestListener;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.api.model.listener.PortListener;
import org.bidib.wizard.api.model.listener.PortListenerProvider;
import org.bidib.wizard.api.utils.XmlLocaleUtils;
import org.bidib.wizard.client.common.controller.CvDefinitionPanelControllerInterface;
import org.bidib.wizard.client.common.controller.FeedbackPortStatusChangeProvider;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.view.ButtonUtils;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.client.common.view.cvdef.AbstractNode;
import org.bidib.wizard.client.common.view.cvdef.CvBitfieldValueEditor;
import org.bidib.wizard.client.common.view.cvdef.CvByteValueEditor;
import org.bidib.wizard.client.common.view.cvdef.CvDccLongAddrValueEditor;
import org.bidib.wizard.client.common.view.cvdef.CvDefinitionTreeHelper;
import org.bidib.wizard.client.common.view.cvdef.CvDefinitionTreeTableModel;
import org.bidib.wizard.client.common.view.cvdef.CvIntegerValueEditor;
import org.bidib.wizard.client.common.view.cvdef.CvLongValueEditor;
import org.bidib.wizard.client.common.view.cvdef.CvNode;
import org.bidib.wizard.client.common.view.cvdef.CvRadioValueEditor;
import org.bidib.wizard.client.common.view.cvdef.CvSignedCharValueEditor;
import org.bidib.wizard.client.common.view.cvdef.CvValueEditor;
import org.bidib.wizard.client.common.view.cvdef.CvValueNumberEditor;
import org.bidib.wizard.client.common.view.cvdef.CvValueStringEditor;
import org.bidib.wizard.client.common.view.cvdef.DccAccAddrEditor;
import org.bidib.wizard.client.common.view.cvdef.DccAddrRGEditor;
import org.bidib.wizard.client.common.view.cvdef.DeviceNode;
import org.bidib.wizard.client.common.view.cvdef.GBM16TReverserEditor;
import org.bidib.wizard.client.common.view.cvdef.KeywordNodeNode;
import org.bidib.wizard.client.common.view.cvdef.LongCvNode;
import org.bidib.wizard.client.common.view.cvdef.LongNodeNode;
import org.bidib.wizard.client.common.view.cvdef.NodeNode;
import org.bidib.wizard.client.common.view.validation.IconFeedbackPanel;
import org.bidib.wizard.client.common.view.validation.PropertyValidationI18NSupport;
import org.bidib.wizard.common.context.DefaultApplicationContext;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.common.view.statusbar.StatusBar;
import org.bidib.wizard.core.dialog.FileDialog;
import org.bidib.wizard.core.service.SettingsService;
import org.bidib.wizard.model.ports.FeedbackPort;
import org.bidib.wizard.mvc.common.exception.NodeChangeVetoException;
import org.bidib.wizard.mvc.common.view.cvdefinition.CvDefinitionPanelProvider;
import org.bidib.wizard.mvc.common.view.cvdefinition.CvValueUtils;
import org.bidib.wizard.mvc.main.controller.MainController;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabComponentCreator;
import org.bidib.wizard.mvc.main.view.panel.listener.TabSelectionListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabStatusListener;
import org.bidib.wizard.mvc.main.view.table.CvDefinitionJideTreeTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jgoodies.binding.beans.Model;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.value.Trigger;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.factories.Paddings;
import com.jgoodies.validation.ValidationResultModel;
import com.jgoodies.validation.util.DefaultValidationResultModel;
import com.jgoodies.validation.util.PropertyValidationSupport;
import com.jgoodies.validation.view.ValidationComponentUtils;
import com.jidesoft.grid.DefaultExpandableRow;
import com.vlsolutions.swing.toolbars.ToolBarConstraints;
import com.vlsolutions.swing.toolbars.ToolBarPanel;
import com.vlsolutions.swing.toolbars.VLToolBar;

public class CvDefinitionPanel extends JPanel
    implements TabSelectionListener, CvDefinitionPanelProvider, CvDefinitionRequestListenerAware, TabPanelProvider,
    TabComponentCreator, PortListenerProvider<FeedbackPort>, NodeListListener {
    private static final long serialVersionUID = 1L;

    private static final Logger LOGGER = LoggerFactory.getLogger(CvDefinitionPanel.class);

    private static final String NONE = "none";

    private final SettingsService settingsService;

    private final CvDefinitionPanelControllerInterface cvDefinitionPanelController;

    private Map<String, ConfigurationVariable> configVariables;

    private CvDefinitionTreeTableModel treeModel;

    private JTextField textXmlFileName;

    private JTextField textVersion;

    private JTextField textLastUpdate;

    private JTextField textAuthor;

    private JTextField textDescription;

    private final CvDefinitionJideTreeTable cvTreeTable;

    private JButton saveButton;

    private CardLayout cardLayout;

    private EditorPanels editorPanels;

    private Map<String, CvNode> cvNumberToNodeMap;

    private static final String READ = "read";

    private static final String WRITE = "write";

    private static final String LOAD = "loadFromFile";

    private static final String SAVE = "saveToFile";

    private JButton readButton;

    private JButton writeButton;

    private JButton loadFromFileButton;

    private JButton saveToFileButton;

    private JButton exportToExcelButton;

    private VLToolBar toolbarCvDefinition;

    private final TabStatusListener tabStatusListener;

    private final MainModel mainModel;

    private final FeedbackPortStatusChangeProvider feedbackPortStatusChangeProvider;

    private final Map<DataType, CvValueEditor> mapDataTypeToEditor = new HashMap<>();

    private List<CvDefinitionRequestListener> cvDefinitionRequestListeners =
        new LinkedList<CvDefinitionRequestListener>();

    private JButton copyToUserDirCvDefinitionButton;

    public static final class CvDefinitionFileValueBean extends Model {
        private static final long serialVersionUID = 1L;

        public static final String PROPERTYNAME_FILENAME = "fileName";

        public static final String PROPERTYNAME_FILEPATH = "filePath";

        private String fileName;

        private String filePath;

        /**
         * @return the fileName
         */
        public String getFileName() {
            return fileName;
        }

        /**
         * @param fileName
         *            the fileName to set
         */
        public void setFileName(String fileName) {
            String oldValue = this.fileName;
            this.fileName = fileName;

            firePropertyChange(PROPERTYNAME_FILENAME, oldValue, fileName);
        }

        /**
         * @return the filePath
         */
        public String getFilePath() {
            return filePath;
        }

        /**
         * @param filePath
         *            the filePath to set
         */
        public void setFilePath(String filePath) {
            String oldValue = this.filePath;
            this.filePath = filePath;
            firePropertyChange(PROPERTYNAME_FILEPATH, oldValue, filePath);
        }

        public boolean isUserDefinedFile() {
            return StringUtils.isNotEmpty(filePath) && !filePath.startsWith("/bidib/");
        }
    }

    public CvDefinitionPanel(final CvDefinitionPanelControllerInterface cvDefinitionPanelController,
        final FeedbackPortStatusChangeProvider feedbackPortStatusChangeProvider, final MainModel mainModel,
        final TabStatusListener tabStatusListener, final SettingsService settingsService) {
        this.settingsService = settingsService;
        this.cvDefinitionPanelController = cvDefinitionPanelController;
        this.tabStatusListener = tabStatusListener;
        this.mainModel = mainModel;
        this.feedbackPortStatusChangeProvider = feedbackPortStatusChangeProvider;

        setLayout(new BorderLayout());
        setBorder(new EmptyBorder(5, 5, 5, 5));
        setOpaque(false);

        LOGGER.debug("Create the CV tree.");

        cvTreeTable = new CvDefinitionJideTreeTable();
        // cvTreeTable.setShowsRootHandles(false);
        cvTreeTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        cvTreeTable.getTableHeader().setReorderingAllowed(false);

        cvTreeTable.setRowHeight(cvTreeTable.getRowHeight() + 6);

        final ListSelectionModel listSelectionModel = cvTreeTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener() {

            @Override
            public void valueChanged(ListSelectionEvent e) {

                LOGGER.info("list selection, e: {}", e);
                if (e.getValueIsAdjusting()) {
                    return;
                }

                CvNode cvNode = null;

                final int index = cvTreeTable.getSelectedRow();
                DefaultExpandableRow row = (DefaultExpandableRow) cvTreeTable.getRowAt(index);

                LOGGER.info("Selection has changed, current index: {}, row: {}", index, row);

                // special handling for JideLongNodeNode
                if (row != null) {
                    if (row instanceof LongNodeNode) {
                        LongNodeNode longNodeNode = (LongNodeNode) row;
                        LongCvNode masterNode = longNodeNode.getSubCvMasterNode();
                        if (masterNode != null) {
                            LOGGER.info("Found masterNode to select: {}", masterNode);
                            cvNode = masterNode;

                            // expand the master node
                            SwingUtilities.invokeLater(new Runnable() {
                                @Override
                                public void run() {
                                    cvTreeTable.expandRow(index, true);
                                }
                            });
                        }
                    }
                    else if (row instanceof KeywordNodeNode) {

                        KeywordNodeNode keywordNodeNode = (KeywordNodeNode) row;
                        if (keywordNodeNode.getMasterNode() != null) {
                            cvNode = keywordNodeNode.getMasterNode();
                        }
                        else {
                            cvNode = (CvNode) row;
                        }
                    }
                    else if (row instanceof CvNode) {
                        cvNode = (CvNode) row;
                    }
                }

                if (cvNode != null) {
                    LOGGER.info("Show node in editor: {}", cvNode);

                    final DataType dataTypeName = cvNode.getCV().getType();
                    editorPanels.show(dataTypeName.name());

                    // clear all editors
                    List<CvValueEditor> editors = new ArrayList<>();
                    editors.addAll(mapDataTypeToEditor.values());

                    // the save button is disabled by default
                    saveButton.setEnabled(false);

                    CvValueEditor selectedEditor = null;
                    switch (dataTypeName) {
                        case INT:
                            selectedEditor = integerEditor;
                            break;
                        case BYTE:
                            selectedEditor = byteEditor;
                            break;
                        case BIT:
                            selectedEditor = bitfieldEditor;
                            break;
                        case SIGNED_CHAR:
                            selectedEditor = signedCharEditor;
                            break;
                        case DCC_ACC_ADDR:
                            selectedEditor = dccAccAddrEditor;
                            break;
                        case DCC_ADDR_RG:
                            selectedEditor = dccAddrRGEditor;
                            break;
                        case GBM_16_T_REVERSER:
                            selectedEditor = gbm16TReverserEditor;
                            break;
                        case RADIO:
                            selectedEditor = radioEditor;
                            break;
                        case LONG:
                            selectedEditor = longEditor;
                            break;
                        case DCC_LONG_ADDR:
                            selectedEditor = dccLongAddrEditor;
                            break;
                        case STRING:
                            selectedEditor = stringEditor;
                            break;
                        default:
                            break;
                    }

                    if (selectedEditor != null) {
                        PropertyConnector
                            .connect(selectedEditor.getSaveButtonEnabledModel(), "value", saveButton, "enabled");
                        selectedEditor.setValue(cvNode, cvNumberToNodeMap);

                        for (CvValueEditor editor : editors) {
                            if (editor.equals(selectedEditor)) {
                                LOGGER.info("Skip selected editor: {}", selectedEditor);
                                continue;
                            }

                            editor.setValue(null, cvNumberToNodeMap);
                        }

                    }
                    else {
                        LOGGER.warn("Non matching cvNode editor was selected: {}", dataTypeName);
                        editorPanels.show(NONE);
                        clearAllEditors();
                    }
                }
                else {
                    LOGGER.info("Non cvNode was selected.");
                    editorPanels.show(NONE);
                    clearAllEditors();
                }
            }
        });
        cvTreeTable.addMouseListener(new MouseAdapter() {
            @Override
            public void mouseReleased(MouseEvent e) {
                potentiallyShowPopup(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                potentiallyShowPopup(e);
            }
        });

        mainModel.addCvDefinitionListener(new CvDefinitionListener() {

            @Override
            public void cvDefinitionChanged() {
                LOGGER.info("The CV definition has changed.");
                // clear and release stored cv list
                if (configVariables != null) {
                    // configVariables.clear();
                    configVariables = null;
                }

                editorPanels.show(NONE);

                if (readButton != null) {
                    readButton.setEnabled(false);
                }
                if (writeButton != null) {
                    writeButton.setEnabled(false);
                }

                if (loadFromFileButton != null) {
                    loadFromFileButton.setEnabled(false);
                }

                if (saveToFileButton != null) {
                    saveToFileButton.setEnabled(false);
                }

                if (exportToExcelButton != null) {
                    exportToExcelButton.setEnabled(false);
                }

                // release not clear
                cvNumberToNodeMap = null;

                final NodeInterface node = mainModel.getSelectedNode();
                if (node == null) {
                    LOGGER.info("No node available.");
                    return;
                }

                if (node.getVendorCV() == null) {
                    LOGGER.info("No vendorCV data for node available.");
                    return;
                }

                CvDefinitionTreeTableModel cvDefinitionTreeTableModel =
                    cvDefinitionPanelController.getCvDefinitionTreeTableModel(node);
                treeModel = cvDefinitionTreeTableModel;

                if (treeModel != null) {

                    cvTreeTable.setModel(treeModel);

                    for (int columnIndex = 0; columnIndex < cvTreeTable.getColumnCount(); columnIndex++) {

                        TableColumn column = cvTreeTable.getColumnModel().getColumn(columnIndex);
                        int modelIndex = column.getModelIndex();
                        switch (modelIndex) {
                            case CvNode.COLUMN_NUMBER:
                                column.setPreferredWidth(20);
                                break;
                            case CvNode.COLUMN_DESCRIPTION:
                                column.setPreferredWidth(250);
                                break;
                            case CvNode.COLUMN_DEFAULT_VALUE:
                                column.setPreferredWidth(20);
                                break;
                            default:
                                break;
                        }
                    }

                    cvTreeTable.expandAll();
                }
                else {
                    LOGGER.warn("No CV definition tree model available.");
                    cvTreeTable.setModel(new CvDefinitionTreeTableModel());
                }

                // fetch the current map from the node
                cvNumberToNodeMap = cvDefinitionPanelController.getCvNumberToNodeMap(node);
                configVariables = node.getConfigVariables();

                // clear the xml-file info
                // textXmlFileName.setText(null);
                textVersion.setText(null);
                textLastUpdate.setText(null);
                textAuthor.setText(null);
                textDescription.setText(null);

                definitionFileValueBean.setFileName(null);
                definitionFileValueBean.setFilePath(null);

                // set the config variables in the main model
                // this triggers the CvDefinitionListener.cvDefinitionValuesChanged()
                SwingUtilities.invokeLater(() -> {
                    LOGGER.info("Get the configVariables from the node.");

                    // create the tree nodes based on the provided vendor configuration
                    if (node.getVendorCV() != null && node.getVendorCV().getVendorCV() != null) {
                        VendorCV vendorCV = node.getVendorCV().getVendorCV();
                        VersionInfoType versionInfoType = vendorCV.getVersion();
                        LOGGER.debug("versionInfoType: {}", versionInfoType);

                        String lastUpdate = versionInfoType.getLastupdate();
                        if (StringUtils.isNotBlank(lastUpdate)) {
                            try {
                                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                                Date lastUpdateDate = sdf.parse(lastUpdate);
                                lastUpdate = new SimpleDateFormat("dd.MM.yyyy").format(lastUpdateDate);
                            }
                            catch (ParseException ex) {
                                LOGGER.warn("Parse last update date failed.", ex);
                            }
                        }

                        String fileName = "?";
                        try {
                            fileName = node.getVendorCV().getFilename();
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Prepare XML filename failed.", ex);
                        }
                        String filePath = "?";
                        try {
                            filePath = node.getVendorCV().getFilePath();
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Prepare XML filePath failed.", ex);
                        }

                        textXmlFileName.setToolTipText(filePath);
                        textVersion.setText(versionInfoType.getVersion());
                        textLastUpdate.setText(lastUpdate);
                        textAuthor.setText(versionInfoType.getAuthor());
                        textDescription.setText(versionInfoType.getDescription());

                        definitionFileValueBean.setFileName(fileName);
                        definitionFileValueBean.setFilePath(filePath);

                        LOGGER.info("Number of configuration variables for this node: {}", configVariables.size());

                        if (readButton != null) {
                            // enable the read button to get the values of the configuration variables for this node
                            // on request
                            readButton.setEnabled(configVariables.size() > 0);
                        }
                        if (writeButton != null) {
                            // enable the write button to write the values of the configuration variables for this
                            // node on request
                            writeButton.setEnabled(configVariables.size() > 0);
                        }

                        if (loadFromFileButton != null) {
                            loadFromFileButton.setEnabled(configVariables.size() > 0);
                        }

                        if (saveToFileButton != null) {
                            saveToFileButton.setEnabled(configVariables.size() > 0);
                        }

                        if (exportToExcelButton != null) {
                            exportToExcelButton.setEnabled(configVariables.size() > 0);
                        }

                        if (copyToUserDirCvDefinitionButton != null) {
                            copyToUserDirCvDefinitionButton.setEnabled(true);
                        }

                        if (cvValidationModel != null) {
                            PropertyValidationSupport support =
                                new PropertyValidationI18NSupport(definitionFileValueBean, "validation");

                            if (definitionFileValueBean.isUserDefinedFile()) {

                                support
                                    .addWarning("xmlFileName_key",
                                        "filename_is_user_defined;" + definitionFileValueBean.filePath);

                                if (copyToUserDirCvDefinitionButton != null) {
                                    copyToUserDirCvDefinitionButton.setEnabled(false);
                                }
                            }
                            cvValidationModel.setResult(support.getResult());
                        }
                    }
                    else {
                        LOGGER.info("No vendor CV available.");
                    }
                });

            }

            @Override
            public void cvDefinitionValuesChanged(final boolean read, final List<String> changedNames) {
                LOGGER.info("The CV defintion values have changed, read: {}", read);

                // The new values are currently the same instances as we provided to fetch.
                // Thus the nodes have the new values already and only the tree refresh must be triggered.

                // refresh the tree with the new values
                // TreeTableNode root = treeModel.getRoot();
                // treeModel.refreshTreeTable(root);

                if (editorPanels.getCurrentPanel() instanceof CvValueEditor) {
                    // update the current values
                    CvValueEditor cvValueEditor = (CvValueEditor) editorPanels.getCurrentPanel();
                    cvValueEditor.refreshValueFromSource(cvNumberToNodeMap);
                }
            }
        });

        JSplitPane splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
        JScrollPane scrollTree = new JScrollPane(cvTreeTable);
        splitPane.add(scrollTree);

        JPanel westPanel = new JPanel(new BorderLayout());
        westPanel.add(createXmFileInfoPanel(), BorderLayout.NORTH);
        westPanel.add(createCvEditorPanel(mainModel), BorderLayout.CENTER);

        JScrollPane scrollCvEditors = new JScrollPane(westPanel);
        splitPane.add(scrollCvEditors);

        add(splitPane, BorderLayout.CENTER);

        splitPane.setDividerLocation(800);

        toolbarCvDefinition = new VLToolBar("cvDefinition");
        addButtons(toolbarCvDefinition);
        addToolBar(toolbarCvDefinition, new ToolBarConstraints(0, 2));
        // initially invisible
        toolbarCvDefinition.setVisible(false);
    }

    protected void clearAllEditors() {

        // clear all editors
        List<CvValueEditor> editors = new ArrayList<>();
        editors.addAll(mapDataTypeToEditor.values());
        for (CvValueEditor editor : editors) {

            editor.setValue(null, cvNumberToNodeMap);
        }
    }

    public void resetPendingChanges() {
        // reset the pending changes
        if (treeModel != null) {
            LOGGER.info("Reset pending changes on root node.");
            DefaultExpandableRow root = (DefaultExpandableRow) treeModel.getRoot();
            resetPendingChanges(root);
        }
    }

    @Override
    public JPanel getComponent() {
        return this;
    }

    @Override
    public Object getCreator() {
        return this;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof TabComponentCreator) {
            TabComponentCreator creator = (TabComponentCreator) other;
            // TODO if more than a single instance is available this must be changed
            if (creator.getCreator() instanceof CvDefinitionPanel) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    private void addToolBar(final VLToolBar toolBar, ToolBarConstraints constraints) {
        ToolBarPanel topToolBarPanel =
            (ToolBarPanel) DefaultApplicationContext.getInstance().get(DefaultApplicationContext.KEY_TOPTOOLBARPANEL);
        topToolBarPanel.add(toolBar, constraints);
    }

    private void removeToolBar(final VLToolBar toolBar) {
        ToolBarPanel topToolBarPanel =
            (ToolBarPanel) DefaultApplicationContext.getInstance().get(DefaultApplicationContext.KEY_TOPTOOLBARPANEL);
        topToolBarPanel.remove(toolBar);
    }

    protected ValidationResultModel cvValidationModel;

    private CvDefinitionFileValueBean definitionFileValueBean = new CvDefinitionFileValueBean();

    private ImageIcon userDefinedImportIcon;

    private JPanel createXmFileInfoPanel() {

        // create the 'detail panel'
        boolean formDebugPanel = false;
        FormBuilder builder =
            FormBuilder
                .create().columns("pref, 3dlu, min(30dlu;pref), 3dlu, pref, 3dlu, max(30dlu;pref), 3dlu, pref")
                .rows("p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p")
                .panel(formDebugPanel ? new FormDebugPanel() : new JPanel());

        builder.border(Paddings.DIALOG);

        // init the components

        ValueModel modeModel =
            new PropertyAdapter<CvDefinitionFileValueBean>(definitionFileValueBean,
                CvDefinitionFileValueBean.PROPERTYNAME_FILENAME, true);
        textXmlFileName = WizardComponentFactory.createTextField(modeModel, false);
        textXmlFileName.setColumns(20);
        textXmlFileName.setEditable(false);
        textVersion = new JTextField(7);
        textVersion.setEditable(false);
        textLastUpdate = new JTextField(20);
        textLastUpdate.setEditable(false);
        textAuthor = new JTextField(20);
        textAuthor.setEditable(false);
        textDescription = new JTextField(30);
        textDescription.setEditable(false);

        userDefinedImportIcon = ImageUtils.createImageIcon(CvDefinitionPanel.class, "/icons/16x16/user-defined.png");
        ImageIcon copyToUserDirIcon = ImageUtils.createImageIcon(CvDefinitionPanel.class, "/icons/16x16/copy.png");

        final JButton importCvDefinitionButton = new JButton(userDefinedImportIcon);
        importCvDefinitionButton.setToolTipText(Resources.getString(getClass(), "import.tooltip"));
        importCvDefinitionButton.addActionListener(evt -> {
            LOGGER.info("Import user-defined CV definition.");
            importUserDefinedCvDefinition();
        });

        copyToUserDirCvDefinitionButton = new JButton(copyToUserDirIcon);
        copyToUserDirCvDefinitionButton.setToolTipText(Resources.getString(getClass(), "copy-to-user-dir.tooltip"));
        copyToUserDirCvDefinitionButton.addActionListener(evt -> {
            LOGGER.info("Copy CV definition to user directory.");
            copyToUserDirCvDefinition();
        });

        builder.addSeparator(Resources.getString(getClass(), "fileinfo.title")).xyw(1, 1, 9);
        builder.add(Resources.getString(getClass(), "fileinfo.xmlfile")).xy(1, 3);
        builder.add(textXmlFileName).xyw(3, 3, 3);
        builder.add(importCvDefinitionButton).xy(7, 3);
        builder.add(copyToUserDirCvDefinitionButton).xy(9, 3);

        builder.add(Resources.getString(getClass(), "fileinfo.version")).xy(1, 5);
        builder.add(textVersion).xy(3, 5);
        builder.add(Resources.getString(getClass(), "fileinfo.lastchange")).xy(5, 5);
        builder.add(textLastUpdate).xyw(7, 5, 3);

        builder.add(Resources.getString(getClass(), "fileinfo.author")).xy(1, 7);
        builder.add(textAuthor).xyw(3, 7, 7);

        builder.add(Resources.getString(getClass(), "fileinfo.description")).xy(1, 9);
        builder.add(textDescription).xyw(3, 9, 7);

        // add icons that show if user-defined cv definition is used
        ValidationComponentUtils.setMandatory(textXmlFileName, true);
        ValidationComponentUtils.setMessageKey(textXmlFileName, "validation.xmlFileName_key");

        cvValidationModel = new DefaultValidationResultModel();

        PropertyValidationSupport support = new PropertyValidationI18NSupport(definitionFileValueBean, "validation");

        // support.addWarning("xmlFileName_key", "filename is user defined");
        cvValidationModel.setResult(support.getResult());

        // Padding for overlay icon
        JComponent cvIconPanel = new IconFeedbackPanel(this.cvValidationModel, builder.getPanel());

        FormBuilder feedbackBuilder = FormBuilder.create().columns("p:g").rows("p");
        feedbackBuilder.add(cvIconPanel).xy(1, 1);
        feedbackBuilder.border(new EmptyBorder(10, 0, 0, 0));

        return feedbackBuilder.getPanel();
    }

    private class EditorPanels extends JPanel {
        private static final long serialVersionUID = 1L;

        private Map<Object, Component> panels = new LinkedHashMap<Object, Component>();

        private String currentPanelName;

        public EditorPanels(CardLayout layout) {
            super(layout);
        }

        @Override
        public void add(Component comp, Object constraints) {
            LOGGER.debug("Add new panel to editor panels, name: {}, panel: {}", constraints, comp);
            panels.put(constraints, comp);
            if (currentPanelName == null) {
                currentPanelName = constraints.toString();
            }
            super.add(comp, constraints);
        }

        public void show(Object constraints) {
            LOGGER.debug("Show: {}", constraints);

            String newPanelName = constraints.toString();

            // detect if a panel is not available and show an empty panel in this case
            if (panels.containsKey(newPanelName)) {
                if (getLayout() instanceof CardLayout) {
                    ((CardLayout) getLayout()).show(this, constraints.toString());
                }
                currentPanelName = newPanelName;
            }
            else {
                LOGGER.warn("No panel available for constraint: {}", newPanelName);
                show(NONE);
            }
        }

        public JPanel getCurrentPanel() {
            if (currentPanelName != null) {
                return (JPanel) panels.get(currentPanelName);
            }
            return null;
        }
    }

    private JPanel createCvEditorPanel(MainModel mainModel) {
        JPanel editorContainer = new JPanel(new BorderLayout());
        editorContainer.setBorder(Paddings.DIALOG);
        editorContainer
            .add(
                DefaultComponentFactory
                    .getInstance().createSeparator(Resources.getString(getClass(), "editor.cveditor")),
                BorderLayout.NORTH);

        cardLayout = new CardLayout();

        saveButton = new JButton(Resources.getString(getClass(), "editor.save"));
        saveButton.setEnabled(false);
        saveButton.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                LOGGER.info("save pressed.");
                try {
                    Trigger trigger = getTrigger();
                    if (trigger == null) {
                        LOGGER.info("No trigger available. Do not save!");
                        return;
                    }
                    trigger.triggerCommit();

                    JPanel panel = editorPanels.getCurrentPanel();
                    if (panel instanceof CvValueEditor) {
                        CvValueEditor valueEditor = (CvValueEditor) panel;

                        CvNode cvNode = valueEditor.getCvNode();
                        LOGGER.debug("Current selected cvNode: {}", cvNode);
                        if (cvNode != null) {
                            // let the editor update the CV value(s) ...
                            valueEditor.updateCvValues(cvNumberToNodeMap, treeModel);

                            LOGGER.info("Refresh the treeModel.");

                            cvTreeTable.updateUI();

                            LOGGER.info("Refresh the treeModel finished.");

                            // hook in here and set the pending changes flag on the tab
                            if (CvDefinitionTreeHelper.hasPendingChanges(treeModel)) {
                                tabStatusListener.updatePendingChanges(CvDefinitionPanel.this, true);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    LOGGER.warn("Commit failed.", ex);
                }
            }
        });
        JButton resetButton = new JButton(Resources.getString(getClass(), "editor.reset"));
        resetButton.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                LOGGER.info("Reset was pressed.");
                Trigger trigger = getTrigger();
                if (trigger != null) {
                    trigger.triggerFlush();

                    // call 2x
                    trigger.triggerFlush();
                }
            }
        });
        // create the button panel
        JPanel buttonBar = new ButtonBarBuilder().addButton(saveButton, resetButton).build();
        editorContainer.add(buttonBar, BorderLayout.NORTH);

        // show the editor panels below the save and reset button
        editorPanels = new EditorPanels(cardLayout);
        editorContainer.add(editorPanels, BorderLayout.CENTER);

        // add the editor panels ...
        editorPanels.add(new JPanel(), NONE);
        editorPanels.add(createBitfieldEditor(), DataType.BIT.name());
        editorPanels.add(createByteEditor(), DataType.BYTE.name());
        editorPanels.add(createIntegerEditor(), DataType.INT.name());
        editorPanels.add(createSignedCharEditor(), DataType.SIGNED_CHAR.name());
        editorPanels.add(createRadioEditor(), DataType.RADIO.name());
        editorPanels.add(createLongEditor(), DataType.LONG.name());
        editorPanels.add(createDccLongAddrEditor(), DataType.DCC_LONG_ADDR.name());
        editorPanels.add(createStringEditor(), DataType.STRING.name());

        // add specific editor panels ...
        editorPanels.add(createDccAccAddrEditor(), DataType.DCC_ACC_ADDR.name());
        editorPanels.add(createDccAddrRGEditor(), DataType.DCC_ADDR_RG.name());
        editorPanels.add(createGBM16TReverserEditor(), DataType.GBM_16_T_REVERSER.name());

        return editorContainer;
    }

    private Trigger getTrigger() {
        JPanel currentEditor = editorPanels.getCurrentPanel();
        if (currentEditor instanceof CvValueEditor) {
            return ((CvValueEditor) currentEditor).getTrigger();
        }
        return null;
    }

    private GBM16TReverserEditor gbm16TReverserEditor;

    private GBM16TReverserEditor createGBM16TReverserEditor() {
        gbm16TReverserEditor =
            new GBM16TReverserEditor(this.feedbackPortStatusChangeProvider, new Trigger(), null,
                "/icons/GBM16TReverser.png");

        mapDataTypeToEditor.put(DataType.GBM_16_T_REVERSER, gbm16TReverserEditor);
        return gbm16TReverserEditor;
    }

    private DccAccAddrEditor dccAccAddrEditor;

    private JPanel createDccAccAddrEditor() {
        dccAccAddrEditor = new DccAccAddrEditor();
        dccAccAddrEditor.create(new Trigger());

        mapDataTypeToEditor.put(DataType.DCC_ACC_ADDR, dccAccAddrEditor);
        return dccAccAddrEditor;
    }

    private DccAddrRGEditor dccAddrRGEditor;

    private JPanel createDccAddrRGEditor() {
        dccAddrRGEditor = new DccAddrRGEditor();
        dccAddrRGEditor.create(new Trigger());

        mapDataTypeToEditor.put(DataType.DCC_ADDR_RG, dccAddrRGEditor);
        return dccAddrRGEditor;
    }

    private CvValueNumberEditor<Byte> byteEditor;

    private JPanel createByteEditor() {
        byteEditor = new CvByteValueEditor();
        byteEditor.setValueLabelPrefix("Byte");
        byteEditor.create(new Trigger());

        mapDataTypeToEditor.put(DataType.BYTE, byteEditor);
        return byteEditor;
    }

    private CvValueNumberEditor<Byte> bitfieldEditor;

    private JPanel createBitfieldEditor() {
        bitfieldEditor = new CvBitfieldValueEditor();
        bitfieldEditor.create(new Trigger());

        mapDataTypeToEditor.put(DataType.BIT, bitfieldEditor);
        return bitfieldEditor;
    }

    private CvValueNumberEditor<Byte> radioEditor;

    private JPanel createRadioEditor() {
        radioEditor = new CvRadioValueEditor();
        radioEditor.create(new Trigger());

        mapDataTypeToEditor.put(DataType.RADIO, radioEditor);
        return radioEditor;
    }

    private CvValueNumberEditor<Integer> integerEditor;

    private JPanel createIntegerEditor() {
        integerEditor = new CvIntegerValueEditor();
        integerEditor.setValueLabelPrefix("Integer");
        integerEditor.create(new Trigger());

        mapDataTypeToEditor.put(DataType.INT, integerEditor);
        return integerEditor;
    }

    private CvValueNumberEditor<Long> longEditor;

    private JPanel createLongEditor() {
        longEditor = new CvLongValueEditor();
        longEditor.setValueLabelPrefix("Long");
        longEditor.create(new Trigger());

        mapDataTypeToEditor.put(DataType.LONG, longEditor);
        return longEditor;
    }

    private CvValueNumberEditor<Integer> dccLongAddrEditor;

    private JPanel createDccLongAddrEditor() {
        dccLongAddrEditor = new CvDccLongAddrValueEditor();
        dccLongAddrEditor.setValueLabelPrefix("DccLongAddr");
        dccLongAddrEditor.create(new Trigger());

        mapDataTypeToEditor.put(DataType.DCC_LONG_ADDR, dccLongAddrEditor);
        return dccLongAddrEditor;
    }

    private CvSignedCharValueEditor signedCharEditor;

    private JPanel createSignedCharEditor() {
        signedCharEditor = new CvSignedCharValueEditor();
        signedCharEditor.setValueLabelPrefix("Signed Char");
        signedCharEditor.create(new Trigger());

        mapDataTypeToEditor.put(DataType.SIGNED_CHAR, signedCharEditor);
        return signedCharEditor;
    }

    private CvValueStringEditor stringEditor;

    private JPanel createStringEditor() {
        stringEditor = new CvValueStringEditor();
        stringEditor.setValueLabelPrefix("String");
        stringEditor.create(new Trigger());

        mapDataTypeToEditor.put(DataType.STRING, stringEditor);
        return stringEditor;
    }

    @Override
    public String getName() {
        return Resources.getString(getClass(), "name");
    }

    private void readCvValues() {
        LOGGER.debug("Read all configured CV values.");

        List<ConfigurationVariable> configVars = new LinkedList<>();
        configVars.addAll(configVariables.values());

        // Get all configured CV values from the node
        readCvValues(configVars);
    }

    private void readCvValues(List<ConfigurationVariable> configVariables) {
        LOGGER.debug("Read the CV values.");

        // Get the CV values from the node
        if (configVariables != null && configVariables.size() > 0) {
            LOGGER.info("Get the CV values for configuration variables, count: {}", configVariables.size());

            fireLoadConfigVariables(configVariables);
        }
        else {
            LOGGER.warn("No configuration variables available.");
        }
    }

    @Override
    public void checkPendingChanges() {
        boolean hasPendingChanges = CvDefinitionTreeHelper.hasPendingChanges(treeModel);
        if (!hasPendingChanges) {
            tabStatusListener.updatePendingChanges(this, false);
        }
    }

    private void resetPendingChanges(DefaultExpandableRow node) {
        if (node == null) {
            return;
        }
        for (int childIndex = 0; childIndex < node.getChildrenCount(); childIndex++) {
            DefaultExpandableRow child = (DefaultExpandableRow) node.getChildAt(childIndex);
            if (child instanceof CvNode) {
                CvNode cvNode = (CvNode) child;
                if (cvNode.getNewValue() != null) {
                    LOGGER.debug("Reset the pending changes on node: {}", cvNode);
                    cvNode.resetNewValue();
                }
            }
            else {
                resetPendingChanges(child);
            }
        }
    }

    /**
     * Add a new {@link ConfigurationVariable} item to the list if the new value is available.
     * 
     * @param cvNode
     *            the cvNode
     * @param cvList
     *            the list
     */
    private void addNewValueToList(CvNode cvNode, List<ConfigurationVariable> cvList) {
        if (cvNode.getNewValue() != null) {
            // we have a new value to write to the node.
            String cvNumber = cvNode.getConfigVar().getName();
            String cvValue = Objects.toString(cvNode.getNewValue(), null);

            ConfigurationVariable cv = new ConfigurationVariable(cvNumber, cvValue);
            cvList.add(cv);
        }
    }

    private void addButtons(VLToolBar toolBar) {

        // read button
        readButton =
            ButtonUtils
                .makeNavigationButton("loadfromnode.png", "/32x32", READ,
                    Resources.getString(getClass(), "toolbar.readallcv"),
                    Resources.getString(getClass(), "toolbar.readallcv.alttext"));
        readButton.setEnabled(false);
        toolBar.add(readButton);

        readButton.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                readCvValues();
            }
        });

        // write button
        writeButton =
            ButtonUtils
                .makeNavigationButton("savetonode.png", "/32x32", WRITE,
                    Resources.getString(getClass(), "toolbar.writeallcv"),
                    Resources.getString(getClass(), "toolbar.writeallcv.alttext"));
        toolBar.add(writeButton);
        writeButton.setEnabled(false);

        writeButton.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                LOGGER.info("Write the CV values.");

                // collect the new values from the tree
                DefaultExpandableRow root = (DefaultExpandableRow) treeModel.getRoot();

                final NodeInterface selectedNode = mainModel.getSelectedNode();

                // write the values to the node
                CvValueUtils.writeCvValues(selectedNode, root, cvNumberToNodeMap, CvDefinitionPanel.this);
            }
        });

        // load button
        loadFromFileButton =
            ButtonUtils
                .makeNavigationButton("loadfromfile.png", "/32x32", LOAD,
                    Resources.getString(getClass(), "toolbar.loadfromfile"),
                    Resources.getString(getClass(), "toolbar.loadfromfile.alttext"));
        toolBar.add(loadFromFileButton);
        loadFromFileButton.setEnabled(false);

        loadFromFileButton.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                loadFromFileCvValues();
            }
        });
        // save button
        saveToFileButton =
            ButtonUtils
                .makeNavigationButton("savetofile.png", "/32x32", SAVE.toLowerCase(),
                    Resources.getString(getClass(), "toolbar.savetofile"),
                    Resources.getString(getClass(), "toolbar.savetofile.alttext"));
        toolBar.add(saveToFileButton);
        saveToFileButton.setEnabled(false);

        saveToFileButton.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                saveToFileCvValues();
            }
        });

        // export to excel button
        exportToExcelButton =
            ButtonUtils
                .makeNavigationButton("exportToExcel.png", "/32x32", SAVE.toLowerCase(),
                    Resources.getString(getClass(), "toolbar.exportToExcel"),
                    Resources.getString(getClass(), "toolbar.exportToExcel.alttext"));
        toolBar.add(exportToExcelButton);
        exportToExcelButton.setEnabled(false);

        exportToExcelButton.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                exportCvDatatoExcel();
            }
        });
    }

    @Override
    public void addCvDefinitionRequestListener(CvDefinitionRequestListener l) {
        cvDefinitionRequestListeners.add(l);
    }

    private void fireLoadConfigVariables(List<ConfigurationVariable> configVariables) {
        // TODO decouple the AWT-thread from this work?

        for (CvDefinitionRequestListener l : cvDefinitionRequestListeners) {
            l.loadCvValues(configVariables);
        }
    }

    @Override
    public void writeConfigVariables(List<ConfigurationVariable> cvList) {
        fireWriteConfigVariables(cvList);
    }

    private void fireWriteConfigVariables(List<ConfigurationVariable> cvList) {
        // TODO decouple the AWT-thread from this work?

        for (CvDefinitionRequestListener l : cvDefinitionRequestListeners) {
            l.writeCvValues(cvList);
        }
    }

    private void potentiallyShowPopup(MouseEvent e) {
        JPopupMenu popupMenu = null;

        if (e.isPopupTrigger()) {
            int index = cvTreeTable.getSelectedRow();
            if (index > -1) {

                DefaultExpandableRow row = (DefaultExpandableRow) cvTreeTable.getRowAt(index);

                popupMenu = buildPopup(row);

                // Only show popup if we have any menu items in it
                if (popupMenu.getComponentCount() > 0) {
                    popupMenu.show((Component) e.getSource(), e.getX(), e.getY());
                }

            }
        }
    }

    private JPopupMenu buildPopup(final DefaultExpandableRow selectedComponent) {
        JPopupMenu pm = new JPopupMenu();
        // Based on selection context, install actions...
        if (selectedComponent instanceof CvNode) {
            CvNode cvNode = (CvNode) selectedComponent;
            JMenuItem readCv =
                new JMenuItem(new CvAction(ActionType.READ, Resources.getString(getClass(), "menu.readcv"), cvNode));
            pm.add(readCv);
            if (!ModeType.RO.equals(cvNode.getCV().getMode()) && !ModeType.H.equals(cvNode.getCV().getMode())) {
                JMenuItem writeCv =
                    new JMenuItem(
                        new CvAction(ActionType.WRITE, Resources.getString(getClass(), "menu.writecv"), cvNode));
                pm.add(writeCv);
            }
        }
        else if (selectedComponent instanceof NodeNode) {
            NodeNode nodeNode = (NodeNode) selectedComponent;
            JMenuItem readCv =
                new JMenuItem(
                    new NodeCvAction(ActionType.READ, Resources.getString(getClass(), "menu.readcvs"), nodeNode));
            pm.add(readCv);

            JMenuItem writeCv =
                new JMenuItem(
                    new NodeCvAction(ActionType.WRITE, Resources.getString(getClass(), "menu.writecvs"), nodeNode));
            pm.add(writeCv);
        }
        else if (selectedComponent instanceof DeviceNode) {
            DeviceNode deviceNode = (DeviceNode) selectedComponent;
            JMenuItem readCv =
                new JMenuItem(
                    new NodeCvAction(ActionType.READ, Resources.getString(getClass(), "menu.readcvs"), deviceNode));
            pm.add(readCv);

            JMenuItem writeCv =
                new JMenuItem(
                    new NodeCvAction(ActionType.WRITE, Resources.getString(getClass(), "menu.writecvs"), deviceNode));
            pm.add(writeCv);
        }

        return pm;
    }

    public enum ActionType {
        READ, WRITE
    };

    private class CvAction extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private CvNode cvNode;

        private ActionType actionType;

        public CvAction(ActionType actionType, String name, CvNode cvNode) {
            super(name);
            this.actionType = actionType;
            this.cvNode = cvNode;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LOGGER.debug("Add config var of selected cvNode: {}", cvNode);

            List<CvNode> cvNodes = new LinkedList<>();
            CVType cv = cvNode.getCV();
            switch (cv.getType()) {
                case INT:
                    CvNode highCvNode = cvNumberToNodeMap.get(cvNode.getCV().getHigh());
                    CvNode lowCvNode = cvNumberToNodeMap.get(cvNode.getCV().getLow());
                    cvNodes.add(highCvNode);
                    cvNodes.add(lowCvNode);
                    break;
                case LONG:
                    if (cvNode instanceof LongCvNode) {
                        LongCvNode masterCvNode = ((LongCvNode) cvNode).getMasterNode();
                        cvNodes.add(masterCvNode);
                        for (CvNode slaveNode : masterCvNode.getSlaveNodes()) {
                            cvNodes.add(slaveNode);
                        }
                    }
                    break;
                default:
                    cvNodes.add(cvNode);
                    break;
            }

            LOGGER.debug("Nodes to update: {}", cvNodes);

            switch (actionType) {
                case READ:
                    List<ConfigurationVariable> cvSet = new LinkedList<ConfigurationVariable>();
                    for (CvNode node : cvNodes) {
                        cvSet.add(node.getConfigVar());
                    }
                    readCvValues(cvSet);
                    break;
                case WRITE:
                    List<ConfigurationVariable> cvList = new LinkedList<ConfigurationVariable>();
                    for (CvNode node : cvNodes) {
                        if (!ModeType.RO.equals(node.getCV().getMode()) && !ModeType.H.equals(node.getCV().getMode())) {
                            addNewValueToList(node, cvList);
                        }
                    }
                    final NodeInterface selectedNode = mainModel.getSelectedNode();
                    CvValueUtils.writeCvValues(selectedNode, cvList, cvNumberToNodeMap, CvDefinitionPanel.this);

                    break;
                default:
                    break;
            }
        }
    }

    private class NodeCvAction extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private final AbstractNode nodeNode;

        private ActionType actionType;

        public NodeCvAction(ActionType actionType, String name, final AbstractNode nodeNode) {
            super(name);
            this.actionType = actionType;
            this.nodeNode = nodeNode;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LOGGER.debug("Add config var of selected cvNode: {}", nodeNode);

            List<CvNode> cvNodes = new LinkedList<CvNode>();
            CvDefinitionTreeHelper.addCvOfSubnode(nodeNode, cvNodes, cvNumberToNodeMap);

            LOGGER.debug("Nodes to update: {}", cvNodes);

            switch (actionType) {
                case READ:
                    List<ConfigurationVariable> cvSet = new LinkedList<ConfigurationVariable>();
                    for (CvNode node : cvNodes) {
                        cvSet.add(node.getConfigVar());
                    }
                    readCvValues(cvSet);
                    break;
                case WRITE:
                    List<ConfigurationVariable> cvList = new LinkedList<ConfigurationVariable>();
                    for (CvNode node : cvNodes) {
                        if (!ModeType.RO.equals(node.getCV().getMode()) && !ModeType.H.equals(node.getCV().getMode())) {
                            addNewValueToList(node, cvList);
                        }
                    }

                    final NodeInterface selectedNode = mainModel.getSelectedNode();
                    CvValueUtils.writeCvValues(selectedNode, cvList, cvNumberToNodeMap, CvDefinitionPanel.this);

                    break;
                default:
                    break;
            }

        }
    }

    private static FileFilter cvExchangeFilter;

    private static final String CV_EXCHANGE_EXTENSION = "xml";

    private static final String WORKING_DIR_CV_DEFINITION_KEY = "cvDefinition";

    private void loadFromFileCvValues() {
        String savedCvDescription = Resources.getString(CvDefinitionPanel.class, "savedCvDescription");
        cvExchangeFilter = new FileNameExtensionFilter(savedCvDescription, CV_EXCHANGE_EXTENSION);

        final WizardSettingsInterface wizardSettings = settingsService.getWizardSettings();
        String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_CV_DEFINITION_KEY);

        FileDialog dialog =
            new FileDialog(cvTreeTable, FileDialog.OPEN, storedWorkingDirectory, null, cvExchangeFilter) {

                @Override
                public void approve(final String fileName) {
                    try {
                        // setWaitCursor();
                        LOGGER.info("Start importing saved CV, fileName: {}", fileName);

                        SaveCV saveCV = CvExchangeFactory.loadCV(fileName);
                        LOGGER.info("Loaded saveCV from file: {}", fileName);

                        if (saveCV != null && saveCV.getCVs() != null) {
                            List<CVSType> cvList = saveCV.getCVs().getCv();
                            if (CollectionUtils.isNotEmpty(cvList)) {
                                for (CVSType cvsType : cvList) {

                                    String cvNumber = cvsType.getNumber();
                                    String cvValue = cvsType.getValue();

                                    setCV(cvNumber, cvValue);
                                }

                            }
                        }

                        final String workingDir = Paths.get(fileName).getParent().toString();
                        LOGGER.info("Save current workingDir: {}", workingDir);

                        wizardSettings.setWorkingDirectory(WORKING_DIR_CV_DEFINITION_KEY, workingDir);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Load saved CV failed.", ex);

                        throw new RuntimeException("Load saved CV failed.");
                    }
                    finally {
                        // setDefaultCursor();
                    }

                    // treeModel.refreshTreeTable(treeModel.getRoot());
                }
            };
        dialog.showDialog();
    }

    private void setCV(final String cvNumber, final String cvValue) {

        if ("---".equals(cvValue)) {
            LOGGER.debug("Skip invalid value.");
            return;
        }

        // final String cvNum = Integer.toString(cvNumber);
        ConfigurationVariable cv = IterableUtils.find(configVariables.values(), new Predicate<ConfigurationVariable>() {

            @Override
            public boolean evaluate(ConfigurationVariable cv) {
                if (cv.getName().equals(cvNumber)) {
                    return true;
                }
                return false;
            }
        });

        if (cv != null) {
            cv.setValue(cvValue);
        }
        else {
            LOGGER.warn("No CV found to update with cvNumber: {}, cvValue: {}", cvNumber, cvValue);
        }

    }

    private void saveToFileCvValues() {

        String saveCvDescription = Resources.getString(CvDefinitionPanel.class, "saveCvDescription");
        cvExchangeFilter = new FileNameExtensionFilter(saveCvDescription, CV_EXCHANGE_EXTENSION);

        final WizardSettingsInterface wizardSettings = settingsService.getWizardSettings();
        String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_CV_DEFINITION_KEY);

        FileDialog dialog =
            new FileDialog(cvTreeTable, FileDialog.SAVE, storedWorkingDirectory, null, cvExchangeFilter) {

                @Override
                public void approve(final String fileName) {
                    try {
                        String selectedFile = fileName;
                        if (!StringUtils.endsWith(fileName.toLowerCase(), ".xml")) {
                            selectedFile = fileName + ".xml";
                        }

                        // setWaitCursor();
                        LOGGER.info("Start save CV, fileName: {}", fileName);

                        SaveCV saveCV = new SaveCV();
                        saveCV
                            .setMasterData(new MasterDataType()
                                .withUID(ByteUtils.formatHexUniqueId(mainModel.getSelectedNode().getUniqueId())));

                        CVListType cvListType = new CVListType();
                        saveCV.setCVs(cvListType);

                        List<ConfigurationVariable> cvList = new LinkedList<>();
                        cvList.addAll(configVariables.values());

                        ConfigurationVariable.sortCvVariables(cvList);

                        for (ConfigurationVariable cv : cvList) {

                            CVSType cvsType = new CVSType().withNumber(cv.getName()).withValue(cv.getValue());
                            cvListType.getCv().add(cvsType);
                        }

                        CvExchangeFactory.saveCV(saveCV, new File(selectedFile));
                        LOGGER.info("Saved CV values to file: {}", selectedFile);

                        final String workingDir = Paths.get(selectedFile).getParent().toString();
                        LOGGER.info("Save current workingDir: {}", workingDir);

                        wizardSettings.setWorkingDirectory(WORKING_DIR_CV_DEFINITION_KEY, workingDir);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Save CV values to file failed.", ex);

                        throw new RuntimeException("Save CV values to file failed.");
                    }
                    finally {
                        // setDefaultCursor();
                    }

                    // treeModel.refreshTreeTable(treeModel.getRoot());
                }
            };
        dialog.showDialog();

    }

    private void exportCvDatatoExcel() {
        String saveCvDescription = Resources.getString(CvDefinitionPanel.class, "saveCvDescription");
        cvExchangeFilter =
            new FileNameExtensionFilter(saveCvDescription, org.bidib.wizard.utils.FileUtils.EXCEL_EXTENSION);

        final WizardSettingsInterface wizardSettings = settingsService.getWizardSettings();
        String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_CV_DEFINITION_KEY);

        FileDialog dialog =
            new FileDialog(cvTreeTable, FileDialog.SAVE, storedWorkingDirectory, null, cvExchangeFilter) {

                @Override
                public void approve(final String fileName) {
                    try {
                        // setWaitCursor();

                        String selectedFile = fileName;
                        if (!fileName.toLowerCase().endsWith("." + org.bidib.wizard.utils.FileUtils.EXCEL_EXTENSION)) {
                            selectedFile += "." + org.bidib.wizard.utils.FileUtils.EXCEL_EXTENSION;
                        }
                        LOGGER.info("Start save CV, fileName: {}", selectedFile);

                        CvDefinitionTreeTableModel cvDefinitionTreeTableModel = treeModel;

                        final List<CvData> configurationVariables = new LinkedList<>();

                        for (DefaultExpandableRow row : cvDefinitionTreeTableModel.getRows()) {

                            if (row instanceof CvNode) {
                                LOGGER.info("Current row is CvNode: {}", row);
                                CvNode cvNode = (CvNode) row;

                                String description = (String) cvNode.getValueAt(CvNode.COLUMN_DESCRIPTION);
                                LOGGER.info("Current CV: {}", description);

                                CvData cvData = new CvData();
                                cvData.setCvDescription(description);
                                cvData
                                    .setCvDefaultValue(cvNode.getValueAt(CvNode.COLUMN_DEFAULT_VALUE) != null
                                        ? cvNode.getValueAt(CvNode.COLUMN_DEFAULT_VALUE).toString() : null);
                                cvData.setCvName((String) cvNode.getValueAt(CvNode.COLUMN_NUMBER));
                                cvData.setCvValue((String) cvNode.getValueAt(CvNode.COLUMN_VALUE));

                                configurationVariables.add(cvData);
                            }
                            else if (row instanceof DeviceNode) {
                                LOGGER.info("Current row is DeviceNode: {}", row);
                                DeviceNode cvNode = (DeviceNode) row;

                            }
                            else if (row instanceof NodeNode) {
                                LOGGER.info("Current row is NodeNode: {}", row);
                                NodeNode cvNode = (NodeNode) row;

                            }
                        }

                        String lang = XmlLocaleUtils.getXmlLocaleVendorCV();
                        org.bidib.jbidibc.messages.Node coreNode = mainModel.getSelectedNode().getNode();
                        org.bidib.jbidibc.core.schema.bidib2.Node schemaNode =
                            new org.bidib.jbidibc.core.schema.bidib2.Node();
                        schemaNode
                            .withUserName(coreNode.getStoredString(StringData.INDEX_USERNAME))
                            .withProductName(coreNode.getStoredString(StringData.INDEX_PRODUCTNAME))
                            .withManufacturerId(
                                org.bidib.jbidibc.messages.utils.NodeUtils.getVendorId(coreNode.getUniqueId()))
                            .withProductId(org.bidib.jbidibc.messages.utils.NodeUtils
                                .getPid(coreNode.getUniqueId(), coreNode.getRelevantPidBits()))
                            .withUniqueId(coreNode.getUniqueId())
                            .withFirmwareRelease(coreNode.getSoftwareVersion().toString())
                            .withProtocol(coreNode.getProtocolVersion().toString());

                        ExcelExportFactory
                            .exportConfigurationVariables(schemaNode, configurationVariables, selectedFile, lang);
                        LOGGER.info("Exported CV values to file: {}", selectedFile);

                        final String workingDir = Paths.get(fileName).getParent().toString();
                        LOGGER.info("Save current workingDir: {}", workingDir);

                        wizardSettings.setWorkingDirectory(WORKING_DIR_CV_DEFINITION_KEY, workingDir);

                        JOptionPane
                            .showMessageDialog(JOptionPane.getFrameForComponent(null),
                                Resources.getString(CvDefinitionPanel.class, "exportToExcel.passed", selectedFile),
                                Resources.getString(CvDefinitionPanel.class, "exportToExcel.title"),
                                JOptionPane.INFORMATION_MESSAGE);

                    }
                    catch (Exception ex) {
                        LOGGER.warn("Export CV values to file failed.", ex);

                        throw new RuntimeException("Export CV values to file failed.");
                    }
                    finally {
                        // setDefaultCursor();
                    }

                    // treeModel.refreshTreeTable(treeModel.getRoot());
                }
            };
        dialog.showDialog();
    }

    @Override
    public void tabSelected(boolean selected) {
        LOGGER.info("Tab is selected: {}", selected);

        toolbarCvDefinition.setVisible(selected);
    }

    private void importUserDefinedCvDefinition() {

        final FileFilter ff = new XmlFileFilter();

        final WizardSettingsInterface wizardSettings = settingsService.getWizardSettings();
        String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_CV_DEFINITION_KEY);

        final Component parentComponent = this;
        FileDialog dialog = new FileDialog(parentComponent, FileDialog.OPEN, storedWorkingDirectory, null, ff) {
            @Override
            public void approve(final String fileName) {
                File file = new File(fileName);

                String selectedFile = file.getName();
                LOGGER.info("Selected file to import: {}", selectedFile);

                // check if the content of the file is valid
                VendorCvFactory.isVendorCvFileValid(file);

                String labelPath = settingsService.getMiscSettings().getBidibConfigDir();

                StringBuilder sb = new StringBuilder(labelPath);
                sb.append("/data/BiDiBNodeVendorData/");

                // rename the file to the convention
                final NodeInterface node = mainModel.getSelectedNode();
                long uniqueId = node.getUniqueId();
                final SoftwareVersion softwareVersion = node.getNode().getSoftwareVersion();
                StringBuilder targetFilename = new StringBuilder("BiDiBCV-");
                targetFilename
                    .append(NodeUtils.getVendorId(uniqueId)).append("-").append(NodeUtils.getPid(uniqueId)).append("-")
                    .append(softwareVersion.toString()).append(".xml");

                LOGGER.info("Store file at path: {}, targetFile: {}", sb.toString(), targetFilename.toString());

                File target = new File(sb.toString(), targetFilename.toString());

                try {
                    if (target.exists()) {
                        LOGGER.info("Delete existing file: {}", target);
                        FileUtils.deleteQuietly(target);

                    }

                    LOGGER.info("Copy the CV file to target: {}", target);
                    FileUtils.copyFile(file, target, false);

                    LOGGER.info("Copy the CV file to target passed.");

                    // TODO add dialog that shows the result

                    StopWatch sw = new StopWatch();
                    sw.start();

                    final Context context = new DefaultContext();
                    cvDefinitionPanelController.reloadCvDefinition(context, node);

                    sw.stop();

                    final List<VendorCvError> vendorCVErrors =
                        context.get(VendorCvFactory.VENDORCV_ERRORS, List.class, Collections.emptyList());

                    StatusBar statusBar =
                        DefaultApplicationContext
                            .getInstance().get(DefaultApplicationContext.KEY_STATUS_BAR, StatusBar.class);

                    if (CollectionUtils.isNotEmpty(vendorCVErrors)) {
                        LOGGER.warn("Load vendor CV data from files failed: {}", vendorCVErrors);
                        statusBar
                            .setStatusText(String
                                .format(
                                    Resources
                                        .getString(MainController.class, "load-config-finished-load-vendorcv-failed"),
                                    node, sw),
                                StatusBar.DISPLAY_ERROR);
                    }
                    else {
                        statusBar
                            .setStatusText(String
                                .format(Resources.getString(MainController.class, "load-config-finished-no-vendorcv"),
                                    node, sw),
                                StatusBar.DISPLAY_NORMAL);
                    }

                    final String workingDir = Paths.get(fileName).getParent().toString();
                    LOGGER.info("Save current workingDir: {}", workingDir);

                    wizardSettings.setWorkingDirectory(WORKING_DIR_CV_DEFINITION_KEY, workingDir);
                }
                catch (IOException ex) {
                    LOGGER.warn("Copy file failed.", ex);

                    throw new RuntimeException("Copy file failed.");
                }

            }

            @Override
            protected boolean handleException(RuntimeException ex) {

                JOptionPane
                    .showMessageDialog(JOptionPane.getFrameForComponent(parentComponent),
                        Resources.getString(CvDefinitionPanel.class, "import-to-user-dir.failed"),
                        Resources.getString(CvDefinitionPanel.class, "import-to-user-dir.title"),
                        JOptionPane.ERROR_MESSAGE);

                return true;
            }
        };
        dialog.showDialog();
    }

    private void copyToUserDirCvDefinition() {

        int result =
            JOptionPane
                .showConfirmDialog(this, Resources.getString(getClass(), "copy-to-user-dir.message"),
                    Resources.getString(getClass(), "copy-to-user-dir.title"), JOptionPane.OK_CANCEL_OPTION,
                    JOptionPane.QUESTION_MESSAGE);

        if (result == JOptionPane.OK_OPTION) {
            LOGGER.info("Copy cv definition to user dir.");

            final NodeInterface node = mainModel.getSelectedNode();
            final Context context = new DefaultContext();
            try {
                this.cvDefinitionPanelController.copyCvDefinitionToUserDir(context, node);
                LOGGER.info("Copy finished, reload the CV definition.");
                cvDefinitionPanelController.reloadCvDefinition(context, node);
            }
            catch (Exception ex) {

                LOGGER.warn("Copy CV definition to user dir failed.");
                JOptionPane
                    .showMessageDialog(this, Resources.getString(CvDefinitionPanel.class, "copy-to-user-dir.failed"),
                        Resources.getString(CvDefinitionPanel.class, "copy-to-user-dir.title"),
                        JOptionPane.INFORMATION_MESSAGE);
            }
        }
        else {
            LOGGER.info("User canceled copy cv definition to user dir.");
        }
    }

    @Override
    public PortListener<FeedbackPort> getPortListener() {
        return this.gbm16TReverserEditor.getPortListener();
    }

    public static final String PATTERN_CV_FILENAME = "^BiDiBCV-([0-9]{1,3})-.+\\.xml$";

    private final class XmlFileFilter extends FileFilter {

        public static final String SUFFIX_XML = "xml";

        @Override
        public boolean accept(File file) {
            boolean result = false;

            if (file != null) {
                if (file.isDirectory()) {
                    result = true;
                }
                else if (file.toString() != null) {
                    String extension = FilenameUtils.getExtension(file.toString());
                    if (SUFFIX_XML.equalsIgnoreCase(extension)) {

                        // check if the pattern matches
                        Matcher m = Pattern.compile(PATTERN_CV_FILENAME).matcher(file.getName());
                        if (m.matches()) {
                            LOGGER.info("The pattern matches!");

                            result = true;
                        }
                    }
                }
            }
            return result;
        }

        @Override
        public String getDescription() {
            return Resources.getString(CvDefinitionPanel.class, "filter") + " (*." + SUFFIX_XML + ")";
        }
    }

    @Override
    public void listChanged() {

    }

    @Override
    public void nodeWillChange(NodeInterface node) {
        boolean pendingChanges = CvDefinitionTreeHelper.hasPendingChanges(treeModel);

        if (pendingChanges) {
            throw new NodeChangeVetoException("Pending changes in CV definition detected.");
        }

    }

    @Override
    public void nodeChanged(NodeInterface node) {
        LOGGER.info("The selected node has changed, reset the pending changes.");
        resetPendingChanges();
    }

    @Override
    public void nodeStateChanged(NodeInterface node) {

    }

    @Override
    public void listNodeAdded(NodeInterface node) {

    }

    @Override
    public void listNodeRemoved(NodeInterface node) {

    }
}
