package org.bidib.wizard.mvc.position.model;

import java.util.HashSet;
import java.util.Set;

import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.messages.enums.FeedbackPortEnum;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.wizard.model.ports.FeedbackPort;
import org.bidib.wizard.model.ports.GenericPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.status.FeedbackPortStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PositionFeedbackPort extends Port<FeedbackPortStatus> {

    private static final Logger LOGGER = LoggerFactory.getLogger(PositionFeedbackPort.class);

    private static final long serialVersionUID = 1L;

    private Set<PositionAddressData> addresses;

    public PositionFeedbackPort(int locationAddress) {
        super((GenericPort) null);
        setId(locationAddress);

        addresses = new HashSet<PositionAddressData>();

        setStatus(FeedbackPortStatus.FREE);
    }

    @Override
    public void setStatus(FeedbackPortStatus status) {
        super.setStatus(status);

        // remove the dynStates
        if (FeedbackPortStatus.FREE.equals(status)) {
            // clearDynStates();
            // setAddresses(null);
            // setTimestamp(null);
        }
    }

    public Set<PositionAddressData> getAddresses() {
        return addresses;
    }

    public boolean hasAddresses() {
        return CollectionUtils.isNotEmpty(addresses);
    }

    public void setAddresses(Set<PositionAddressData> addresses) {
        this.addresses = addresses;
    }

    public void addAddress(final PositionAddressData address) {
        LOGGER.debug("Add the address: {}", address);

        this.addresses.remove(address);
        this.addresses.add(address);
    }

    public void removeAddress(final PositionAddressData address) {
        LOGGER.debug("remove the address: {}", address);

        this.addresses.remove(address);
    }

    public void clear() {
        this.addresses.clear();
    }

    public boolean isOutdated(long timeout) {
        boolean outdated = false;
        if (addresses != null) {
            for (PositionAddressData address : addresses) {
                if (isOutDated(address.getLastSeenTimestamp(), System.currentTimeMillis(), timeout)) {
                    outdated = true;
                }
            }
        }
        return outdated;
    }

    private boolean isOutDated(long timestamp, long now, long timeout) {
        return (now - timestamp) > timeout;
    }

    @Override
    public byte[] getPortConfig() {
        return new byte[] { 0, 0, 0, 0 };
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof FeedbackPort) {
            return ((FeedbackPort) obj).getId() == getId();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return getId();
    }

    @Override
    public LcOutputType getPortType() {
        return LcOutputType.FEEDBACKPORT;
    }

    @Override
    protected FeedbackPortStatus internalGetStatus(final GenericPort genericPort) {
        return FeedbackPortStatus.valueOf(FeedbackPortEnum.valueOf(genericPort.getPortStatus()));
    }
}
