/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.common.view.text;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.bidib.wizard.mvc.common.view.text.HistoryModel;
import org.bidib.wizard.mvc.common.view.text.HistoryText;

/*
 * Exception performing whole class analysis ignored.
 */
public class HistoryText {
    private JTextComponent text;
    private HistoryModel historyModel;
    private int index;
    private String current;
    private JPopupMenu popup;
    private boolean instantPopups;

    public HistoryText(JTextComponent text, String name) {
        this.text = text;
        this.setModel(name);
        this.index = -1;
    }

    public void fireActionPerformed() {
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public HistoryModel getModel() {
        return this.historyModel;
    }

    public void setModel(String name) {
        this.historyModel = name == null ? null : HistoryModel.getModel((String)name);
        this.index = -1;
    }

    public void setInstantPopups(boolean instantPopups) {
        this.instantPopups = instantPopups;
    }

    public boolean getInstantPopups() {
        return this.instantPopups;
    }

    public void addCurrentToHistory() {
        if (this.historyModel != null) {
            this.historyModel.addItem(this.getText());
        }
        this.index = 0;
    }

    public void doBackwardSearch() {
        if (this.historyModel == null) {
            return;
        }
        if (this.text.getSelectionEnd() != this.getDocument().getLength()) {
            this.text.setCaretPosition(this.getDocument().getLength());
        }
        int start = this.getInputStart();
        String t = this.getText().substring(0, this.text.getSelectionStart() - start);
        if (t == null) {
            this.historyPrevious();
            return;
        }
        for (int i = this.index + 1; i < this.historyModel.getSize(); ++i) {
            String item = this.historyModel.getItem(i);
            if (!item.startsWith(t)) continue;
            this.text.replaceSelection(item.substring(t.length()));
            this.text.select(this.getInputStart() + t.length(), this.getDocument().getLength());
            this.index = i;
            return;
        }
        this.text.getToolkit().beep();
    }

    public void doForwardSearch() {
        if (this.historyModel == null) {
            return;
        }
        if (this.text.getSelectionEnd() != this.getDocument().getLength()) {
            this.text.setCaretPosition(this.getDocument().getLength());
        }
        int start = this.getInputStart();
        String t = this.getText().substring(0, this.text.getSelectionStart() - start);
        if (t == null) {
            this.historyNext();
            return;
        }
        for (int i = this.index - 1; i >= 0; --i) {
            String item = this.historyModel.getItem(i);
            if (!item.startsWith(t)) continue;
            this.text.replaceSelection(item.substring(t.length()));
            this.text.select(this.getInputStart() + t.length(), this.getDocument().getLength());
            this.index = i;
            return;
        }
        this.text.getToolkit().beep();
    }

    public void historyPrevious() {
        if (this.historyModel == null) {
            return;
        }
        if (this.index == this.historyModel.getSize() - 1) {
            this.text.getToolkit().beep();
        } else if (this.index == -1) {
            this.current = this.getText();
            this.setText(this.historyModel.getItem(0));
            this.index = 0;
        } else {
            int newIndex = this.index + 1;
            this.setText(this.historyModel.getItem(newIndex));
            this.index = newIndex;
        }
    }

    public void historyNext() {
        if (this.historyModel == null) {
            return;
        }
        if (this.index == -1) {
            this.text.getToolkit().beep();
        } else if (this.index == 0) {
            this.setText(this.current);
        } else {
            int newIndex = this.index - 1;
            this.setText(this.historyModel.getItem(newIndex));
            this.index = newIndex;
        }
    }

    public Document getDocument() {
        return this.text.getDocument();
    }

    public String getText() {
        return this.text.getText();
    }

    public void setText(String text) {
        this.index = -1;
        this.text.setText(text);
    }

    public int getInputStart() {
        return 0;
    }

    public void showPopupMenu(String t, int x, int y) {
        if (this.historyModel == null) {
            return;
        }
        this.text.requestFocus();
        if (this.popup != null && this.popup.isVisible()) {
            this.popup.setVisible(false);
            this.popup = null;
            return;
        }
        this.popup = new /* Unavailable Anonymous Inner Class!! */;
        JMenuItem caption = new JMenuItem("History");
        caption.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.popup.add(caption);
        this.popup.addSeparator();
        for (int i = 0; i < this.historyModel.getSize(); ++i) {
            String item = this.historyModel.getItem(i);
            if (!item.startsWith(t)) continue;
            JMenuItem menuItem = new JMenuItem(item);
            menuItem.setActionCommand(String.valueOf(i));
            menuItem.addActionListener((ActionListener)new ActionHandler(this));
            this.popup.add(menuItem);
        }
        HistoryText.showPopupMenu((JPopupMenu)this.popup, (Component)this.text, (int)x, (int)y, (boolean)false);
    }

    public void showPopupMenu(boolean search) {
        if (search) {
            this.showPopupMenu(this.getText().substring(this.getInputStart(), this.text.getSelectionStart()), 0, this.text.getHeight());
        } else {
            this.showPopupMenu("", 0, this.text.getHeight());
        }
    }

    public static void showPopupMenu(JPopupMenu popup, Component comp, int x, int y, boolean point) {
        Component win;
        int offsetX = 0;
        int offsetY = 0;
        int extraOffset = point ? 1 : 0;
        for (win = comp; !(win instanceof Window) && win != null; win = win.getParent()) {
            offsetX += win.getX();
            offsetY += win.getY();
        }
        if (win != null) {
            Dimension size = popup.getPreferredSize();
            Rectangle screenSize = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
            x = x + offsetX + size.width + win.getX() > screenSize.width && x + offsetX + win.getX() >= size.width ? (point ? (x -= size.width + extraOffset) : win.getWidth() - size.width - offsetX + extraOffset) : (x += extraOffset);
            y = y + offsetY + size.height + win.getY() > screenSize.height && y + offsetY + win.getY() >= size.height ? (point ? win.getHeight() - size.height - offsetY + extraOffset : -size.height - 1) : (y += extraOffset);
            popup.show(comp, x, y);
        } else {
            popup.show(comp, x + extraOffset, y + extraOffset);
        }
    }
}

