/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.controller;

import java.awt.Component;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import org.bidib.jbidibc.core.schema.bidiblabels.AccessoryLabel;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.wizard.api.model.Accessory;
import org.bidib.wizard.api.model.AccessorySwitchTimeModel;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.api.service.node.SwitchingNodeService;
import org.bidib.wizard.common.labels.LabelsChangedEvent;
import org.bidib.wizard.common.labels.WizardLabelFactory;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.view.statusbar.StatusBar;
import org.bidib.wizard.core.labels.AccessoryLabelUtils;
import org.bidib.wizard.core.service.SettingsService;
import org.bidib.wizard.mvc.main.model.AccessoryStartupAspectModel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.listener.AccessoryRequestListener;
import org.bidib.wizard.mvc.main.view.component.DefaultBusyFrame;
import org.bidib.wizard.mvc.main.view.panel.AccessoryListPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;

public class AccessoryPanelController
implements AccessoryRequestListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessoryPanelController.class);
    private final MainModel mainModel;
    private final AccessoryStartupAspectModel accessoryStartupAspectModel;
    private final AccessorySwitchTimeModel accessorySwitchTimeModel;
    private AccessoryListPanel accessoryListPanel;
    @Autowired
    private SwitchingNodeService switchingService;
    @Autowired
    private SettingsService settingsService;
    @Autowired
    private WizardLabelWrapper wizardLabelWrapper;
    @Autowired
    private StatusBar statusBar;
    @Autowired
    private ConsoleService consoleService;

    public AccessoryPanelController(MainModel mainModel) {
        this.mainModel = mainModel;
        this.accessoryStartupAspectModel = new AccessoryStartupAspectModel();
        this.accessorySwitchTimeModel = new AccessorySwitchTimeModel();
        AnnotationProcessor.process((Object)this);
    }

    public AccessoryListPanel createAccessoryListPanel(TabVisibilityListener tabVisibilityListener) {
        this.accessoryListPanel = new AccessoryListPanel(this, this.mainModel, this.accessoryStartupAspectModel, this.accessorySwitchTimeModel, tabVisibilityListener, this.settingsService, this.wizardLabelWrapper, this.statusBar, this.consoleService);
        this.accessoryListPanel.addListSelectionListener((ListSelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        return this.accessoryListPanel;
    }

    public List<Macro> getMacros() {
        return this.mainModel.getMacros();
    }

    public NodeInterface getSelectedNode() {
        return this.mainModel.getSelectedNode();
    }

    private NodeLabels getNodeLabels() {
        WizardLabelFactory wizardLabelFactory = this.wizardLabelWrapper.getWizardLabelFactory();
        NodeLabels nodeLabels = wizardLabelFactory.loadLabels(Long.valueOf(this.getSelectedNode().getUniqueId()), new String[0]);
        return nodeLabels;
    }

    public AccessoryLabel getAccessoryAspectsLabels(int accessoryId) {
        NodeLabels nodeLabels = this.getNodeLabels();
        if (nodeLabels == null) {
            LOGGER.warn("No node labels avaialble.");
            return null;
        }
        return AccessoryLabelUtils.getAccessoryLabel((NodeLabels)nodeLabels, (int)accessoryId);
    }

    public void setAccessoryAspectLabel(int accessoryId, int aspectId, String label) {
        NodeLabels nodeLabels = this.getNodeLabels();
        if (nodeLabels == null) {
            LOGGER.info("No node labels avaialble.");
            return;
        }
        boolean save = true;
        this.setAccessoryAspectLabel(accessoryId, aspectId, label, save);
    }

    public void setAccessoryAspectLabel(int accessoryId, int aspectId, String label, boolean save) {
        NodeLabels nodeLabels = this.getNodeLabels();
        AccessoryLabelUtils.replaceAspectLabel((NodeLabels)nodeLabels, (int)accessoryId, (int)aspectId, (String)label);
        if (save) {
            this.saveLabels();
        }
    }

    private void saveLabels() {
        try {
            long uniqueId = this.getSelectedNode().getUniqueId();
            this.wizardLabelWrapper.saveNodeLabels(Long.valueOf(uniqueId));
        }
        catch (Exception e) {
            LOGGER.warn("Save accessory labels failed.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void activateAspect(Accessory accessory, int aspectNumber) {
        LOGGER.info("Start accessory with aspect: {}, accessory: {}", (Object)aspectNumber, (Object)accessory);
        try {
            DefaultBusyFrame.setWaitCursor((Component)this.accessoryListPanel.getComponent());
            this.switchingService.setAccessoryAspect("main", this.getSelectedNode().getSwitchingNode(), accessory, aspectNumber);
        }
        finally {
            DefaultBusyFrame.setDefaultCursor((Component)this.accessoryListPanel.getComponent());
        }
    }

    public void storeAccessory(Accessory accessory) {
        LOGGER.info("Store the accessory: {}", (Object)accessory);
        try {
            DefaultBusyFrame.setWaitCursor((Component)this.accessoryListPanel.getComponent());
            Accessory accessoryClone = Accessory.cloneAccessoryData((Accessory)accessory);
            this.switchingService.saveAccessory("main", this.getSelectedNode().getSwitchingNode(), accessoryClone);
        }
        finally {
            DefaultBusyFrame.setDefaultCursor((Component)this.accessoryListPanel.getComponent());
        }
    }

    public void reloadAccessory(Accessory accessory) {
        LOGGER.info("Reload the accessory: {}", (Object)accessory);
        try {
            DefaultBusyFrame.setWaitCursor((Component)this.accessoryListPanel.getComponent());
            Accessory accessoryClone = Accessory.cloneAccessoryData((Accessory)accessory);
            this.switchingService.reloadAccessory("main", this.getSelectedNode().getSwitchingNode(), accessoryClone);
        }
        finally {
            DefaultBusyFrame.setDefaultCursor((Component)this.accessoryListPanel.getComponent());
        }
    }

    public void saveAccessoryLabel(Accessory accessory, String label) {
        LOGGER.info("Save the accessory label, accessory: {}, label: {}", (Object)accessory, (Object)label);
        accessory.setLabel(label);
        NodeLabels nodeLabels = this.getNodeLabels();
        AccessoryLabelUtils.replaceAccessoryLabel((NodeLabels)nodeLabels, (int)accessory.getId(), (String)label);
        this.saveLabels();
    }

    @EventListener(value={LabelsChangedEvent.class})
    public void labelsChangedEvent(LabelsChangedEvent labelsChangedEvent) {
        LOGGER.info("The labels have changed, node: {}", (Object)labelsChangedEvent);
        if (this.accessoryListPanel != null) {
            SwingUtilities.invokeLater(() -> this.accessoryListPanel.refreshView());
        }
    }
}

