/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.component;

import java.awt.Component;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.lang3.StringUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.core.dialog.FileDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MacroFileDialog
extends FileDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(MacroFileDialog.class);
    private final String MACRO_EXTENSION = "mxml";
    private FileFilter macroFilter;
    private String macroDescription = Resources.getString(MacroFileDialog.class, (String)"macroDescription");

    public MacroFileDialog(Component parent, int dialogType, Macro macro) {
        super(parent, dialogType, null, null, new FileFilter[0]);
        this.macroFilter = new FileNameExtensionFilter(this.macroDescription, "mxml");
        Object fileName = null;
        if (macro != null) {
            fileName = macro.toString();
            fileName = ((String)fileName).replaceAll("[^a-zA-Z0-9.+-]", "_");
        }
        if (StringUtils.isNotBlank(fileName)) {
            fileName = (String)fileName + ".mxml";
            LOGGER.info("Update the file filter for macro extension, fileName: {}", fileName);
        }
        this.updateFileFilter(new FileFilter[]{this.macroFilter}, (String)fileName);
    }
}

