/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.stepcontrol.controller;

import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingConstants;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.DockingUtilities;
import com.vlsolutions.swing.docking.RelativeDockablePosition;
import com.vlsolutions.swing.docking.TabbedDockableContainer;
import com.vlsolutions.swing.docking.event.DockableStateChangeListener;
import org.bidib.wizard.client.common.view.DockKeys;
import org.bidib.wizard.client.common.view.DockUtils;
import org.bidib.wizard.common.context.DefaultApplicationContext;
import org.bidib.wizard.mvc.stepcontrol.view.CvConsoleView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CvConsoleController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CvConsoleController.class);
    private static String SEARCHKEY = "CvConsoleView";
    private CvConsoleView view;

    public void start(DockingDesktop desktop) {
        LOGGER.info("Search for view with key: {}", (Object)SEARCHKEY);
        Dockable consoleView = desktop.getContext().getDockableByKey(SEARCHKEY);
        if (consoleView != null) {
            LOGGER.info("Select the existing console view.");
            DockUtils.selectWindow((Dockable)consoleView);
            return;
        }
        LOGGER.info("Create new CvConsoleView.");
        this.view = new CvConsoleView();
        DockableState[] dockables = desktop.getDockables();
        LOGGER.info("Current dockables: {}", new Object[]{dockables});
        if (dockables.length > 1) {
            DockableState boosterTableView = null;
            for (DockableState dockable : dockables) {
                if (!DockKeys.DOCKKEY_BOOSTER_TABLE_VIEW.equals((Object)dockable.getDockable().getDockKey())) continue;
                LOGGER.info("Found the booster table view dockable.");
                boosterTableView = dockable;
                break;
            }
            Dockable dock = desktop.getDockables()[1].getDockable();
            if (boosterTableView != null) {
                LOGGER.info("Add the CV console view to the booster table view panel.");
                dock = boosterTableView.getDockable();
                TabbedDockableContainer container = DockingUtilities.findTabbedDockableContainer((Dockable)dock);
                int order = 0;
                if (container != null) {
                    order = container.getTabCount();
                }
                LOGGER.info("Add new log panel at order: {}", (Object)order);
                desktop.createTab(dock, (Dockable)this.view, order, true);
            } else {
                desktop.split(dock, (Dockable)this.view, DockingConstants.SPLIT_RIGHT);
            }
        } else {
            desktop.addDockable((Dockable)this.view, RelativeDockablePosition.RIGHT);
        }
        desktop.addDockableStateChangeListener((DockableStateChangeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static synchronized void ensureConsoleVisible() {
        LOGGER.info("Search for view with key: {}", (Object)SEARCHKEY);
        DockingDesktop desktop = (DockingDesktop)DefaultApplicationContext.getInstance().get("desktop", DockingDesktop.class);
        Dockable consoleView = desktop.getContext().getDockableByKey(SEARCHKEY);
        if (consoleView != null) {
            LOGGER.info("Select the existing console view.");
            DockUtils.selectWindow((Dockable)consoleView);
            return;
        }
        LOGGER.info("Create new controller to open the console.");
        new CvConsoleController().start(desktop);
    }
}

