/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.common.view.converter;

import com.jgoodies.binding.value.BindingConverter;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringToLocalTimeConverter
implements BindingConverter<LocalTime, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringToLocalTimeConverter.class);

    public String targetValue(LocalTime sourceValue) {
        if (sourceValue != null) {
            return DateTimeFormatter.ofPattern("HH:mm").format(sourceValue);
        }
        return null;
    }

    public LocalTime sourceValue(String targetValue) {
        if (StringUtils.isNotBlank((CharSequence)targetValue)) {
            try {
                return LocalTime.parse(targetValue, DateTimeFormatter.ofPattern("HH:mm"));
            }
            catch (Exception ex) {
                LOGGER.warn("Parse string to LocalTime failed, value: {}, message: {}", (Object)targetValue, (Object)ex.getMessage());
            }
        }
        return null;
    }
}

