/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.common.view.converter;

import com.jgoodies.binding.value.BindingConverter;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.messages.ProtocolVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringToProtocolVersionConverter
implements BindingConverter<ProtocolVersion, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringToProtocolVersionConverter.class);

    public String targetValue(ProtocolVersion sourceValue) {
        if (sourceValue != null) {
            return sourceValue.toString();
        }
        return null;
    }

    public ProtocolVersion sourceValue(String targetValue) {
        if (StringUtils.isNotBlank((CharSequence)targetValue)) {
            try {
                ProtocolVersion.parse((String)targetValue);
            }
            catch (Exception ex) {
                LOGGER.warn("Parse string to ProtocolVersion failed, value: {}, message: {}", (Object)targetValue, (Object)ex.getMessage());
            }
        }
        return null;
    }
}

