/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.common.view.cvdefinition;

import com.jidesoft.grid.DefaultExpandableRow;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bidib.jbidibc.core.node.ConfigurationVariable;
import org.bidib.jbidibc.messages.enums.SysErrorEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.client.common.view.cvdef.CvNode;
import org.bidib.wizard.client.common.view.cvdef.LongCvNode;
import org.bidib.wizard.mvc.common.view.cvdefinition.CvDefinitionPanelProvider;
import org.bidib.wizard.mvc.common.view.cvdefinition.CvValueUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class CvValueUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CvValueUtils.class);

    public static void writeCvValues(NodeInterface selectedNode, DefaultExpandableRow treeNode, Map<String, CvNode> cvNumberToNodeMap, CvDefinitionPanelProvider cvDefintionPanelProvider) {
        LOGGER.info("Write the CV values.");
        LinkedList cvList = new LinkedList();
        CvValueUtils.collectNewValues((DefaultExpandableRow)treeNode, cvList);
        CvValueUtils.writeCvValues((NodeInterface)selectedNode, cvList, cvNumberToNodeMap, (CvDefinitionPanelProvider)cvDefintionPanelProvider);
    }

    public static void writeCvValues(NodeInterface selectedNode, List<ConfigurationVariable> cvList, Map<String, CvNode> cvNumberToNodeMap, CvDefinitionPanelProvider cvDefinitionPanelProvider) {
        LOGGER.debug("Write the provided CV values.");
        if (cvList.size() > 0) {
            cvDefinitionPanelProvider.writeConfigVariables(cvList);
            boolean needsReboot = false;
            for (ConfigurationVariable cv : cvList) {
                CvNode cvNode = cvNumberToNodeMap.get(cv.getName());
                if (cvNode == null) continue;
                cvNode.resetNewValue();
                Boolean isRebootNeeded = cvNode.getCV().isRebootneeded();
                if (isRebootNeeded == null || !isRebootNeeded.booleanValue()) continue;
                needsReboot = true;
                LOGGER.info("Needs reboot detected, current CV: {}", (Object)cvNode.getCV());
            }
            cvDefinitionPanelProvider.checkPendingChanges();
            if (needsReboot) {
                LOGGER.info("A CV was changed that needs a reboot of the node!");
                if (selectedNode != null) {
                    String reason = Resources.getString(SysErrorEnum.class, (String)"BIDIB_ERR_RESET_REQUIRED");
                    selectedNode.setErrorState(SysErrorEnum.BIDIB_ERR_RESET_REQUIRED, reason);
                }
            }
        } else {
            LOGGER.warn("No changed configuration variables available.");
        }
    }

    private static void collectNewValues(DefaultExpandableRow node, List<ConfigurationVariable> cvList) {
        for (int childIndex = 0; childIndex < node.getChildrenCount(); ++childIndex) {
            DefaultExpandableRow child = (DefaultExpandableRow)node.getChildAt(childIndex);
            if (child instanceof CvNode) {
                CvNode cvNode = (CvNode)child;
                CvValueUtils.addNewValueToList((CvNode)cvNode, cvList);
                continue;
            }
            CvValueUtils.collectNewValues((DefaultExpandableRow)child, cvList);
        }
    }

    public static void addNewValueToList(CvNode cvNode, List<ConfigurationVariable> cvList) {
        if (cvNode.getNewValue() != null) {
            String cvNumber = cvNode.getConfigVar().getName();
            String cvValue = Objects.toString(cvNode.getNewValue(), null);
            ConfigurationVariable cv = new ConfigurationVariable(cvNumber, cvValue);
            cvList.add(cv);
        }
    }

    public static void compareAndAddNewValue(CvNode cvNode, String newValue, List<ConfigurationVariable> cvList, Map<String, CvNode> cvNumberToNodeMap) {
        if (cvNode != null) {
            switch (1.$SwitchMap$org$bidib$jbidibc$exchange$vendorcv$DataType[cvNode.getCV().getType().ordinal()]) {
                case 1: 
                case 2: {
                    byte highValue;
                    int val = Integer.parseInt(newValue);
                    int cvNumber = Integer.parseInt(cvNode.getCV().getNumber());
                    int highCvNum = Integer.parseInt(cvNode.getCV().getHigh());
                    if (highCvNum == cvNumber) {
                        byte lowValue;
                        byte highValue2 = ByteUtils.getHighByte((int)val);
                        boolean changeDetected = CvValueUtils.compareAndAddNewValueAtomic((CvNode)cvNode, (String)ByteUtils.toString((byte)highValue2), cvList, (boolean)false);
                        CvNode lowCvNode = cvNumberToNodeMap.get(cvNode.getCV().getLow());
                        boolean changeDetectedLow = CvValueUtils.compareAndAddNewValueAtomic((CvNode)lowCvNode, (String)ByteUtils.toString((byte)(lowValue = ByteUtils.getLowByte((int)val))), cvList, (boolean)changeDetected);
                        if (changeDetectedLow == changeDetected) break;
                        CvValueUtils.compareAndAddNewValueAtomic((CvNode)cvNode, (String)ByteUtils.toString((byte)highValue2), cvList, (boolean)true);
                        break;
                    }
                    byte lowValue = ByteUtils.getLowByte((int)val);
                    boolean changeDetected = CvValueUtils.compareAndAddNewValueAtomic((CvNode)cvNode, (String)ByteUtils.toString((byte)lowValue), cvList, (boolean)false);
                    CvNode highCvNode = cvNumberToNodeMap.get(cvNode.getCV().getHigh());
                    boolean changeDetectedLow = CvValueUtils.compareAndAddNewValueAtomic((CvNode)highCvNode, (String)ByteUtils.toString((byte)(highValue = ByteUtils.getHighByte((int)val))), cvList, (boolean)changeDetected);
                    if (changeDetectedLow == changeDetected) break;
                    CvValueUtils.compareAndAddNewValueAtomic((CvNode)cvNode, (String)ByteUtils.toString((byte)highValue), cvList, (boolean)true);
                    break;
                }
                case 3: {
                    LOGGER.debug("Long value: {}", (Object)cvNode);
                    long longVal = Long.parseLong(newValue);
                    LongCvNode positionNode = (LongCvNode)cvNode;
                    int cvNumber = Integer.parseInt(positionNode.getCV().getNumber());
                    byte[] bytes = new byte[]{ByteUtils.getLowByte((int)((int)longVal)), ByteUtils.getHighByte((int)((int)longVal)), ByteUtils.getHighWordLowByte((int)((int)longVal)), ByteUtils.getHighWordHighByte((int)((int)longVal))};
                    LOGGER.debug("Current master CV#: {}, value: {}", (Object)positionNode.getCV().getNumber(), (Object)ByteUtils.getInt((byte)bytes[0]));
                    boolean changeDetected = CvValueUtils.compareAndAddNewValueAtomic((CvNode)positionNode, (String)Integer.toString(ByteUtils.getInt((byte)bytes[0])), cvList, (boolean)false);
                    int idx = 1;
                    for (CvNode slaveNode : positionNode.getSlaveNodes()) {
                        LOGGER.debug("Current slave CV#: {}, value: {}", (Object)slaveNode.getCV().getNumber(), (Object)ByteUtils.getInt((byte)bytes[idx]));
                        boolean changeDetectedSlave = CvValueUtils.compareAndAddNewValueAtomic((CvNode)slaveNode, (String)ByteUtils.toString((byte)bytes[idx]), cvList, (boolean)changeDetected);
                        if (changeDetectedSlave != changeDetected) {
                            LOGGER.info("Change detected!");
                            CvValueUtils.compareAndAddNewValueAtomic((CvNode)positionNode, (String)Integer.toString(ByteUtils.getInt((byte)bytes[0])), cvList, (boolean)true);
                            for (int i = 1; i < idx; ++i) {
                                CvNode tempSlaveNode = (CvNode)positionNode.getSlaveNodes().get(i);
                                CvValueUtils.compareAndAddNewValueAtomic((CvNode)tempSlaveNode, (String)ByteUtils.toString((byte)bytes[i]), cvList, (boolean)true);
                            }
                            changeDetected = true;
                        }
                        ++idx;
                    }
                    break;
                }
                default: {
                    CvValueUtils.compareAndAddNewValueAtomic((CvNode)cvNode, (String)newValue, cvList, (boolean)false);
                }
            }
        }
    }

    private static boolean compareAndAddNewValueAtomic(CvNode cvNode, String newValue, List<ConfigurationVariable> cvList, boolean force) {
        boolean changeDetected = false;
        if (cvNode.getNewValue() == null) {
            if (force || !Objects.equals(cvNode.getConfigVar().getValue(), newValue)) {
                cvNode.setNewValue((Object)newValue);
                changeDetected = true;
            }
        } else if (force || !Objects.equals(cvNode.getNewValue().toString(), newValue)) {
            cvNode.setNewValue((Object)newValue);
            changeDetected = true;
        }
        if (changeDetected && cvNode.getNewValue() != null) {
            String cvNumber = cvNode.getConfigVar().getName();
            String cvValue = Objects.toString(cvNode.getNewValue(), null);
            ConfigurationVariable cv = new ConfigurationVariable(cvNumber, cvValue);
            cvList.add(cv);
            changeDetected = true;
        }
        return changeDetected;
    }

    public static void compareAndAddNewValue(LongCvNode cvNode, Integer newValue, List<ConfigurationVariable> cvList) {
        LOGGER.info("The new long value is: {}", (Object)newValue);
        byte[] bytes = new byte[]{ByteUtils.getLowByte((Integer)newValue), ByteUtils.getHighByte((Integer)newValue), ByteUtils.getHighWordLowByte((int)newValue), ByteUtils.getHighWordHighByte((int)newValue)};
        LOGGER.debug("Current master CV#: {}, value: {}", (Object)cvNode.getCV().getNumber(), (Object)ByteUtils.getInt((byte)bytes[0]));
        boolean changeDetected = CvValueUtils.compareAndAddNewValueAtomic((CvNode)cvNode, (String)Integer.toString(ByteUtils.getInt((byte)bytes[0])), cvList, (boolean)false);
        int idx = 1;
        for (CvNode slaveNode : cvNode.getSlaveNodes()) {
            LOGGER.debug("Current slave CV#: {}, value: {}", (Object)slaveNode.getCV().getNumber(), (Object)ByteUtils.getInt((byte)bytes[idx]));
            boolean changeDetectedSlave = CvValueUtils.compareAndAddNewValueAtomic((CvNode)slaveNode, (String)Integer.toString(ByteUtils.getInt((byte)bytes[idx])), cvList, (boolean)changeDetected);
            if (changeDetectedSlave != changeDetected) {
                CvValueUtils.compareAndAddNewValueAtomic((CvNode)cvNode, (String)Integer.toString(ByteUtils.getInt((byte)bytes[0])), cvList, (boolean)true);
                for (int i = 1; i < idx; ++i) {
                    CvValueUtils.compareAndAddNewValueAtomic((CvNode)((CvNode)cvNode.getSlaveNodes().get(i)), (String)Integer.toString(ByteUtils.getInt((byte)bytes[i])), cvList, (boolean)true);
                }
                changeDetected = true;
            }
            ++idx;
        }
    }

    public static Integer getConfigVarByteValue(CvNode cvNode, Map<String, CvNode> cvNumberToNodeMap) {
        Integer value = 0;
        if (cvNode.getCV() != null) {
            switch (1.$SwitchMap$org$bidib$jbidibc$exchange$vendorcv$DataType[cvNode.getCV().getType().ordinal()]) {
                case 4: {
                    value = Integer.parseInt(cvNode.getConfigVar().getValue());
                    break;
                }
                default: {
                    value = Integer.parseInt(cvNode.getConfigVar().getValue());
                }
            }
        }
        return value;
    }

    public static Integer getConfigVarIntValue(CvNode cvNode, Map<String, CvNode> cvNumberToNodeMap) {
        Integer value = null;
        if (cvNode != null) {
            try {
                switch (1.$SwitchMap$org$bidib$jbidibc$exchange$vendorcv$DataType[cvNode.getCV().getType().ordinal()]) {
                    case 1: {
                        value = Integer.parseInt(cvNode.getConfigVar().getValue());
                        int highCvNum = Integer.parseInt(cvNode.getCV().getHigh());
                        int cvNumber = Integer.parseInt(cvNode.getCV().getNumber());
                        if (highCvNum == cvNumber) {
                            CvNode lowCvNode = cvNumberToNodeMap.get(cvNode.getCV().getLow());
                            value = value << 8 | Integer.parseInt(lowCvNode.getConfigVar().getValue());
                            break;
                        }
                        CvNode highCvNode = cvNumberToNodeMap.get(cvNode.getCV().getHigh());
                        value = Integer.parseInt(highCvNode.getConfigVar().getValue()) << 8 | value;
                        break;
                    }
                    default: {
                        value = Integer.parseInt(cvNode.getConfigVar().getValue());
                        break;
                    }
                }
            }
            catch (NumberFormatException ex) {
                LOGGER.warn("Get the integer value from CV node failed.", (Throwable)ex);
            }
            catch (NullPointerException ex) {
                LOGGER.warn("Get the integer value from CV node failed.", (Throwable)ex);
            }
        }
        return value;
    }

    public static Long getConfigVarLongValue(CvNode cvNode) {
        Long value = null;
        if (cvNode != null) {
            switch (1.$SwitchMap$org$bidib$jbidibc$exchange$vendorcv$DataType[cvNode.getCV().getType().ordinal()]) {
                case 3: {
                    LongCvNode masterNode = ((LongCvNode)cvNode).getMasterNode();
                    long longValue = 0L;
                    CvNode[] slaveNodes = masterNode.getSlaveNodes().toArray(new CvNode[0]);
                    for (int index = 2; index > -1; --index) {
                        CvNode slaveNode = slaveNodes[index];
                        longValue = longValue << 8 | (long)Integer.parseInt(slaveNode.getConfigVar().getValue());
                    }
                    longValue = longValue << 8 | (long)Integer.parseInt(masterNode.getConfigVar().getValue());
                    value = longValue & 0xFFFFFFFFL;
                    break;
                }
            }
        }
        return value;
    }

    public static String getConfigVarStringValue(CvNode cvNode) {
        String value = null;
        if (cvNode != null) {
            switch (1.$SwitchMap$org$bidib$jbidibc$exchange$vendorcv$DataType[cvNode.getCV().getType().ordinal()]) {
                case 5: {
                    value = cvNode.getConfigVar().getValue();
                    break;
                }
            }
        }
        return value;
    }
}

