/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.common.view.icon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.bidib.wizard.mvc.common.view.icon.TextIcon;

public class TextIcon
implements Icon,
PropertyChangeListener {
    private JComponent component;
    private Layout layout;
    private String text;
    private Font font;
    private Color foreground;
    private int padding;
    private int iconWidth;
    private int iconHeight;
    private String[] strings;
    private int[] stringWidths;

    public TextIcon(JComponent component, String text) {
        this(component, text, Layout.HORIZONTAL);
    }

    public TextIcon(JComponent component, String text, Layout layout) {
        this.component = component;
        this.layout = layout;
        this.setText(text);
        component.addPropertyChangeListener("font", (PropertyChangeListener)this);
    }

    public Layout getLayout() {
        return this.layout;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.calculateIconDimensions();
    }

    public Font getFont() {
        if (this.font == null) {
            return this.component.getFont();
        }
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        this.calculateIconDimensions();
    }

    public Color getForeground() {
        if (this.foreground == null) {
            return this.component.getForeground();
        }
        return this.foreground;
    }

    public void setForeground(Color foreground) {
        this.foreground = foreground;
        this.component.repaint();
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int padding) {
        this.padding = padding;
        this.calculateIconDimensions();
    }

    private void calculateIconDimensions() {
        Font font = this.getFont();
        FontMetrics fm = this.component.getFontMetrics(font);
        if (this.layout == Layout.HORIZONTAL) {
            this.iconWidth = fm.stringWidth(this.text) + this.padding * 2;
            this.iconHeight = fm.getHeight();
        } else if (this.layout == Layout.VERTICAL) {
            int maxWidth = 0;
            this.strings = new String[this.text.length()];
            this.stringWidths = new int[this.text.length()];
            for (int i = 0; i < this.text.length(); ++i) {
                this.strings[i] = this.text.substring(i, i + 1);
                this.stringWidths[i] = fm.stringWidth(this.strings[i]);
                maxWidth = Math.max(maxWidth, this.stringWidths[i]);
            }
            this.iconWidth = maxWidth + (fm.getLeading() + 2) * 2;
            this.iconHeight = (fm.getHeight() - fm.getDescent()) * this.text.length();
            this.iconHeight += this.padding * 2;
        }
        this.component.revalidate();
    }

    @Override
    public int getIconWidth() {
        return this.iconWidth;
    }

    @Override
    public int getIconHeight() {
        return this.iconHeight;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g.create();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Map map = (Map)toolkit.getDesktopProperty("awt.font.desktophints");
        if (map != null) {
            g2.addRenderingHints(map);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        g2.setFont(this.getFont());
        g2.setColor(this.getForeground());
        FontMetrics fm = g2.getFontMetrics();
        if (this.layout == Layout.HORIZONTAL) {
            g2.translate(x, y + fm.getAscent());
            g2.drawString(this.text, this.padding, 0);
        } else if (this.layout == Layout.VERTICAL) {
            int offsetY = fm.getAscent() - fm.getDescent() + this.padding;
            int incrementY = fm.getHeight() - fm.getDescent();
            for (int i = 0; i < this.text.length(); ++i) {
                int offsetX = Math.round((float)(this.getIconWidth() - this.stringWidths[i]) / 2.0f);
                g2.drawString(this.strings[i], x + offsetX, y + offsetY);
                offsetY += incrementY;
            }
        }
        g2.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (this.font == null) {
            this.calculateIconDimensions();
        }
    }
}

