/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.logger.controller;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingConstants;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.DockingUtilities;
import com.vlsolutions.swing.docking.RelativeDockablePosition;
import com.vlsolutions.swing.docking.TabbedDockableContainer;
import com.vlsolutions.swing.docking.event.DockableStateChangeListener;
import org.bidib.wizard.client.common.view.DockKeys;
import org.bidib.wizard.core.logger.BidibLogsAppender;
import org.bidib.wizard.mvc.logger.view.LogPanelView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogPanelController {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogPanelController.class);
    private LogPanelView view;
    private final DockingDesktop desktop;

    public LogPanelController(DockingDesktop desktop) {
        this.desktop = desktop;
    }

    public void start() {
        String searchKey = "LogPanelView";
        LOGGER.info("Search for view with key: {}", (Object)searchKey);
        Dockable logPanelView = this.desktop.getContext().getDockableByKey(searchKey);
        if (logPanelView != null) {
            LOGGER.info("Select the existing log panel view.");
            this.selectWindow(logPanelView);
            return;
        }
        try {
            LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
            ch.qos.logback.classic.Logger logTX = context.getLogger("TX");
            DockableState[] logRX = context.getLogger("RX");
            Appender appender = logTX.getAppender("BidibLogsAppender");
            if (appender == null) {
                BidibLogsAppender simpleLogPanelAppender = new BidibLogsAppender();
                simpleLogPanelAppender.setContext((Context)context);
                simpleLogPanelAppender.setName("BidibLogsAppender");
                simpleLogPanelAppender.start();
                logTX.setAdditive(false);
                logTX.setLevel(Level.INFO);
                logTX.addAppender((Appender)simpleLogPanelAppender);
                logRX.setAdditive(false);
                logRX.setLevel(Level.INFO);
                logRX.addAppender((Appender)simpleLogPanelAppender);
            } else {
                LOGGER.info("LogPanel appender is already assigned.");
            }
        }
        catch (Exception ex) {
            LOGGER.info("Add simple log panel logger failed.");
        }
        LOGGER.info("Create new LogPanelView.");
        this.view = new LogPanelView();
        DockableState[] dockables = this.desktop.getDockables();
        LOGGER.info("Current dockables: {}", new Object[]{dockables});
        if (dockables.length > 1) {
            DockableState boosterTableView = null;
            for (DockableState dockable : dockables) {
                if (!DockKeys.DOCKKEY_BOOSTER_TABLE_VIEW.equals((Object)dockable.getDockable().getDockKey())) continue;
                LOGGER.info("Found the booster table view dockable.");
                boosterTableView = dockable;
                break;
            }
            Dockable dock = this.desktop.getDockables()[1].getDockable();
            if (boosterTableView != null) {
                LOGGER.info("Add the log panel view to the booster table view panel.");
                dock = boosterTableView.getDockable();
                TabbedDockableContainer container = DockingUtilities.findTabbedDockableContainer((Dockable)dock);
                int order = 0;
                if (container != null) {
                    order = container.getTabCount();
                }
                LOGGER.info("Add new log panel at order: {}", (Object)order);
                this.desktop.createTab(dock, (Dockable)this.view, order, true);
            } else {
                this.desktop.split(dock, (Dockable)this.view, DockingConstants.SPLIT_RIGHT);
            }
        } else {
            this.desktop.addDockable((Dockable)this.view, RelativeDockablePosition.RIGHT);
        }
        this.desktop.addDockableStateChangeListener((DockableStateChangeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void selectWindow(Dockable dockable) {
        TabbedDockableContainer container = DockingUtilities.findTabbedDockableContainer((Dockable)dockable);
        if (container != null) {
            container.setSelectedDockable(dockable);
        } else {
            LOGGER.warn("Container not available, select component directly.");
            dockable.getComponent().requestFocusInWindow();
        }
    }
}

