/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.component;

import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import com.vlsolutions.swing.docking.DockingDesktop;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.node.ConfigurationVariable;
import org.bidib.jbidibc.messages.enums.AccessoryExecutionState;
import org.bidib.jbidibc.messages.enums.IdentifyState;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.port.PortConfigValue;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.Accessory;
import org.bidib.wizard.api.model.BoosterNodeInterface;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.SwitchingNodeInterface;
import org.bidib.wizard.api.script.ScriptCommand;
import org.bidib.wizard.api.script.ScriptEngineListener;
import org.bidib.wizard.api.script.ScriptStatus;
import org.bidib.wizard.api.script.Scripting;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.api.service.node.BoosterService;
import org.bidib.wizard.api.service.node.NodeService;
import org.bidib.wizard.api.service.node.SwitchingNodeService;
import org.bidib.wizard.api.utils.AccessoryListUtils;
import org.bidib.wizard.client.common.dialog.EscapeDialog;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.common.script.DefaultScriptContext;
import org.bidib.wizard.common.script.booster.BoosterScripting;
import org.bidib.wizard.common.script.engine.ScriptEngine;
import org.bidib.wizard.common.script.node.NodeScripting;
import org.bidib.wizard.common.script.node.types.CvType;
import org.bidib.wizard.common.script.node.types.FeatureType;
import org.bidib.wizard.common.script.node.types.ScriptingTargetType;
import org.bidib.wizard.common.script.node.types.TargetType;
import org.bidib.wizard.common.script.switching.AccessoryScripting;
import org.bidib.wizard.common.script.switching.NodeTreeScripting;
import org.bidib.wizard.common.script.switching.PortScripting;
import org.bidib.wizard.common.script.switching.SwitchFunctionsScriptCommandFactory;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.core.service.SettingsService;
import org.bidib.wizard.model.ports.LightPort;
import org.bidib.wizard.model.ports.MotorPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.ServoPort;
import org.bidib.wizard.model.ports.SoundPort;
import org.bidib.wizard.model.ports.SwitchPairPort;
import org.bidib.wizard.model.ports.SwitchPort;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.BoosterStatus;
import org.bidib.wizard.model.status.LightPortStatus;
import org.bidib.wizard.model.status.SoundPortStatus;
import org.bidib.wizard.model.status.SwitchPortStatus;
import org.bidib.wizard.mvc.loco.view.ScriptPanel;
import org.bidib.wizard.mvc.main.view.component.BulkSwitchNodeOperationsDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkSwitchNodeOperationsDialog
extends EscapeDialog
implements PortScripting,
AccessoryScripting,
NodeTreeScripting,
NodeScripting,
BoosterScripting,
ScriptEngineListener<Scripting> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(BulkSwitchNodeOperationsDialog.class);
    private static final String ENCODED_COLUMN_SPECS = "60dlu, 3dlu, 60dlu, 3dlu, 0dlu:grow";
    private static final String ENCODED_ROW_SPECS = "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref";
    private static final String WORKING_DIR_BULK_SWITCHING_KEY = "bulkSwitching";
    private static final String SCRIPT_EXTENSION = "bidibt";
    private final FileFilter scriptFilter;
    private ValueModel selectedScriptModel = new ValueHolder();
    private ValueModel currentCommandModel = new ValueHolder();
    private JButton startScript;
    private JButton stopScript;
    private JLabel executionStateIconLabel;
    private ImageIcon executionPendingIcon;
    private ImageIcon executionRunningIcon;
    private ImageIcon executionFinishedIcon;
    private ImageIcon executionErrorIcon;
    private ValueModel checkRepeatingModel = new ValueHolder();
    private AtomicBoolean scriptRepeating = new AtomicBoolean(false);
    private final NodeInterface node;
    private ScriptEngine<Scripting> scriptEngine;
    private final SwitchingNodeService switchingNodeService;
    private final BoosterService boosterService;
    private final NodeService nodeService;
    private final DefaultScriptContext scriptContext;
    private final ConsoleService consoleService;

    public BulkSwitchNodeOperationsDialog(DockingDesktop desktop, NodeInterface node, NodeService nodeService, SwitchingNodeService switchingNodeService, BoosterService boosterService, SettingsService settingsService, ConsoleService consoleService) {
        super(JOptionPane.getFrameForComponent((Component)desktop), Resources.getString(BulkSwitchNodeOperationsDialog.class, (String)"title"), true);
        this.node = node;
        this.nodeService = nodeService;
        this.switchingNodeService = switchingNodeService;
        this.boosterService = boosterService;
        this.consoleService = consoleService;
        String scriptDescription = Resources.getString(ScriptPanel.class, (String)"scriptDescription");
        this.scriptFilter = new FileNameExtensionFilter(scriptDescription, SCRIPT_EXTENSION);
        this.scriptContext = new DefaultScriptContext();
        this.executionPendingIcon = ImageUtils.createImageIcon(BulkSwitchNodeOperationsDialog.class, (String)"/icons/accessory-wait.png");
        this.executionRunningIcon = ImageUtils.createImageIcon(BulkSwitchNodeOperationsDialog.class, (String)"/icons/accessory-wait.png");
        this.executionFinishedIcon = ImageUtils.createImageIcon(BulkSwitchNodeOperationsDialog.class, (String)"/icons/accessory-successful.png");
        this.executionErrorIcon = ImageUtils.createImageIcon(BulkSwitchNodeOperationsDialog.class, (String)"/icons/accessory-error.png");
        boolean debugDialog = false;
        Object panel = debugDialog ? new FormDebugPanel() : new JPanel();
        FormBuilder formBuilder = FormBuilder.create().columns(ENCODED_COLUMN_SPECS, new Object[0]).rows(ENCODED_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        JButton btnSelectScript = new JButton(Resources.getString(ScriptPanel.class, (String)"selectScript"));
        btnSelectScript.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        formBuilder.add((Component)btnSelectScript).xy(1, 1);
        JLabel scriptLabel = WizardComponentFactory.createLabel((ValueModel)this.selectedScriptModel);
        formBuilder.add((Component)scriptLabel).xyw(3, 1, 3);
        JCheckBox repeatingCheck = WizardComponentFactory.createCheckBox((ValueModel)this.checkRepeatingModel, (String)Resources.getString(ScriptPanel.class, (String)"repeating"));
        formBuilder.add((Component)repeatingCheck).xyw(1, 3, 3);
        this.startScript = new JButton(Resources.getString(ScriptPanel.class, (String)"startScript"));
        this.startScript.setEnabled(false);
        this.startScript.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        formBuilder.add((Component)this.startScript).xy(1, 5);
        this.stopScript = new JButton(Resources.getString(ScriptPanel.class, (String)"stopScript"));
        this.stopScript.setEnabled(false);
        this.stopScript.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        formBuilder.add((Component)this.stopScript).xy(3, 5);
        this.executionStateIconLabel = new JLabel();
        formBuilder.add((Component)this.executionStateIconLabel).xy(5, 5);
        JLabel currentCommandLabel = WizardComponentFactory.createLabel((ValueModel)this.currentCommandModel);
        formBuilder.add((Component)currentCommandLabel).xyw(1, 7, 5);
        this.checkRepeatingModel.addValueChangeListener((PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        JPanel mainPanel = formBuilder.border((Border)Paddings.DIALOG).build();
        JButton cancelButton = new JButton(Resources.getString(BulkSwitchNodeOperationsDialog.class, (String)"cancel"));
        cancelButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        JPanel buttonBar = new ButtonBarBuilder().addButton((JComponent)cancelButton).build();
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add((Component)buttonBar, "East");
        southPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)mainPanel, "Center");
        this.getContentPane().add((Component)southPanel, "South");
        this.getContentPane().setPreferredSize(new Dimension(400, 300));
        this.scriptEngine = new ScriptEngine((Scripting)this, (ApplicationContext)this.scriptContext);
        this.scriptEngine.addScriptEngineListener((ScriptEngineListener)this);
    }

    public void showDialog() {
        this.pack();
        this.setLocationRelativeTo((Component)this.getParent());
        this.setMinimumSize(this.getSize());
        this.setVisible(true);
    }

    private void fireCancel(NodeInterface node) {
        LOGGER.info("Stop the script on press cancel button.");
        this.stopScript();
    }

    private void stopScript() {
        LOGGER.info("Stop the script.");
        this.scriptEngine.stopScript();
    }

    public void scriptStatusChanged(ScriptStatus scriptStatus) {
        SwingUtilities.invokeLater(() -> {
            switch (7.$SwitchMap$org$bidib$wizard$api$script$ScriptStatus[scriptStatus.ordinal()]) {
                case 1: {
                    this.startScript.setEnabled(false);
                    this.stopScript.setEnabled(true);
                    this.executionStateIconLabel.setIcon(this.executionRunningIcon);
                    break;
                }
                case 2: 
                case 3: {
                    this.startScript.setEnabled(true);
                    this.stopScript.setEnabled(false);
                    this.executionStateIconLabel.setIcon(this.executionFinishedIcon);
                    break;
                }
                case 4: 
                case 5: {
                    this.startScript.setEnabled(true);
                    this.stopScript.setEnabled(false);
                    this.executionStateIconLabel.setIcon(this.executionErrorIcon);
                    break;
                }
            }
            this.currentCommandChanged(null);
        });
    }

    private void prepareScript(String fileName) throws IOException {
        Path fFilePath = Paths.get(fileName, new String[0]);
        SwitchFunctionsScriptCommandFactory factory = new SwitchFunctionsScriptCommandFactory(this.consoleService);
        LinkedList scriptCommands = new LinkedList();
        try (Scanner scanner = new Scanner(fFilePath, StandardCharsets.UTF_8);){
            while (scanner.hasNextLine()) {
                this.processLine(scanner.nextLine().trim(), factory, scriptCommands);
            }
        }
        LOGGER.info("Prepared list of commands: {}", scriptCommands);
        this.scriptEngine.setScriptCommands(scriptCommands);
    }

    private void processLine(String line, SwitchFunctionsScriptCommandFactory factory, List<ScriptCommand<Scripting>> scriptCommands) {
        LOGGER.info("Process line: {}", (Object)line);
        if (line.startsWith("#") || StringUtils.isBlank((CharSequence)line)) {
            LOGGER.info("Skip comment or empty line.");
        } else {
            LOGGER.info("Current line: {}", (Object)line);
            ScriptCommand command = factory.parse(line);
            if (command != null) {
                scriptCommands.add((ScriptCommand<Scripting>)command);
            }
        }
    }

    public void sendPortStatusAction(SwitchingNodeInterface node, LcOutputType lcOutputType, int portNumber, BidibStatus portStatus) {
        SwitchingNodeInterface selectedNode = node != null ? node : this.node.getSwitchingNode();
        SwitchPort port = null;
        switch (7.$SwitchMap$org$bidib$jbidibc$messages$enums$LcOutputType[lcOutputType.ordinal()]) {
            case 1: {
                SwitchPortStatus switchPortStatus = (SwitchPortStatus)portStatus;
                SwitchPort switchPort = new SwitchPort();
                switchPort.setId(portNumber);
                switchPort.setStatus((BidibStatus)switchPortStatus);
                port = switchPort;
                break;
            }
            case 2: {
                SwitchPortStatus switchPairPortStatus = (SwitchPortStatus)portStatus;
                SwitchPairPort switchPairPort = new SwitchPairPort();
                switchPairPort.setId(portNumber);
                switchPairPort.setStatus((BidibStatus)switchPairPortStatus);
                port = switchPairPort;
                break;
            }
            case 3: {
                SoundPortStatus soundPortStatus = (SoundPortStatus)portStatus;
                SoundPort soundPort = new SoundPort();
                soundPort.setId(portNumber);
                soundPort.setStatus((BidibStatus)soundPortStatus);
                port = soundPort;
                break;
            }
            case 4: {
                LightPortStatus lightPortStatus = (LightPortStatus)portStatus;
                LightPort lightPort = new LightPort();
                lightPort.setId(portNumber);
                lightPort.setStatus((BidibStatus)lightPortStatus);
                port = lightPort;
                break;
            }
            default: {
                LOGGER.warn("Unsupported port type: {}", (Object)lcOutputType);
            }
        }
        if (port != null) {
            this.switchingNodeService.setPortStatus("main", selectedNode, port);
        }
    }

    public void sendPortValueAction(SwitchingNodeInterface node, LcOutputType lcOutputType, int port, int portValue) {
        SwitchingNodeInterface selectedNode = node != null ? node : this.node.getSwitchingNode();
        switch (7.$SwitchMap$org$bidib$jbidibc$messages$enums$LcOutputType[lcOutputType.ordinal()]) {
            case 5: {
                ServoPort servoPort = new ServoPort();
                servoPort.setId(port);
                servoPort.setValue(Integer.valueOf(portValue));
                this.switchingNodeService.setPortStatus("main", selectedNode, (Port)servoPort);
                break;
            }
            case 6: {
                MotorPort motorPort = new MotorPort();
                motorPort.setId(port);
                motorPort.setValue(Integer.valueOf(portValue));
                this.switchingNodeService.setPortStatus("main", selectedNode, (Port)motorPort);
                break;
            }
        }
    }

    public void currentCommandChanged(ScriptCommand<Scripting> command) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.currentCommandModel.setValue((Object)(command != null ? command.toString() : null));
        } else {
            try {
                SwingUtilities.invokeAndWait((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (InterruptedException | InvocationTargetException e) {
                LOGGER.warn("Update current command failed.", (Throwable)e);
            }
        }
    }

    public void setActiveAspect(SwitchingNodeInterface node, int accessoryNumber, int aspectNumber) {
        LOGGER.info("Activate the aspect, node: {}, accessoryNumber: {}, aspectNumber: {}", new Object[]{node, accessoryNumber, aspectNumber});
        Accessory accessory = AccessoryListUtils.findAccessoryByAccessoryNumber((Iterable)node.getNode().getAccessories(), (int)accessoryNumber);
        this.switchingNodeService.setAccessoryAspect("main", node, accessory, aspectNumber);
    }

    public AccessoryExecutionState getAccessoryExecutionState(SwitchingNodeInterface node, int accessoryNumber) {
        return null;
    }

    public List<NodeInterface> getNodesByVidAndPid(int vid, int pid) {
        List nodes = this.nodeService.getAllNodes("main");
        return nodes.stream().filter(n -> NodeUtils.isMatchingVidAndPid((long)n.getUniqueId(), (int)vid, (int)pid)).collect(Collectors.toList());
    }

    public void setCv(Long uuid, CvType ... cvTypes) {
    }

    public List<ConfigurationVariable> getCv(Long uniqueId, CvType ... cvTypes) {
        LOGGER.info("Get the CV directly from the node, uniqueId: {}, cvTypes: {}", (Object)uniqueId, (Object)cvTypes);
        return Collections.emptyList();
    }

    public void setFeature(Long uuid, FeatureType ... features) {
    }

    public void setLabel(Long uuid, TargetType portType) {
    }

    public void setMacro(Long uuid, Macro macro) {
    }

    public void setAccessory(Long uuid, Accessory accessory) {
    }

    public boolean isNodeHasRestartPending(Long uuid) {
        return false;
    }

    public void resetNode(Long uuid) {
    }

    public void reselectNode(Long uuid) {
    }

    public void setPortConfig(Long uniqueId, TargetType targetType, Map<Byte, PortConfigValue<?>> portConfig) {
        LOGGER.info("Set the port scripting, uuid: {}, targetType: {}, portConfig: {}", new Object[]{ByteUtils.formatHexUniqueId((Long)uniqueId), targetType, portConfig});
        NodeInterface node = this.nodeService.getNode("main", uniqueId.longValue());
        int portId = targetType.getPortNum();
        ScriptingTargetType scriptingTargetType = targetType.getScriptingTargetType();
        SwitchPairPort port = null;
        switch (7.$SwitchMap$org$bidib$wizard$common$script$node$types$ScriptingTargetType[scriptingTargetType.ordinal()]) {
            case 1: {
                port = new SwitchPairPort();
                port.setId(portId);
                break;
            }
        }
        this.switchingNodeService.setPortConfig("main", node.getSwitchingNode(), (Port)port, (LcOutputType)null, portConfig);
    }

    public void assertPortType(Long uuid, TargetType portType) {
    }

    public void setBoosterStatus(BoosterNodeInterface boosterNode, BoosterStatus requestedStatus) {
        LOGGER.info("Set the booster status, node: {}, requestedStatus: {}", (Object)boosterNode, (Object)requestedStatus);
        this.boosterService.setBoosterState("main", boosterNode, requestedStatus);
    }

    public void setIdentifyState(Long uniqueId, IdentifyState identifyState) {
        NodeInterface node = this.nodeService.getNode("main", uniqueId.longValue());
        this.nodeService.identify("main", node, identifyState);
    }

    public IdentifyState queryIdentifyState(Long uniqueId) {
        NodeInterface node = this.nodeService.getNode("main", uniqueId.longValue());
        return node.getIdentifyState();
    }

    public String setString(Long uniqueId, int namespace, int index, String value) {
        return null;
    }

    public String getString(Long uniqueId, int namespace, int index) {
        return null;
    }

    public NodeInterface getNodesByUniqueId(long uniqueId) {
        return null;
    }
}

