/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.api.model.MacroRef;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.client.common.controller.NodeSelectionProvider;
import org.bidib.wizard.client.common.table.AbstractStatusEmptyTable;
import org.bidib.wizard.client.common.view.listener.ButtonListener;
import org.bidib.wizard.client.common.view.renderer.MacroRefRenderer;
import org.bidib.wizard.client.common.view.renderer.MacroRenderer;
import org.bidib.wizard.client.common.view.slider.SliderRenderer;
import org.bidib.wizard.model.status.AccessoryAspectStatus;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.mvc.main.model.AccessoryTableModel;
import org.bidib.wizard.mvc.main.view.panel.AspectTable;
import org.bidib.wizard.mvc.main.view.table.ComboBoxWithButtonEditor;
import org.bidib.wizard.mvc.main.view.table.ComboBoxWithButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AspectTable
extends AbstractStatusEmptyTable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AspectTable.class);
    private final NodeSelectionProvider nodeSelectionProvider;
    private final AccessoryTableModel tableModel;

    public AspectTable(AccessoryTableModel tableModel, String emptyTableString, NodeSelectionProvider mainModel) {
        super((TableModel)tableModel, emptyTableString);
        this.tableModel = tableModel;
        this.nodeSelectionProvider = mainModel;
    }

    public void adjustRowHeight() {
        SliderRenderer sliderEditor = new SliderRenderer(0, 255, 10);
        int rowHeight = sliderEditor.getTableCellRendererComponent((JTable)this, (Object)Integer.valueOf((int)1), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().height + 6;
        LOGGER.info("Set row height: {}", (Object)rowHeight);
        this.setRowHeight(rowHeight);
    }

    public TableCellEditor getCellEditor(int row, int column) {
        TableCellEditor result = super.getCellEditor(row, column);
        switch (column) {
            case 1: {
                NodeInterface node = this.nodeSelectionProvider.getSelectedNode();
                Macro[] macros = node.getMacros().toArray(new Macro[0]);
                MacroRef[] macroRefs = new MacroRef[macros.length];
                int index = 0;
                for (Macro macro : macros) {
                    macroRefs[index] = new MacroRef(Integer.valueOf(macro.getId()));
                    ++index;
                }
                JComboBox<MacroRef> comboboxMacroRef = new JComboBox<MacroRef>(macroRefs);
                comboboxMacroRef.setRenderer((ListCellRenderer<MacroRef>)new MacroRefRenderer(macros));
                result = new /* Unavailable Anonymous Inner Class!! */;
                LOGGER.info("Prepared the MacroRef editor.");
                break;
            }
            case 2: {
                ComboBoxWithButtonEditor editor = new ComboBoxWithButtonEditor((Object[])this.getActions((BidibStatus)AccessoryAspectStatus.START), ">");
                editor.addButtonListener((ButtonListener)this.tableModel);
                result = editor;
                break;
            }
        }
        return result;
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        Object result = null;
        switch (column) {
            case 0: {
                result = new AccessoryLabelRenderer();
                break;
            }
            case 1: {
                NodeInterface node = this.nodeSelectionProvider.getSelectedNode();
                2 macroRenderer = new /* Unavailable Anonymous Inner Class!! */;
                macroRenderer.setRenderer((ListCellRenderer)new MacroRenderer());
                result = macroRenderer;
                break;
            }
            case 2: {
                result = new ComboBoxWithButtonRenderer((Object[])this.getActions((BidibStatus)AccessoryAspectStatus.START), ">");
                break;
            }
            default: {
                result = super.getCellRenderer(row, column);
            }
        }
        return result;
    }
}

