/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.TicksAware;
import org.bidib.wizard.mvc.common.view.editor.IntegerEditor;

public class PortTicksEditor
extends IntegerEditor {
    private static final long serialVersionUID = 1L;
    private JPanel comp;
    private JLabel value;
    private final int portInstanceColumn;

    public PortTicksEditor(int portInstanceColumn, int min, int max) {
        super(min, max);
        this.portInstanceColumn = portInstanceColumn;
        this.comp = new JPanel();
        this.comp.setLayout(new BorderLayout());
        this.value = new JLabel();
        this.value.setMinimumSize(new Dimension(60, 12));
        this.value.setPreferredSize(new Dimension(70, 12));
        this.comp.add((Component)this.value, "East");
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Integer ticks = null;
        Port port = (Port)table.getModel().getValueAt(row, this.portInstanceColumn);
        if (port instanceof TicksAware) {
            TicksAware ticksAware = (TicksAware)port;
            value = ticksAware.getTicks();
            ticks = ticksAware.getTicks();
        }
        Component superComp = super.getTableCellEditorComponent(table, value, isSelected, row, column);
        if (ticks != null) {
            this.value.setText(String.format("(%d ms)", ticks * 10));
        } else {
            this.value.setText(null);
        }
        this.comp.add(superComp, "Center");
        return this.comp;
    }
}

