/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.table;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.bidib.wizard.model.ports.SoundPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoundPortTableCellRenderer
extends DefaultTableCellRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SoundPortTableCellRenderer.class);
    private static final long serialVersionUID = 1L;
    private final int forColumn;

    public SoundPortTableCellRenderer(int forColumn) {
        this.forColumn = forColumn;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, null, isSelected, hasFocus, row, column);
        if (value instanceof SoundPort) {
            SoundPort soundPort = (SoundPort)value;
            boolean enabled = soundPort.isEnabled();
            this.setEnabled(enabled);
            this.setIcon(null);
            switch (this.forColumn) {
                case 1: {
                    this.setText(Integer.toString(soundPort.getPulseTime()));
                    break;
                }
                default: {
                    LOGGER.warn("Invalid renderer configuration detected, column: {}", (Object)column);
                    break;
                }
            }
        } else {
            this.setEnabled(false);
            this.setText(null);
        }
        return this;
    }
}

