/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.tips.controller;

import com.jidesoft.tipoftheday.TipOfTheDaySource;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import org.apache.commons.lang3.time.StopWatch;
import org.bidib.wizard.core.service.SettingsService;
import org.bidib.wizard.mvc.main.view.MainView;
import org.bidib.wizard.mvc.tips.controller.FileTipOfTheDaySource;
import org.bidib.wizard.mvc.tips.controller.TipOfDayClosedListener;
import org.bidib.wizard.mvc.tips.view.TipOfDayView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TipOfDayController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TipOfDayController.class);
    @Autowired
    private SettingsService settingsService;
    private final MainView mainView;

    public TipOfDayController(MainView mainView) {
        this.mainView = mainView;
    }

    public void start(TipOfDayClosedListener listener) {
        TipOfDayView todView = new TipOfDayView();
        TipOfTheDaySource tipOfTheDaySource = this.getTipOfDaySource();
        todView.showTipsOfTheDay(this.mainView.getFrame(), listener, this.settingsService, tipOfTheDaySource);
    }

    private TipOfTheDaySource getTipOfDaySource() {
        TipOfTheDaySource source = null;
        try {
            StopWatch sw = StopWatch.createStarted();
            Locale locale = Locale.getDefault();
            String lang = locale.getLanguage();
            source = this.findTipOfDaySource(lang);
            if (source == null) {
                source = this.findTipOfDaySource("en");
            }
            sw.stop();
            LOGGER.info("Load tips data took: {}", (Object)sw.toString());
        }
        catch (Exception ex) {
            LOGGER.warn("Get tips failed.", (Throwable)ex);
        }
        return source;
    }

    private TipOfTheDaySource findTipOfDaySource(String lang) {
        String[] searchPaths;
        FileTipOfTheDaySource source = null;
        String filename = "tips_" + lang + ".properties";
        LOGGER.info("Prepared tips file: {}", (Object)filename);
        String installationPath = this.settingsService.getInstallationPath();
        LOGGER.info("Current installation path: {}", (Object)installationPath);
        File file = new File(installationPath);
        file = new File(file.getAbsoluteFile(), "data/tips");
        String labelPath = this.settingsService.getMiscSettings().getBidibConfigDir();
        File searchPathLabelPath = new File(labelPath, "data/tips");
        for (String searchPath : searchPaths = new String[]{searchPathLabelPath.getAbsolutePath(), file.getAbsolutePath(), "classpath:/tips"}) {
            if (searchPath.startsWith("classpath:")) {
                int beginIndex = "classpath:".length();
                String lookup = searchPath.substring(beginIndex) + "/" + filename;
                LOGGER.info("Lookup tips file internally: {}", (Object)lookup);
                URL pathString = TipOfDayController.class.getResource(lookup);
                LOGGER.info("Prepared pathString: {}", (Object)pathString);
                if (pathString == null) {
                    LOGGER.info("No resource for lookup '{}' found.", (Object)lookup);
                    continue;
                }
                try {
                    source = new FileTipOfTheDaySource(TipOfDayController.class.getResourceAsStream(lookup));
                    break;
                }
                catch (Exception ex) {
                    LOGGER.warn("Load tips from classpath failed.", (Throwable)ex);
                    continue;
                }
            }
            LOGGER.info("Search for files in searchPath: {}", (Object)searchPath);
            File tipsFile = new File(searchPath, filename.toString());
            if (!tipsFile.exists()) continue;
            LOGGER.info("Found tips file: {}", (Object)tipsFile.getAbsolutePath());
            try (FileInputStream is = new FileInputStream(tipsFile);){
                source = new FileTipOfTheDaySource((InputStream)is);
                break;
            }
            catch (Exception ex) {
                LOGGER.warn("Load tips from file failed.", (Throwable)ex);
            }
        }
        return source;
    }
}

