/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.worklist.controller.actions;

import com.vlsolutions.swing.docking.DockingDesktop;
import javax.swing.JOptionPane;
import org.bidib.wizard.api.event.FirmwareUpdateWorkListItemEvent;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.firmwarerepo.core.NodeFirmwareRepoService;
import org.bidib.wizard.mvc.worklist.controller.ActionAbortedException;
import org.bidib.wizard.mvc.worklist.controller.actions.WorkListAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class DownloadFirmwareAction
implements WorkListAction<FirmwareUpdateWorkListItemEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadFirmwareAction.class);
    private final ApplicationContext applicationContext;

    public DownloadFirmwareAction(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void apply(DockingDesktop desktop, FirmwareUpdateWorkListItemEvent actionEvent) throws ActionAbortedException {
        LOGGER.info("Let the node firmware repo service download the new firmware.");
        int result = JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(desktop.getRootPane()), Resources.getString(DownloadFirmwareAction.class, (String)"download-new-firmware.text"), Resources.getString(DownloadFirmwareAction.class, (String)"download-new-firmware.title"), 2);
        if (result != 0) {
            LOGGER.info("Download the new firmware to the local repo dialog was cancelled.");
            throw new ActionAbortedException("Download the new firmware to the local repo dialog was cancelled.");
        }
        LOGGER.info("Download the new firmware to the local repo.");
        NodeFirmwareRepoService nodeFirmwareRepoService = (NodeFirmwareRepoService)this.applicationContext.getBean(NodeFirmwareRepoService.class);
        nodeFirmwareRepoService.downloadNewRemoteFirmwareAvailable();
    }
}

