package org.bidib.wizard.mvc.main.view.panel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.swing.JPanel;

import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.ServoPortValueListener;
import org.bidib.wizard.client.common.controller.NodeSelectionProvider;
import org.bidib.wizard.client.common.model.ServoPortTableModel;
import org.bidib.wizard.client.common.model.listener.ServoPortModelListener;
import org.bidib.wizard.client.common.table.AbstractHierarchicalEmptyTable.PackLastColumnEnum;
import org.bidib.wizard.client.common.table.AbstractPortHierarchicalTable;
import org.bidib.wizard.client.common.table.ServoPortTable;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.client.common.view.menu.listener.PortListMenuListener;
import org.bidib.wizard.core.service.SettingsService;
import org.bidib.wizard.model.ports.ServoPort;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.model.status.ServoPortStatus;
import org.bidib.wizard.mvc.main.controller.ServoPortPanelController;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabComponentCreator;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jidesoft.grid.TableColumnChooser;

import io.reactivex.rxjava3.subjects.PublishSubject;

public class ServoPortListPanel
    extends
    SimpleHierarchicalPortListPanel<ServoPortTableModel, ServoPortStatus, ServoPort, ServoPortValueListener, ServoPortModelListener>
    implements TabVisibilityProvider, TabPanelProvider, TabComponentCreator {
    private static final long serialVersionUID = 1L;

    private static final Logger LOGGER = LoggerFactory.getLogger(ServoPortListPanel.class);

    private final MainModel mainModel;

    private final TabVisibilityListener tabVisibilityListener;

    private final SettingsService settingsService;

    public ServoPortListPanel(final ServoPortPanelController controller, final ServoPortTableModel tableModel,
        final MainModel mainModel, final SettingsService settingsService,
        final TabVisibilityListener tabVisibilityListener,
        final PublishSubject<PortConfigChangeEvent> portConfigChangeEventSubject) {
        super(tableModel, Resources.getString(ServoPortListPanel.class, "emptyTable"), portConfigChangeEventSubject,
            mainModel);
        this.mainModel = mainModel;
        this.tabVisibilityListener = tabVisibilityListener;
        this.settingsService = settingsService;

        // if (!this.settingsService.getWizardSettings().isPowerUser()) {
        TableColumnChooser.hideColumn(table, ServoPortTableModel.COLUMN_TEST);
        // }

    }

    @Override
    protected AbstractPortHierarchicalTable<ServoPort> createPortTable(
        ServoPortTableModel tableModel, String emptyTableText) {

        return new ServoPortTable(tableModel, emptyTableText);
    }

    @Override
    protected void createTable(
        final ServoPortTableModel tableModel, String emptyTableText,
        final PublishSubject<PortConfigChangeEvent> portConfigChangeEventSubject,
        final NodeSelectionProvider nodeSelectionProvider) {

        super.createTable(tableModel, emptyTableText, portConfigChangeEventSubject, nodeSelectionProvider);

        // create the portlist menu listener to handle the port menu
        final PortListMenuListener portListMenuListener =
            createPortListMenuListener(this.table, nodeSelectionProvider, null);
        table.setPortListMenuListener(portListMenuListener);

    }

    @Override
    public JPanel getComponent() {
        return this;
    }

    @Override
    public Object getCreator() {
        return this;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof TabComponentCreator) {
            TabComponentCreator creator = (TabComponentCreator) other;
            // TODO if more than a single instance is available this must be changed
            if (creator.getCreator() instanceof ServoPortListPanel) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    protected PackLastColumnEnum isPackLastColumn() {
        return PackLastColumnEnum.VARIABLE;
    }

    @Override
    protected void processListChanged() {
        super.processListChanged();

        tabVisibilityListener.setTabVisible(this, isTabVisible());
    }

    @Override
    public Class<?> getPortClass() {
        return ServoPort.class;
    }

    @Override
    public boolean isTabVisible() {
        final NodeInterface node = mainModel.getSelectedNode();
        if (node != null) {
            boolean isTabVisible = node.hasServoPorts();
            LOGGER.debug("Check if tab is visible: {}", isTabVisible);
            return isTabVisible;
        }
        return false;
    }

    @Override
    protected List<ServoPort> getPorts() {
        LOGGER.info("Get servo ports.");
        final NodeInterface node = mainModel.getSelectedNode();
        if (node != null) {
            List<ServoPort> ports = new ArrayList<>();
            ports.addAll(node.getServoPorts());
            return ports;
        }
        return Collections.emptyList();
    }

    public void refreshView() {
        listChanged();
    }
}
