package org.bidib.wizard.startup;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

import org.bidib.jbidibc.core.schema.BidibFactory;
import org.bidib.jbidibc.core.schema.DecoderVendorFactory;
import org.bidib.jbidibc.core.schema.bidiblabels.LabelFactory;
import org.bidib.jbidibc.exchange.vendorcv.VendorCvFactory;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(1)
public class InitLegacySingletonsApplicationRunner implements ApplicationRunner {

    private static final Logger LOGGER = LoggerFactory.getLogger(InitLegacySingletonsApplicationRunner.class);

    private final ScheduledExecutorService initLegacySingletonsWorkers =
        Executors
            .newScheduledThreadPool(1,
                new ThreadFactoryBuilder().setNameFormat("initLegacySingletonsWorkers-thread-%d").build());

    @Override
    public void run(ApplicationArguments args) {
        LOGGER.info("Initialize the legacy singletons.");

        initLegacySingletonsWorkers.submit(() -> {

            VendorCvFactory.initialize();

            LabelFactory.initJaxbContext();

            DecoderVendorFactory.getDecoderVendors();

            BidibFactory.getFeatureCodes();

            LOGGER.info("Initialize the legacy singletons has finished.");

            initLegacySingletonsWorkers.shutdown();
        });

    }
}
