/*
 * @(#)AbstractDemo.java 8/24/2009
 *
 * Copyright 2002 - 2009 JIDE Software Inc. All rights reserved.
 */

package org.bidib.wizard.demo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Event;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;

import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

import com.jidesoft.icons.JideIconsFactory;
import com.jidesoft.pane.CollapsiblePane;
import com.jidesoft.pane.CollapsiblePanes;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.ProductNames;
import com.jidesoft.utils.SystemInfo;

/**
 * A template to create additional demo module.
 */
abstract public class AbstractDemo implements Demo, ProductNames {
    public AbstractDemo() {
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public int hashCode() {
        return getName().hashCode();
    }

    @Override
    public String toString() {
        return getName();
    }

    @Override
    public Component getOptionsPanel() {
        return null;
    }

    @Override
    public boolean isCommonOptionsPaneVisible() {
        return true;
    }

    @Override
    public void dispose() {
    }

    public static JFrame showAsFrame(final Demo demo) {
        final JFrame frame =
            new JFrame(MessageFormat
                .format("Demo.title", demo.getName(), Lm.getProductVersion(), SystemInfo.getJavaVersion()));
        frame.addWindowListener(new WindowAdapter() {
            @Override
            public void windowClosing(WindowEvent e) {
                demo.dispose();
            }
        });
        frame.setIconImage(JideIconsFactory.getImageIcon(JideIconsFactory.JIDE32).getImage());
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        Component demoPanel = demo.getDemoPanel();
        JComponent pane = createOptionsPanel(frame, demo, demoPanel);

        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add(demoPanel, BorderLayout.CENTER);

        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add(panel, BorderLayout.CENTER);
        if (pane != null) {
            frame.getContentPane().add(new JScrollPane(pane), BorderLayout.BEFORE_LINE_BEGINS);
        }

        // com.jidesoft.swing.JideSwingUtilities.traceFocus();

        frame
            .getRootPane().getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(
                KeyStroke.getKeyStroke(KeyEvent.VK_G, Event.CTRL_MASK | Event.SHIFT_MASK | Event.ALT_MASK), "printMem");
        frame.getRootPane().getActionMap().put("printMem", new AbstractAction() {
            @Override
            public void actionPerformed(ActionEvent e) {
                com.jidesoft.swing.JideSwingUtilities.runGCAndPrintFreeMemory();
            }
        });

        frame.pack();

        JideSwingUtilities.globalCenterWindow(frame);
        frame.setVisible(true);
        frame.toFront();
        return frame;
    }

    protected static JComponent createOptionsPanel(JFrame parentFrame, Demo demo, Component demoPanel) {
        CollapsiblePanes panes = new CollapsiblePanes();

        return panes;
    }

    private static CollapsiblePane createCollapsiblePane(String title) {
        return new CollapsiblePane(title);
    }

    @Override
    public String[] getDemoSource() {
        return new String[] { getClass().getName() + ".java" };
    }

    @Override
    public String getDemoFolder() {
        return "";
    }

    @Override
    public int getAttributes() {
        return ATTRIBUTE_NONE;
    }

    // public static JButton createBrowseSourceCodeButton(final JFrame frame, final Demo demo) {
    // return new JButton(new AbstractAction(Resource.RB.getString("Demo.browseSourceCode")) {
    // @Override
    // public void actionPerformed(ActionEvent e) {
    // StandardDialog dialog =
    // new StandardDialog(frame, Resource.RB.getString("Demo.browseSourceCode"), false) {
    // @Override
    // public JComponent createBannerPanel() {
    // return null;
    // }
    //
    // @Override
    // public JComponent createContentPanel() {
    // JPanel panel = new JPanel(new BorderLayout());
    // panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    // panel.add(createSourceCodePanel(demo.getDemoSource()));
    // panel.setPreferredSize(new Dimension(600, 500));
    // return panel;
    // }
    //
    // @Override
    // public ButtonPanel createButtonPanel() {
    // JButton closeButton = new JButton();
    // closeButton.setName(CLOSE);
    // closeButton
    // .setAction(new AbstractAction(UIDefaultsLookup.getString("OptionPane.okButtonText")) {
    // @Override
    // public void actionPerformed(ActionEvent e) {
    // setDialogResult(RESULT_AFFIRMED);
    // setVisible(false);
    // dispose();
    // }
    // });
    //
    // setDefaultCancelAction(closeButton.getAction());
    // return null;
    // }
    // };
    // dialog.pack();
    // dialog.setLocationRelativeTo(frame);
    // dialog.setVisible(true);
    // }
    // });
    // }

    // public static JComponent createSourceCodePanel(String[] sourceCode) {
    // DocumentPane pane = new DocumentPane();
    // for (String s : sourceCode) {
    // pane.openDocument(new DocumentComponent(createTextComponent(s), s));
    // }
    // pane.setTabbedPaneCustomizer(new DocumentPane.TabbedPaneCustomizer() {
    // @Override
    // public void customize(JideTabbedPane tabbedPane) {
    // tabbedPane.setTabPlacement(JideTabbedPane.BOTTOM);
    // }
    // });
    // return pane;
    // }

    // private static JPanel createSearchableTextArea(final JTextComponent textComponent) {
    // final JPanel panel = new JPanel(new BorderLayout());
    // panel.add(new JScrollPane(textComponent), BorderLayout.CENTER);
    // Searchable searchable = SearchableUtils.installSearchable(textComponent);
    // searchable.setRepeats(true);
    // SearchableBar searchableBar = SearchableBar.install(searchable, KeyStroke.getKeyStroke(KeyEvent.VK_F,
    // KeyEvent.CTRL_DOWN_MASK), new SearchableBar.Installer() {
    // public void openSearchBar(SearchableBar searchableBar) {
    // panel.add(searchableBar, BorderLayout.AFTER_LAST_LINE);
    // panel.invalidate();
    // panel.revalidate();
    // }
    //
    // public void closeSearchBar(SearchableBar searchableBar) {
    // panel.remove(searchableBar);
    // panel.invalidate();
    // panel.revalidate();
    // }
    // });
    // return panel;
    // }

    // public static JComponent createTextComponent(String fileName) {
    // CodeEditor area = new CodeEditor();
    // // area.setFont(new Font("Monospaced", Font.PLAIN, 12));
    // SyntaxDocument doc = new SyntaxDocument();
    // try {
    // // try to start reading
    // InputStream in = AbstractDemo.class.getResourceAsStream(fileName);
    // if (in != null) {
    // byte[] buff = new byte[4096];
    // int nch;
    // while ((nch = in.read(buff, 0, buff.length)) != -1) {
    // doc.insertString(doc.getLength(), new String(buff, 0, nch), null);
    // }
    // area.setDocument(doc);
    // area.setTokenMarker(new JavaTokenMarker());
    // }
    // else {
    // doc.setTokenMarker(null);
    // area.setText(Resource.RB.getString("Demo.copySourceCode.msg"));
    // }
    // }
    // catch (Exception e) {
    // // ignore
    // }
    // return area;
    // }
}
