/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.locolist.controller;

import com.jgoodies.common.collect.ArrayListModel;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingConstants;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.DockingUtilities;
import com.vlsolutions.swing.docking.RelativeDockablePosition;
import com.vlsolutions.swing.docking.TabbedDockableContainer;
import com.vlsolutions.swing.docking.event.DockableStateChangeListener;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.node.ConfigurationVariable;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.enums.AddressTypeEnum;
import org.bidib.jbidibc.messages.enums.CsQueryTypeEnum;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.model.CommandStationNodeInterface;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.api.model.listener.NodeSelectionListener;
import org.bidib.wizard.api.service.node.CommandStationService;
import org.bidib.wizard.api.utils.NodeUtils;
import org.bidib.wizard.client.common.view.DockKeys;
import org.bidib.wizard.client.common.view.DockUtils;
import org.bidib.wizard.common.context.DefaultApplicationContext;
import org.bidib.wizard.config.LocoControllerFactory;
import org.bidib.wizard.config.PomProgrammerControllerFactory;
import org.bidib.wizard.core.model.connection.MessageAdapter;
import org.bidib.wizard.core.service.ConnectionService;
import org.bidib.wizard.core.service.LocoService;
import org.bidib.wizard.core.service.node.BidibNodeService;
import org.bidib.wizard.model.locolist.LocoListModel;
import org.bidib.wizard.model.status.DirectionStatus;
import org.bidib.wizard.model.status.SpeedSteps;
import org.bidib.wizard.mvc.loco.controller.LocoController;
import org.bidib.wizard.mvc.locolist.controller.LocoTableController;
import org.bidib.wizard.mvc.locolist.controller.listener.LocoTableControllerListener;
import org.bidib.wizard.mvc.locolist.model.LocoLibraryModel;
import org.bidib.wizard.mvc.locolist.model.LocoTableModel;
import org.bidib.wizard.mvc.locolist.view.LocoTableView;
import org.bidib.wizard.mvc.main.controller.MainControllerInterface;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.pom.controller.PomProgrammerController;
import org.bidib.wizard.mvc.pom.controller.listener.PomProgrammerControllerListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class LocoTableController
implements LocoTableControllerListener,
PropertyChangeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocoTableController.class);
    private final JFrame parent;
    private final MainModel mainModel;
    private MainControllerInterface mainController;
    private LocoTableView locoTableView;
    private LocoTableModel locoTableModel;
    private NodeInterface selectedNode;
    @Autowired
    private BidibNodeService bidibNodeService;
    @Autowired
    private ConnectionService connectionService;
    @Autowired
    private CommandStationService commandStationService;
    @Autowired
    private LocoService locoService;
    private MessageAdapter messageAdapter;
    private LocoLibraryModel locoLibrary;
    private final ScheduledExecutorService locoLibraryWorker = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("locoLibraryWorkers-thread-%d").build());

    public LocoTableController(NodeInterface node, JFrame parent, MainModel mainModel) {
        this.parent = parent;
        this.mainModel = mainModel;
    }

    public void start(DockingDesktop desktop, MainControllerInterface mainController) {
        String searchKey = "LocoTableView";
        LOGGER.info("Search for view with key: {}", (Object)searchKey);
        Dockable view = desktop.getContext().getDockableByKey(searchKey);
        if (view != null) {
            LOGGER.info("Select the existing loco list table view.");
            DockUtils.selectWindow((Dockable)view);
            return;
        }
        this.mainController = mainController;
        LOGGER.info("Create new LocoTableView.");
        ArrayListModel locoList = this.locoService.getLocoList();
        this.locoTableModel = new LocoTableModel((LocoTableControllerListener)this, locoList);
        this.locoTableView = new LocoTableView((LocoTableControllerListener)this, this.locoTableModel);
        DockableState[] dockables = desktop.getDockables();
        LOGGER.info("Current dockables: {}", new Object[]{dockables});
        if (dockables.length > 1) {
            DockableState boosterTableView = null;
            for (DockableState dockable : dockables) {
                if (!DockKeys.DOCKKEY_BOOSTER_TABLE_VIEW.equals((Object)dockable.getDockable().getDockKey())) continue;
                LOGGER.info("Found the booster table view dockable.");
                boosterTableView = dockable;
                break;
            }
            Dockable dock = desktop.getDockables()[1].getDockable();
            if (boosterTableView != null) {
                LOGGER.info("Add the loco panel view to the booster table view panel.");
                dock = boosterTableView.getDockable();
                TabbedDockableContainer container = DockingUtilities.findTabbedDockableContainer((Dockable)dock);
                int order = 0;
                if (container != null) {
                    order = container.getTabCount();
                }
                LOGGER.info("Add new loco panel at order: {}", (Object)order);
                desktop.createTab(dock, (Dockable)this.locoTableView, order, true);
                desktop.setDockableHeight((Dockable)this.locoTableView, 0.3);
            } else {
                desktop.split(dock, (Dockable)this.locoTableView, DockingConstants.SPLIT_RIGHT);
                desktop.setDockableHeight((Dockable)this.locoTableView, 0.3);
            }
        } else {
            desktop.addDockable((Dockable)this.locoTableView, RelativeDockablePosition.RIGHT);
        }
        1 nodeListListener = new /* Unavailable Anonymous Inner Class!! */;
        this.mainController.addNodeListListener((NodeListListener)nodeListListener);
        2 nodeSelectionListener = new /* Unavailable Anonymous Inner Class!! */;
        this.mainController.addNodeSelectionListListener((NodeSelectionListener)nodeSelectionListener);
        try {
            this.connectionService.subscribeConnectionStatusChanges(connectionInfo -> {
                if (connectionInfo.getConnectionId().equals("main")) {
                    LOGGER.info("Current state: {}", (Object)connectionInfo.getConnectionState());
                    switch (6.$SwitchMap$org$bidib$api$json$types$ConnectionPhase[connectionInfo.getConnectionState().getActualPhase().ordinal()]) {
                        case 1: {
                            LOGGER.info("The communication was opened.");
                            break;
                        }
                        case 2: {
                            LOGGER.info("The communication was closed. Remove all locos from the table.");
                            this.locoTableModel.removeAllLocos();
                            this.setSelectedNode(null);
                            break;
                        }
                    }
                }
            }, error -> LOGGER.warn("The connection status change caused an error.", error));
        }
        catch (Exception ex) {
            LOGGER.warn("Register controller as connection status listener failed.", (Throwable)ex);
        }
        this.messageAdapter = new /* Unavailable Anonymous Inner Class!! */;
        this.messageAdapter.setNode(this.selectedNode);
        this.messageAdapter.start();
        desktop.addDockableStateChangeListener((DockableStateChangeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void nodeLost(NodeInterface node) {
        if (node != null && node.equals(this.selectedNode)) {
            LOGGER.info("The selected node was removed. Clear the list of loco for node: {}", (Object)node);
            if (SwingUtilities.isEventDispatchThread()) {
                this.locoTableModel.removeAllLocos();
                this.setSelectedNode(null);
            } else {
                SwingUtilities.invokeLater(() -> {
                    this.locoTableModel.removeAllLocos();
                    this.setSelectedNode(null);
                });
            }
        }
    }

    public void setSelectedNode(NodeInterface node) {
        LOGGER.info("Set the selected node: {}", (Object)node);
        if (node != null && org.bidib.jbidibc.messages.utils.NodeUtils.hasCommandStationFunctions((long)node.getUniqueId())) {
            this.selectedNode = node;
            this.locoTableModel.setCsNodeSelected(true);
            if (this.locoTableView != null) {
                this.locoTableView.setDockTabName(node);
                this.locoService.loadLocoList(node);
                if (this.messageAdapter != null) {
                    this.messageAdapter.setNode(this.selectedNode);
                }
                if (this.selectedNode != null) {
                    this.queryCommandStationValue(this.selectedNode, CsQueryTypeEnum.LOCO_LIST, null);
                }
            }
        } else {
            this.selectedNode = null;
            this.locoTableModel.setCsNodeSelected(false);
            if (this.messageAdapter != null) {
                this.messageAdapter.setNode(this.selectedNode);
            }
        }
    }

    public void queryCommandStationList(CsQueryTypeEnum csQueryType, Integer locoAddress) {
        LOGGER.info("Remove all locos from table before query the loco list from command station, locoAddress: {}", (Object)locoAddress);
        this.queryCommandStationValue(this.selectedNode, csQueryType, locoAddress);
    }

    private void queryCommandStationValue(NodeInterface node, CsQueryTypeEnum csQueryType, Integer locoAddress) {
        LOGGER.info("Query the loco list from command station, csQueryType: {}, locoAddress: {}", (Object)csQueryType, (Object)locoAddress);
        if (node != null && node.getCommandStationNode() != null) {
            try {
                this.commandStationService.queryCommandStationValue("main", node.getCommandStationNode(), csQueryType, locoAddress);
            }
            catch (Exception ex) {
                LOGGER.warn("Query the loco list from command station failed.", (Throwable)ex);
            }
        } else {
            LOGGER.warn("No command station node available.");
        }
    }

    public void pushLocoToMouse(int entryId, int speedSteps, int address, String locoName) {
        if (entryId < 0 && entryId > 7) {
            throw new IllegalArgumentException("entryId is limited to values between 0..7");
        }
        int maxWidth = 10;
        String vendorName = String.format("XP_LOC_%d/8", entryId);
        String vendorValue = String.format("%d\\%d\\%s", speedSteps, address, StringUtils.truncate((String)locoName, (int)maxWidth));
        if (this.selectedNode != null) {
            try {
                LinkedList<ConfigurationVariable> cvList = new LinkedList<ConfigurationVariable>();
                cvList.add(new ConfigurationVariable(vendorName, vendorValue));
                List configVars = this.bidibNodeService.setConfigVariables("main", this.selectedNode, cvList);
                if (CollectionUtils.isEmpty((Collection)configVars)) {
                    LOGGER.warn("No changed CV values returned. Notify the user.");
                    throw new RuntimeException("No changed CV values returned. Push loco data to mouse failed.");
                }
                LOGGER.info("Received configVars: {}", (Object)configVars);
            }
            catch (Exception ex) {
                LOGGER.warn("Push the loco name to the mouse failed.", (Throwable)ex);
            }
        }
    }

    public void setLocoLibraryModel(LocoLibraryModel locoLibrary) {
        if (this.locoLibrary != null) {
            this.locoLibrary.removePropertyChangeListener("pushToMouse", (PropertyChangeListener)this);
        }
        this.locoLibrary = locoLibrary;
        if (this.locoLibrary != null) {
            this.locoLibrary.addPropertyChangeListener("pushToMouse", (PropertyChangeListener)this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (Boolean.TRUE.equals(evt.getNewValue())) {
            LOGGER.info("The push to mouse is now enabled. Start the process to publish the loco library.");
            if (this.locoLibrary != null) {
                int delay = 200;
                this.locoLibraryWorker.schedule(() -> {
                    LOGGER.info("Start push loco library to mouse.");
                    try {
                        this.locoLibrary.setExecutionStatus("Start push loco library to mouse.");
                        this.locoLibrary.setExecutionResult(LocoLibraryModel.ExecutionResult.PENDING);
                        int entryId = 0;
                        for (LocoListModel locoModel : this.locoLibrary.getLocoList()) {
                            LOGGER.info("Push loco data to mouse, loco: {}, entryId: {}", (Object)locoModel, (Object)entryId);
                            if (locoModel != null) {
                                String locoName = StringUtils.isNotBlank((CharSequence)locoModel.getLocoName()) ? locoModel.getLocoName() : Integer.toString(locoModel.getLocoAddress());
                                this.locoLibrary.setExecutionStatus("Push loco: " + locoName);
                                this.pushLocoToMouse(entryId, SpeedSteps.valueOf((SpeedSteps)locoModel.getSpeedSteps()), locoModel.getLocoAddress(), locoName);
                                LOGGER.info("Wait after push.");
                                try {
                                    Thread.sleep(50L);
                                }
                                catch (InterruptedException ex) {
                                    LOGGER.warn("Wait 50ms after push the loco to the mouse was interrupted.", (Throwable)ex);
                                }
                            } else {
                                LOGGER.info("No loco at index: {}", (Object)entryId);
                            }
                            ++entryId;
                        }
                        LOGGER.info("Finished push loco library to mouse.");
                        this.locoLibrary.setExecutionStatus("Finished push loco library to mouse.");
                        this.locoLibrary.setExecutionResult(LocoLibraryModel.ExecutionResult.PASSED);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Push loco library to mouse failed.", (Throwable)ex);
                        this.locoLibrary.setExecutionResult(LocoLibraryModel.ExecutionResult.FAILED);
                    }
                    finally {
                        this.locoLibrary.setPushToMouse(false);
                    }
                }, (long)delay, TimeUnit.MILLISECONDS);
            } else {
                LOGGER.info("The push to mouse is not enabled.");
            }
        }
    }

    public void openLocoDialog(LocoListModel locoModel) {
        LOGGER.info("Open the loco dialog for locoModel: {}", (Object)locoModel);
        CommandStationNodeInterface node = NodeUtils.findFirstCommandStationNode((Iterable)this.mainModel.getNodeProvider().getNodes());
        if (node != null) {
            ApplicationContext applicationContext = DefaultApplicationContext.getInstance();
            org.springframework.context.ApplicationContext ctx = (org.springframework.context.ApplicationContext)applicationContext.get("SpringContext", org.springframework.context.ApplicationContext.class);
            LocoControllerFactory locoControllerFactory = (LocoControllerFactory)ctx.getBean(LocoControllerFactory.class);
            LocoController locoController = locoControllerFactory.createLocoController(node, (JFrame)JOptionPane.getFrameForComponent(this.parent), this.mainModel.getNodeProvider());
            AddressData initialAddress = null;
            if (locoModel != null) {
                initialAddress = new AddressData(locoModel.getLocoAddress(), locoModel.getDirection() == DirectionStatus.FORWARD ? AddressTypeEnum.LOCOMOTIVE_FORWARD : AddressTypeEnum.LOCOMOTIVE_BACKWARD);
            }
            locoController.start(initialAddress, locoModel != null ? locoModel.getSpeedSteps() : null);
        }
    }

    public void openPomDialog(LocoListModel locoModel) {
        LOGGER.info("Open the POM dialog, locoModel: {}", (Object)locoModel);
        CommandStationNodeInterface node = NodeUtils.findFirstCommandStationNode((Iterable)this.mainModel.getNodeProvider().getNodes());
        if (node != null) {
            ApplicationContext applicationContext = DefaultApplicationContext.getInstance();
            org.springframework.context.ApplicationContext ctx = (org.springframework.context.ApplicationContext)applicationContext.get("SpringContext", org.springframework.context.ApplicationContext.class);
            PomProgrammerControllerFactory pomProgrammerControllerFactory = (PomProgrammerControllerFactory)ctx.getBean(PomProgrammerControllerFactory.class);
            PomProgrammerController pomProgrammerController = pomProgrammerControllerFactory.createPomProgrammerController(node, (JFrame)JOptionPane.getFrameForComponent(this.parent), new Point(0, 0));
            pomProgrammerController.addPomProgrammerControllerListener((PomProgrammerControllerListener)new /* Unavailable Anonymous Inner Class!! */);
            AddressData initialAddress = null;
            if (locoModel != null) {
                initialAddress = new AddressData(locoModel.getLocoAddress(), locoModel.getDirection() == DirectionStatus.FORWARD ? AddressTypeEnum.LOCOMOTIVE_FORWARD : AddressTypeEnum.LOCOMOTIVE_BACKWARD);
            }
            DockingDesktop desktop = (DockingDesktop)DefaultApplicationContext.getInstance().get("desktop", DockingDesktop.class);
            pomProgrammerController.start(desktop, initialAddress);
        }
    }
}

