/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.locolist.model;

import com.jgoodies.binding.beans.Model;
import com.jgoodies.common.collect.ArrayListModel;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.bidib.jbidibc.messages.DriveState;
import org.bidib.jbidibc.messages.enums.DirectionEnum;
import org.bidib.wizard.model.locolist.LocoListModel;
import org.bidib.wizard.model.status.DirectionStatus;
import org.bidib.wizard.model.status.SpeedSteps;
import org.bidib.wizard.mvc.locolist.controller.listener.LocoTableControllerListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocoTableModel
extends Model {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(LocoTableModel.class);
    public static final String PROPERTY_CS_NODE_SELECTED = "csNodeSelected";
    private final ArrayListModel<LocoListModel> locoArrayList;
    private boolean csNodeSelected;

    public LocoTableModel(LocoTableControllerListener locoTableController, ArrayListModel<LocoListModel> locoModelList) {
        this.locoArrayList = locoModelList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLoco(DriveState driveState) {
        ArrayListModel arrayListModel = this.locoArrayList;
        synchronized (arrayListModel) {
            int locoAddress = driveState.getAddress();
            LocoListModel loco = new LocoListModel(locoAddress);
            if (!this.locoArrayList.contains((Object)loco)) {
                LOGGER.info("Add loco to loco list: {}, driveState: {}", (Object)loco, (Object)driveState);
                this.toLocoModel(driveState, loco);
                this.locoArrayList.add((Object)loco);
            } else {
                LOGGER.warn("Loco is already in loco list: {}", (Object)loco);
                LocoListModel existing = (LocoListModel)IterableUtils.find((Iterable)this.locoArrayList, (Predicate)new /* Unavailable Anonymous Inner Class!! */);
                this.toLocoModel(driveState, existing);
                this.fireLocoChanged(existing);
            }
        }
    }

    private void fireLocoChanged(LocoListModel locoModel) {
        LOGGER.debug("The loco address has been changed.");
        int index = this.locoArrayList.indexOf((Object)locoModel);
        this.locoArrayList.fireContentsChanged(index);
    }

    private void toLocoModel(DriveState driveState, LocoListModel loco) {
        loco.setSpeed(driveState.getSpeed() & 0x7F);
        loco.setDirection(driveState.getDirection() == DirectionEnum.FORWARD ? DirectionStatus.FORWARD : DirectionStatus.BACKWARD);
        loco.setSpeedSteps(SpeedSteps.fromBidibFormat((int)driveState.getAddressFormat()));
        loco.setFunctions(driveState.getFunctions());
        loco.setOutputActive(driveState.getOutputActive() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLoco(int locoAddress) {
        ArrayListModel arrayListModel = this.locoArrayList;
        synchronized (arrayListModel) {
            LOGGER.info("Remove loco from loco list: {}", (Object)locoAddress);
            int index = this.locoArrayList.indexOf((Object)new LocoListModel(locoAddress));
            if (index > -1) {
                LocoListModel locoListModel = (LocoListModel)this.locoArrayList.remove(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllLocos() {
        ArrayListModel arrayListModel = this.locoArrayList;
        synchronized (arrayListModel) {
            LOGGER.info("Remove all locos from loco list.");
            if (SwingUtilities.isEventDispatchThread()) {
                this.internalRemoveAllLocos();
            } else {
                SwingUtilities.invokeLater(() -> this.internalRemoveAllLocos());
            }
        }
    }

    private void internalRemoveAllLocos() {
        this.locoArrayList.clear();
    }

    public void setDriveState(byte[] address, DriveState driveState) {
        LOGGER.info("Drive state was delivered: {}", (Object)driveState);
        if (driveState.getAddress() > 0) {
            this.addLoco(driveState);
        }
    }

    public ArrayListModel<LocoListModel> getLocoListModel() {
        return this.locoArrayList;
    }

    public List<LocoListModel> getLocos() {
        if (this.locoArrayList == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.locoArrayList);
    }

    public boolean isCsNodeSelected() {
        return this.csNodeSelected;
    }

    public void setCsNodeSelected(boolean csNodeSelected) {
        boolean oldValue = this.csNodeSelected;
        this.csNodeSelected = csNodeSelected;
        if (SwingUtilities.isEventDispatchThread()) {
            this.firePropertyChange(PROPERTY_CS_NODE_SELECTED, oldValue, csNodeSelected);
        } else {
            SwingUtilities.invokeLater(() -> this.firePropertyChange(PROPERTY_CS_NODE_SELECTED, oldValue, csNodeSelected));
        }
    }
}

