/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.pom.view.panel;

import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.jgoodies.validation.ValidationResultModel;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.bidib.jbidibc.messages.PomAddressData;
import org.bidib.jbidibc.messages.enums.PomOperation;
import org.bidib.jbidibc.messages.enums.PomProgState;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.view.validation.IconFeedbackPanel;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.mvc.pom.model.CurrentAddressBeanModel;
import org.bidib.wizard.mvc.pom.model.PomProgrammerModel;
import org.bidib.wizard.mvc.pom.model.ProgCommandAwareBeanModel;
import org.bidib.wizard.mvc.pom.model.command.PomOperationCommand;
import org.bidib.wizard.mvc.pom.model.listener.ProgCommandListener;
import org.bidib.wizard.mvc.pom.view.panel.AbstractPomPanel;
import org.bidib.wizard.mvc.pom.view.panel.PomProgStateConverter;
import org.bidib.wizard.mvc.pom.view.panel.PomResultProxyModel;
import org.bidib.wizard.mvc.pom.view.panel.PomValidationResultModel;
import org.bidib.wizard.mvc.pom.view.panel.listener.PomRequestListener;
import org.bidib.wizard.mvc.pom.view.panel.listener.PomResultListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public abstract class AbstractPomPanel<M extends ProgCommandAwareBeanModel>
implements PomResultListener {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    public static final int DEFAULT_TIMEOUT = 1000;
    public static final int DEFAULT_SUSI_READ_FIRST_TIMEOUT = 300;
    private static final String ENCODED_COLUMN_SPECS = "pref, 3dlu, pref, 3dlu, pref, 3dlu, fill:50dlu:grow";
    private static final String ENCODED_ROW_SPECS = "pref, 3dlu";
    private final List<PomRequestListener> listeners = new LinkedList();
    protected final PomProgrammerModel cvProgrammerModel;
    protected final PomResultProxyModel pomResultProxyModel;
    protected final JButton readButton = new JButton(Resources.getString(AbstractPomPanel.class, (String)"read"));
    protected final JButton writeButton = new JButton(Resources.getString(AbstractPomPanel.class, (String)"write"));
    protected ValueModel readButtonEnabled;
    protected ValueModel writeButtonEnabled;
    protected ValueModel currentOperationModel;
    protected JLabel currentOperationLabel;
    private ImageIcon progOperationErrorIcon;
    private ImageIcon progOperationSuccessfulIcon;
    private ImageIcon progOperationWaitIcon;
    protected ImageIcon progOperationUnknownIcon;
    private ImageIcon progOperationEmptyIcon;
    private JTextArea loggerArea;
    private static final String NEWLINE = "\n";
    protected boolean activeTab;
    private M progCommandAwareBeanModel;
    protected CurrentAddressBeanModel currentAddressBeanModel;
    private Timer readTimeout;
    private Object readTimeoutLock = new Object();

    public AbstractPomPanel(PomProgrammerModel cvProgrammerModel, CurrentAddressBeanModel currentAddressBeanModel) {
        this.cvProgrammerModel = cvProgrammerModel;
        this.currentAddressBeanModel = currentAddressBeanModel;
        this.pomResultProxyModel = new /* Unavailable Anonymous Inner Class!! */;
        this.initializeIcons();
    }

    private void initializeIcons() {
        this.progOperationErrorIcon = ImageUtils.createImageIcon(AbstractPomPanel.class, (String)"/icons/accessory-error.png");
        this.progOperationSuccessfulIcon = ImageUtils.createImageIcon(AbstractPomPanel.class, (String)"/icons/accessory-successful.png");
        this.progOperationWaitIcon = ImageUtils.createImageIcon(AbstractPomPanel.class, (String)"/icons/accessory-wait.png");
        this.progOperationUnknownIcon = ImageUtils.createImageIcon(AbstractPomPanel.class, (String)"/icons/information.png");
        this.progOperationEmptyIcon = ImageUtils.createImageIcon(AbstractPomPanel.class, (String)"/icons/empty.png");
    }

    protected void postConstruct() {
    }

    public ProgCommandAwareBeanModel getProgCommandAwareBeanModel() {
        return this.progCommandAwareBeanModel;
    }

    public void setProgCommandAwareBeanModel(M progCommandAwareBeanModel) {
        this.progCommandAwareBeanModel = progCommandAwareBeanModel;
    }

    public void addPomRequestListener(PomRequestListener l) {
        this.listeners.add(l);
    }

    protected List<PomRequestListener> getPomRequestListeners() {
        return this.listeners;
    }

    public void setActive(boolean active) {
        this.LOGGER.info("Set the active flag: {}", (Object)active);
        this.activeTab = active;
    }

    public boolean isActive() {
        return this.activeTab;
    }

    protected abstract void createWorkerPanel(FormBuilder var1, int[] var2, PomValidationResultModel var3);

    public JPanel createPanel(PomValidationResultModel parentValidationModel) {
        3 panel;
        this.cvProgrammerModel.addPropertyChangeListener((PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        FormBuilder builder = null;
        boolean debug = false;
        if (debug) {
            panel = new /* Unavailable Anonymous Inner Class!! */;
            builder = FormBuilder.create().columns(ENCODED_COLUMN_SPECS, new Object[0]).rows(ENCODED_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            panel = new /* Unavailable Anonymous Inner Class!! */;
            builder = FormBuilder.create().columns(ENCODED_COLUMN_SPECS, new Object[0]).rows(ENCODED_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        }
        builder.border((Border)Paddings.TABBED_DIALOG);
        int[] rowHolder = new int[]{1};
        this.createWorkerPanel(builder, rowHolder, parentValidationModel);
        int currentRow = rowHolder[0];
        currentRow += 2;
        this.currentOperationModel = new PropertyAdapter((Object)this.pomResultProxyModel, "pomProgState", true);
        ConverterValueModel valueConverterModel = new ConverterValueModel(this.currentOperationModel, (BindingConverter)new PomProgStateConverter());
        this.currentOperationLabel = WizardComponentFactory.createLabel((ValueModel)valueConverterModel);
        this.currentOperationLabel.setIcon(this.progOperationEmptyIcon);
        builder.appendRows("pref, 5dlu", new Object[0]);
        builder.add(Resources.getString(AbstractPomPanel.class, (String)"prog-result"), new Object[0]).xy(1, currentRow);
        builder.add((Component)this.currentOperationLabel).xyw(3, currentRow, 5);
        this.loggerArea = new JTextArea(20, 45);
        this.loggerArea.setFont(UIManager.getDefaults().getFont("Label.font"));
        JScrollPane scrollPane = new JScrollPane(20, 32);
        scrollPane.getViewport().add(this.loggerArea);
        this.loggerArea.setEditable(false);
        builder.appendRows("fill:200px:grow", new Object[0]);
        builder.add((Component)scrollPane).xyw(1, currentRow += 2, 7);
        this.doBindButtons();
        this.cvProgrammerModel.addProgCommandListener((ProgCommandListener)new /* Unavailable Anonymous Inner Class!! */);
        this.cvProgrammerModel.addPropertyChangeListener("cvValue", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        if (parentValidationModel != null) {
            parentValidationModel.addPropertyChangeListener("validState", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
            parentValidationModel.addPropertyChangeListener("validStateNoWarnOrErrors", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        JPanel panel2 = null;
        if (this.getValidationResultModel() != null) {
            this.LOGGER.debug("Create iconfeedback panel.");
            IconFeedbackPanel cvIconPanel = new IconFeedbackPanel(this.getValidationResultModel(), (JComponent)builder.build());
            FormBuilder feedbackBuilder = FormBuilder.create().columns("p:g", new Object[0]).rows("fill:p:grow", new Object[0]);
            feedbackBuilder.add((Component)cvIconPanel).xy(1, 1);
            panel2 = feedbackBuilder.build();
        } else {
            panel2 = builder.build();
        }
        this.postConstruct();
        return panel2;
    }

    protected void doBindButtons() {
        if (this.readButtonEnabled != null) {
            PropertyConnector.connect((Object)this.readButtonEnabled, (String)"value", (Object)this.readButton, (String)"enabled");
        }
        PropertyConnector.connect((Object)this.writeButtonEnabled, (String)"value", (Object)this.writeButton, (String)"enabled");
    }

    protected abstract void triggerValidation();

    protected ValidationResultModel getValidationResultModel() {
        return null;
    }

    public void addLogText(String logLine, Object ... args) {
        this.LOGGER.info("Add text to loggerArea, logLine: {}, args: {}", (Object)logLine, (Object)args);
        if (args != null) {
            logLine = MessageFormatter.arrayFormat((String)logLine, (Object[])args).getMessage();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS - ");
        StringBuilder message = new StringBuilder(sdf.format(new Date()));
        message.append(logLine).append(NEWLINE);
        if (SwingUtilities.isEventDispatchThread()) {
            this.loggerArea.append(message.toString());
            this.loggerArea.setCaretPosition(this.loggerArea.getDocument().getLength());
        } else {
            SwingUtilities.invokeLater((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void clearLogArea() {
        if (this.loggerArea != null) {
            this.loggerArea.setText(null);
        }
    }

    protected abstract Object getCurrentOperation();

    public void signalPomProgStateChanged(PomProgState pomProgState) {
        if (!this.isActive()) {
            this.LOGGER.info("Do not process result because this is not the active tab.");
            return;
        }
        switch (11.$SwitchMap$org$bidib$jbidibc$messages$enums$PomProgState[pomProgState.ordinal()]) {
            case 1: {
                this.currentOperationLabel.setIcon(this.progOperationSuccessfulIcon);
                this.addLogText("Prog operation passed: " + this.getCurrentOperation(), new Object[0]);
                this.enableInputElements();
                break;
            }
            case 2: 
            case 3: {
                this.currentOperationLabel.setIcon(this.progOperationErrorIcon);
                this.addLogText("Prog operation failed: {}", new Object[]{pomProgState.name()});
                this.enableInputElements();
                break;
            }
            case 4: {
                this.currentOperationLabel.setIcon(this.progOperationUnknownIcon);
                this.addLogText("Prog operation started: " + this.getCurrentOperation(), new Object[0]);
                break;
            }
            case 5: {
                this.currentOperationLabel.setIcon(this.progOperationWaitIcon);
                this.addLogText("Prog operation is running ...", new Object[0]);
            }
        }
    }

    protected void sendRequest(PomAddressData decoderAddress, PomOperation operation, int cvNumber, int cvValue) {
        this.cvProgrammerModel.setCvNumber(Integer.valueOf(cvNumber));
        this.cvProgrammerModel.setCvValue(null);
        for (PomRequestListener listener : this.getPomRequestListeners()) {
            listener.sendRequest((PomResultListener)this, decoderAddress, operation, cvNumber, cvValue);
        }
    }

    protected void disableInputElements() {
        this.LOGGER.info("Disable input elements.");
        if (this.readButtonEnabled != null) {
            this.readButtonEnabled.setValue((Object)false);
        }
        if (this.writeButtonEnabled != null) {
            this.writeButtonEnabled.setValue((Object)false);
        }
    }

    protected void enableInputElements() {
        this.LOGGER.info("Enable input elements.");
    }

    protected void fireNextCommand() {
        this.disableInputElements();
        List progCommands = this.progCommandAwareBeanModel.getProgCommands();
        this.LOGGER.info("Prepared commands for addressing the decoder: {}", (Object)progCommands);
        PomOperationCommand progCommand = (PomOperationCommand)progCommands.remove(0);
        this.progCommandAwareBeanModel.setCurrentOperation(progCommand.getPomOperation());
        switch (11.$SwitchMap$org$bidib$jbidibc$messages$enums$PomOperation[progCommand.getPomOperation().ordinal()]) {
            case 3: 
            case 4: {
                this.progCommandAwareBeanModel.setExecution(ProgCommandAwareBeanModel.ExecutionType.WRITE);
                break;
            }
            default: {
                this.progCommandAwareBeanModel.setExecution(ProgCommandAwareBeanModel.ExecutionType.READ);
            }
        }
        this.progCommandAwareBeanModel.setExecutingProgCommand(progCommand);
        this.addLogText("Prog write request: {}", new Object[]{progCommand});
        this.sendRequest(progCommand.getDecoderAddress(), progCommand.getPomOperation(), progCommand.getCvNumber(), progCommand.getCvValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startTimeoutControl(int timeout) {
        this.LOGGER.info("Timeout control is started, timeout: {}.", (Object)timeout);
        Object object = this.readTimeoutLock;
        synchronized (object) {
            if (this.readTimeout != null) {
                this.LOGGER.info("The timeout control is already assigned: {}", (Object)this.readTimeout);
                if (this.readTimeout.isRunning()) {
                    this.LOGGER.info("The timeout control is already running and will be stopped.");
                    this.readTimeout.stop();
                }
                this.readTimeout = null;
            }
            this.readTimeout = new Timer(timeout, (ActionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.readTimeout.setRepeats(false);
            this.readTimeout.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopTimeoutControl() {
        this.LOGGER.info("Timeout control is stopped.");
        Object object = this.readTimeoutLock;
        synchronized (object) {
            if (this.readTimeout != null) {
                this.LOGGER.info("The timeout control is assigned and will be stopped: {}", (Object)this.readTimeout);
                this.readTimeout.stop();
                this.readTimeout = null;
            }
        }
    }
}

