package org.bidib.wizard.dialog;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingConstants;

import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.text.JHyperlink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AboutDialog {

    private static final Logger LOGGER = LoggerFactory.getLogger(AboutDialog.class);

    private final Properties version = new Properties();

    /**
     * Create new instance of AboutDialog.
     * 
     * @param parentComponent
     *            the parent component
     * @throws IOException
     */
    public AboutDialog(Component parentComponent) throws IOException {

        try {
            version.load(getClass().getResourceAsStream("/META-INF/build-info.properties"));
        }
        catch (Exception ex) {
            LOGGER.warn("Load build info failed.", ex);
        }

        JOptionPane pane = new JOptionPane(getPanel(), JOptionPane.INFORMATION_MESSAGE);
        JDialog dialog =
            pane
                .createDialog(parentComponent,
                    Resources.getString(getClass(), "title") + " " + version.getProperty("build.name"));

        dialog.setVisible(true);
    }

    private JPanel getPanel() throws IOException {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();

        c.anchor = GridBagConstraints.FIRST_LINE_START;
        c.fill = GridBagConstraints.NONE;
        c.gridwidth = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(5, 5, 5, 5);
        result.add(new JLabel(version.getProperty("build.name")), c);

        c.gridwidth = 1;
        c.gridy++;
        result.add(new JSeparator(SwingConstants.HORIZONTAL), c);

        c.gridy++;
        result.add(new JLabel(Resources.getString(getClass(), "authors") + ":"), c);

        String authorsText =
            "<html>"
                + Stream.of(version.getProperty("build.projectauthor").split(";")).collect(Collectors.joining("<br/>"))
                + "</html>";
        // JTextArea authors =
        // new JTextArea(
        // );
        // authors.setFont(UIManager.getFont("Label.font"));
        // authors.setEditable(false);
        // authors.setOpaque(false);
        final JLabel authors = new JLabel(authorsText);
        c.gridx++;
        result.add(authors, c);

        c.gridx = 0;
        c.gridy++;
        result.add(new JLabel(Resources.getString(getClass(), "version") + ":"), c);

        c.gridx++;
        result.add(new JLabel(version.getProperty("build.version")), c);

        c.gridx = 0;
        c.gridy++;
        result.add(new JLabel(Resources.getString(getClass(), "build") + ":"), c);

        c.gridx++;
        result.add(new JLabel(version.getProperty("build.buildnumber-and-branch-info")), c);

        c.gridx = 0;
        c.gridy++;
        result.add(new JLabel(Resources.getString(getClass(), "date") + ":"), c);

        c.gridx++;

        final LocalDateTime parsed =
            LocalDateTime.parse(version.getProperty("build.time"), DateTimeFormatter.ISO_DATE_TIME);
        result.add(new JLabel(parsed.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))), c);

        c.gridx = 0;
        c.gridy++;
        result.add(new JLabel(Resources.getString(getClass(), "java") + ":"), c);

        c.gridx++;
        result.add(new JLabel(System.getProperty("java.version")), c);

        c.gridx = 0;
        c.gridy++;
        c.gridwidth = 2;

        JHyperlink famfamfamHyperLink = new JHyperlink();
        famfamfamHyperLink.setURL("http://www.famfamfam.com/lab/icons/silk/");
        famfamfamHyperLink.setText("Icons provided by http://www.famfamfam.com/lab/icons/silk/");
        result.add(famfamfamHyperLink, c);

        c.gridy++;
        c.gridwidth = 2;

        JHyperlink jideHyperLink = new JHyperlink();
        jideHyperLink.setURL("http://www.jidesoft.com");
        jideHyperLink.setText("Free JIDE license for open source project by http://www.jidesoft.com");
        result.add(jideHyperLink, c);

        c.gridy++;
        c.gridwidth = 2;
        result.add(new JLabel("<html>Images provided by:<br/>OpenDCC, Martin Welzel, Andreas Tillner"), c);
        c.gridy++;
        result.add(new JLabel("<html>NL translation: Bert van der Lugt Melsert"), c);

        c.gridy++;
        c.gridwidth = 2;

        // emojione
        JHyperlink freeEmojiIconsLink = new JHyperlink();
        freeEmojiIconsLink.setURL("https://www.emojione.com/");
        freeEmojiIconsLink.setText("Thanks to EmojiOne for providing free emoji icons");
        result.add(freeEmojiIconsLink, c);

        c.gridy++;
        c.gridwidth = 1;
        c.insets = new Insets(5, 5, 5, 0);

        // freepik
        JHyperlink freePikLink = new JHyperlink();
        freePikLink.setURL("https://www.freepik.com");
        freePikLink.setText("Icons made by Freepik");
        result.add(freePikLink, c);

        JHyperlink flaticonLink = new JHyperlink();
        flaticonLink.setURL("https://www.flaticon.com/");
        flaticonLink.setText("from www.flaticon.com");
        c.gridx++;
        result.add(flaticonLink, c);

        return result;
    }
}
